/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Collections;
import java.util.Map;
import javax.activation.DataHandler;
import javax.xml.bind.DatatypeConverter;
import javax.xml.namespace.QName;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.soap.MTOMFeature;
import net.webpdf.wsclient.AbstractWebService;
import net.webpdf.wsclient.ConverterWebService;
import net.webpdf.wsclient.WebServiceType;
import net.webpdf.wsclient.documents.SoapDocument;
import net.webpdf.wsclient.exception.Error;
import net.webpdf.wsclient.exception.Result;
import net.webpdf.wsclient.exception.ResultException;
import net.webpdf.wsclient.https.TLSContext;
import net.webpdf.wsclient.schema.stubs.WebserviceException;
import net.webpdf.wsclient.session.Session;
import net.webpdf.wsclient.session.SoapSession;

abstract class SoapWebService<T_WEBPDF_PORT, T_OPERATION_TYPE>
extends AbstractWebService<SoapDocument, T_OPERATION_TYPE, SoapDocument> {
    private static final String SSL_SOCKET_FACTORY = "com.sun.xml.internal.ws.transport.https.client.SSLSocketFactory";
    private final MTOMFeature feature = new MTOMFeature();
    private final QName qname;
    private final URI webserviceURL;
    T_WEBPDF_PORT port = null;
    private final TLSContext tlsContext;

    SoapWebService(Session session, WebServiceType webServiceType) throws ResultException {
        super(webServiceType, session);
        this.qname = new QName(webServiceType.getSoapNamespaceURI(), webServiceType.getSoapLocalPart());
        this.tlsContext = this.session.getTlsContext();
        this.webserviceURL = this.session.getURI(webServiceType.getSoapEndpoint());
    }

    abstract DataHandler processService() throws WebserviceException;

    @Override
    public SoapDocument process() throws ResultException {
        if (this.document == null) {
            throw new ResultException(Result.build(Error.NO_DOCUMENT));
        }
        if (this.operation == null) {
            throw new ResultException(Result.build(Error.NO_OPERATION_DATA));
        }
        try {
            this.applyOptions();
            DataHandler resultDataHandler = this.processService();
            if (resultDataHandler != null) {
                ((SoapDocument)this.document).save(resultDataHandler);
            }
            return (SoapDocument)this.document;
        }
        catch (IOException | WebserviceException ex) {
            throw new ResultException(Result.build(Error.SOAP_EXECUTION, ex));
        }
    }

    QName getQName() {
        return this.qname;
    }

    URL getWsdlDocumentLocation() throws ResultException {
        boolean useLocalWsdl = !(this.session instanceof SoapSession) || ((SoapSession)this.session).isUseLocalWsdl();
        try {
            URL url;
            URL uRL = url = useLocalWsdl ? ConverterWebService.class.getClassLoader().getResource("wsdl/" + this.webServiceType.getSoapEndpoint() + ".wsdl") : this.webserviceURL.toURL();
            if (url == null) {
                throw new ResultException(Result.build(Error.WSDL_INVALID_FILE));
            }
            return url;
        }
        catch (MalformedURLException ex) {
            throw new ResultException(Result.build(Error.WSDL_INVALID_URL, ex));
        }
    }

    MTOMFeature getFeature() {
        return this.feature;
    }

    private void applyOptions() throws ResultException {
        BindingProvider bindingProvider = (BindingProvider)this.port;
        if (this.session.getCredentials() != null) {
            String authHeader = "Basic " + DatatypeConverter.printBase64Binary((byte[])(this.session.getCredentials().getUserPrincipal().toString() + ":" + this.session.getCredentials().getPassword()).getBytes());
            this.headers.put("Authorization", Collections.singletonList(authHeader));
            if (!this.headers.isEmpty() && this.port != null) {
                Map requestContext = bindingProvider.getRequestContext();
                requestContext.put("javax.xml.ws.http.request.headers", this.headers);
                requestContext.put("javax.xml.ws.security.auth.username", this.session.getCredentials().getUserPrincipal().getName());
                requestContext.put("javax.xml.ws.security.auth.password", this.session.getCredentials().getPassword());
            }
        }
        bindingProvider.getRequestContext().put("javax.xml.ws.service.endpoint.address", this.webserviceURL.toString());
        if (this.tlsContext != null) {
            if (this.tlsContext.getSslContext() == null) {
                throw new ResultException(Result.build(Error.HTTPS_IO_ERROR));
            }
            bindingProvider.getRequestContext().put(SSL_SOCKET_FACTORY, this.tlsContext.getSslContext().getSocketFactory());
        }
    }
}

