/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.ant.task.xml;

import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.annotation.XmlAnyAttribute;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.namespace.QName;
import net.webpdf.ant.task.xml.XMLAttribute;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.UnknownElement;

@XmlRootElement(namespace="http://schema.webpdf.de/1.0/operation")
public class XMLElement {
    static final String OPERATION_NAMESPACE = "http://schema.webpdf.de/1.0/operation";
    private String xmlTag;
    private final List<XMLElement> children = new ArrayList<XMLElement>();
    private final List<XMLAttribute> attributes = new ArrayList<XMLAttribute>();

    private void initElement(UnknownElement unknownElement) {
        if (unknownElement == null) {
            return;
        }
        this.xmlTag = unknownElement.getTag();
        if (unknownElement.getChildren() != null) {
            for (UnknownElement unknownElement2 : unknownElement.getChildren()) {
                XMLElement childElement = new XMLElement();
                childElement.initElement(unknownElement2);
                this.children.add(childElement);
            }
        }
        if (unknownElement.getWrapper() != null) {
            for (Map.Entry entry : unknownElement.getWrapper().getAttributeMap().entrySet()) {
                if (!(entry.getValue() instanceof String)) continue;
                this.attributes.add(new XMLAttribute((String)entry.getKey(), (String)entry.getValue()));
            }
        }
    }

    @XmlAnyAttribute
    public Map<QName, String> getAttributes() {
        HashMap<QName, String> elements = new HashMap<QName, String>();
        for (XMLAttribute attribute : this.attributes) {
            elements.put(new QName(attribute.getKey()), attribute.getValue());
        }
        return elements;
    }

    @XmlAnyElement
    public List<JAXBElement<XMLElement>> getChildren() {
        ArrayList<JAXBElement<XMLElement>> childNodes = new ArrayList<JAXBElement<XMLElement>>();
        for (XMLElement element : this.children) {
            childNodes.add((JAXBElement<XMLElement>)new JAXBElement(new QName(OPERATION_NAMESPACE, element.xmlTag, "ns3"), XMLElement.class, (Object)element));
        }
        return childNodes;
    }

    private void initializeAttributes(Project project) throws BuildException {
        for (XMLAttribute attribute : this.attributes) {
            attribute.setValue(project.replaceProperties(attribute.getOriginalValue()));
        }
        for (XMLElement element : this.children) {
            element.initializeAttributes(project);
        }
    }

    public String prepareConfiguration(Project project) throws JAXBException {
        this.initializeAttributes(project);
        StringWriter writer = new StringWriter();
        Marshaller marshaller = JAXBContext.newInstance((Class[])new Class[]{XMLElement.class}).createMarshaller();
        marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
        marshaller.setProperty("jaxb.formatted.output", (Object)true);
        marshaller.marshal((Object)new JAXBElement(new QName(OPERATION_NAMESPACE, this.xmlTag, "ns3"), XMLElement.class, (Object)this), (Writer)writer);
        return writer.toString();
    }

    public static XMLElement parseUnknownElement(UnknownElement unknownElement) {
        XMLElement element = new XMLElement();
        element.initElement(unknownElement);
        return element;
    }
}

