/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.ant.task.variable;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.webpdf.ant.task.Task;
import net.webpdf.ant.task.variable.Variable;
import net.webpdf.ant.task.variable.VariableRole;

public class VariableMap {
    private final Task task;
    private final Map<VariableRole, Variable> variables = new HashMap<VariableRole, Variable>();
    private final List<Variable> unprocessedVariables = new ArrayList<Variable>();

    public VariableMap(Task task) {
        this.task = task;
    }

    public Variable getVar(VariableRole role) {
        if (role == null) {
            return null;
        }
        this.processVariables();
        return this.variables.get((Object)role);
    }

    public void add(Variable variable) {
        this.unprocessedVariables.add(variable);
    }

    private void processVariables() {
        if (this.unprocessedVariables.isEmpty()) {
            return;
        }
        for (Variable variable : this.unprocessedVariables) {
            if (variable == null || variable.getRole() == null) continue;
            variable.setOwningTask(this.task);
            this.variables.put(variable.getRole(), variable);
        }
        this.unprocessedVariables.clear();
    }

    public boolean isRoleTaken(VariableRole role) {
        this.processVariables();
        return this.variables.containsKey((Object)role);
    }
}

