/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.ant.task.logging;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import net.webpdf.ant.task.logging.LogLevel;
import net.webpdf.ant.task.logging.LogTag;
import org.apache.tools.ant.Task;

public class AntLogger {
    private final Task task;

    public AntLogger(Task task) {
        this.task = task;
    }

    private void log(String message, LogLevel logLevel, LogTag logTag) {
        this.task.log(this.prependLevel(this.prependLogTag(this.appendLocation(message), logTag), logLevel), logLevel.getLevel());
    }

    private void log(String message, Throwable ex, LogLevel logLevel, LogTag logTag) {
        StringBuilder messageBuilder = new StringBuilder();
        String msg = message;
        if (msg == null || msg.isEmpty()) {
            msg = this.getExMessage(ex);
        }
        messageBuilder.append(msg);
        if (logLevel.equals((Object)LogLevel.ERROR) && ex != null) {
            messageBuilder.append("\n");
            try (StringWriter writer = new StringWriter();
                 PrintWriter printer = new PrintWriter(writer);){
                ex.printStackTrace(printer);
                messageBuilder.append(writer.toString());
            }
            catch (IOException ignore) {
                // empty catch block
            }
        }
        this.task.log(this.prependLevel(this.prependLogTag(this.appendLocation(messageBuilder.toString()), logTag), logLevel), ex, logLevel.getLevel());
    }

    private void log(Throwable ex, LogLevel logLevel, LogTag logTag) {
        this.log(this.getExMessage(ex), ex, logLevel, logTag);
    }

    private String getExMessage(Throwable ex) {
        if (ex == null) {
            return "";
        }
        String msg = ex.getMessage();
        if (msg == null || msg.isEmpty()) {
            msg = this.getExMessage(ex.getCause());
        }
        return msg;
    }

    private String appendLocation(String message) {
        return message + "\n    " + LogTag.LOCATION.getTag() + " " + this.task.getLocation();
    }

    private String prependLevel(String message, LogLevel logLevel) {
        if (logLevel == LogLevel.INFO) {
            return message;
        }
        return logLevel.getMessage() + message;
    }

    private String prependLogTag(String message, LogTag logTag) {
        return logTag.getTag() + " " + message;
    }

    public void info(String message, LogTag logTag) {
        this.log(message, LogLevel.INFO, logTag);
    }

    public void info(LogTag logTag) {
        this.log("", LogLevel.INFO, logTag);
    }

    public void error(String message, LogTag logTag) {
        this.log(message, LogLevel.ERROR, logTag);
    }

    public void error(String message, Throwable ex, LogTag logTag) {
        this.log(message, ex, LogLevel.ERROR, logTag);
    }

    public void error(Throwable ex, LogTag logTag) {
        this.log(ex, LogLevel.ERROR, logTag);
    }

    public void warn(String message, LogTag logTag) {
        this.log(message, LogLevel.WARN, logTag);
    }

    public void warn(String message, Throwable ex, LogTag logTag) {
        this.log(message, ex, LogLevel.WARN, logTag);
    }

    public void warn(Throwable ex, LogTag logTag) {
        this.log(ex, LogLevel.WARN, logTag);
    }
}

