/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.ant.task.files;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;

public class TempDir {
    private static final String NEUTRAL_SUFFIX = ".temp";
    private static final String WEBPDF_ANT_PREFIX = "webPDF-ant_";
    private final List<File> createdTempFiles = new ArrayList<File>();
    private File tempDir;

    TempDir(File tempDir) {
        this.tempDir = tempDir;
    }

    public TempDir() {
        this(null);
    }

    File tryCreateTempFile() throws IOException {
        File tempFile = this.tempDir != null && this.tempDir.exists() && this.tempDir.isDirectory() && this.tempDir.canWrite() ? File.createTempFile(WEBPDF_ANT_PREFIX, NEUTRAL_SUFFIX, this.tempDir) : File.createTempFile(WEBPDF_ANT_PREFIX, NEUTRAL_SUFFIX);
        this.createdTempFiles.add(tempFile);
        return tempFile;
    }

    public void cleanTemp() {
        for (File tempFile : this.createdTempFiles) {
            FileUtils.deleteQuietly((File)tempFile);
        }
    }

    public File getTempDir() {
        if (this.tempDir == null) {
            return new File(System.getProperty("java.io.tmpdir"));
        }
        return this.tempDir;
    }
}

