/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.ant.task.files;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.webpdf.ant.task.files.IterativeTaskFile;
import net.webpdf.ant.task.files.TempDir;
import net.webpdf.ant.task.variable.Variable;
import net.webpdf.ant.task.variable.VariableRole;
import org.apache.commons.io.FileUtils;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.ResourceCollection;
import org.apache.tools.ant.types.resources.FileProvider;
import org.apache.tools.ant.types.resources.FileResource;
import org.apache.tools.ant.util.FileNameMapper;
import org.apache.tools.ant.util.IdentityMapper;
import org.apache.tools.ant.util.ResourceUtils;

public class IterativeTaskFileMap
implements Iterable<IterativeTaskFile> {
    private final List<ResourceCollection> resourceCollections = new ArrayList<ResourceCollection>();
    private List<IterativeTaskFile> taskFileList = new ArrayList<IterativeTaskFile>();
    private FileNameMapper fileNameMapper = null;
    private TempDir tempDir;
    private File targetDirectory;
    private File targetFile;
    private boolean resourceInitialized = false;

    public void setTempDir(File tempDir) throws BuildException {
        if (!(tempDir != null && tempDir.exists() && tempDir.canWrite() && tempDir.isDirectory())) {
            throw new BuildException("The given temporary directory is inaccessible.");
        }
        this.tempDir = new TempDir(tempDir);
    }

    public TempDir getTempDir() {
        if (this.tempDir == null) {
            this.tempDir = new TempDir();
        }
        return this.tempDir;
    }

    public void setTargetDirectory(File targetDirectory) throws BuildException {
        if (targetDirectory == null || !targetDirectory.exists() && !targetDirectory.mkdirs() || !targetDirectory.isDirectory() || !targetDirectory.canWrite()) {
            throw new BuildException("The given target directory is inaccessible.");
        }
        this.targetDirectory = targetDirectory;
    }

    public File getTargetDirectory() {
        return this.targetDirectory;
    }

    public void setTargetFile(File targetFile) {
        this.targetFile = targetFile;
    }

    public File getTargetFile() {
        return this.targetFile;
    }

    private FileNameMapper getMapper() {
        if (this.fileNameMapper == null) {
            this.fileNameMapper = new IdentityMapper();
        }
        return this.fileNameMapper;
    }

    private void parseResources() {
        for (ResourceCollection collection : this.resourceCollections) {
            if (collection instanceof FileResource) {
                FileResource fileResource = (FileResource)collection;
                if (!this.checkResourceExists((Resource)fileResource)) continue;
                this.mapFile(fileResource.getFile());
                continue;
            }
            if (collection instanceof FileSet) {
                FileSet files = (FileSet)collection;
                DirectoryScanner directoryScanner = files.getDirectoryScanner();
                for (String fileName : directoryScanner.getIncludedFiles()) {
                    this.mapFile(new File(directoryScanner.getBasedir(), fileName));
                }
                continue;
            }
            for (Resource resource : collection) {
                FileProvider fileProvider;
                if (!this.checkResourceExists(resource) || (fileProvider = (FileProvider)resource.as(FileProvider.class)) == null) continue;
                FileResource fileResource = ResourceUtils.asFileResource((FileProvider)fileProvider);
                this.mapFile(fileResource.getFile());
            }
        }
    }

    private boolean checkResourceExists(Resource resource) {
        return resource.isFilesystemOnly() && resource.isExists();
    }

    private void mapFile(File file) {
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            if (files != null) {
                for (File subFile : files) {
                    this.mapFile(subFile);
                }
            }
        } else {
            this.mapFile(file, file.getName());
        }
    }

    private void mapFile(File file, String mappedFileName) {
        String[] filenames = this.getMapper().mapFileName(mappedFileName);
        if (filenames != null && filenames.length >= 1) {
            this.taskFileList.add(new IterativeTaskFile(file, filenames[0], this.getTempDir()));
        }
    }

    public void add(ResourceCollection resourceCollection) {
        this.resourceCollections.add(resourceCollection);
    }

    public void setMapper(FileNameMapper fileNameMapper) throws BuildException {
        if (this.fileNameMapper != null && !(this.fileNameMapper instanceof IdentityMapper)) {
            throw new BuildException("Only one mapper may be set per task.");
        }
        this.fileNameMapper = fileNameMapper;
    }

    public void replaceWithInputVar(Variable input) throws IOException {
        File file;
        if (input != null && input.getValue() != null && VariableRole.INPUT.equals((Object)input.getRole()) && (file = new File(input.getValue())).exists() && file.isFile() && file.canRead()) {
            File tempFile = this.getTempDir().tryCreateTempFile();
            FileUtils.copyFile((File)file, (File)tempFile);
            this.taskFileList.clear();
            this.resourceCollections.clear();
            this.mapFile(tempFile, file.getName());
        }
    }

    @Override
    public Iterator<IterativeTaskFile> iterator() {
        if (!this.resourceInitialized) {
            this.parseResources();
            this.resourceInitialized = true;
        }
        return this.taskFileList.iterator();
    }
}

