/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.ant.task.files;

import java.io.File;
import java.io.IOException;
import net.webpdf.ant.task.files.TempDir;
import net.webpdf.ant.task.variable.Variable;
import org.apache.commons.io.FileUtils;
import org.apache.tools.ant.BuildException;

public class IterativeTaskFile {
    private final TempDir tempDir;
    private final File originalSourceFile;
    private final String targetFileName;
    private boolean preserveCurrentSource = true;
    private File currentSource;
    private File currentTarget;

    public IterativeTaskFile(File originalSourceFile, String targetFileName, TempDir tempDir) throws BuildException {
        if (originalSourceFile == null) {
            throw new BuildException("Incomplete source definition: source File has not been set.");
        }
        if (targetFileName == null) {
            throw new BuildException("Incomplete source definition: source File has not been set for: %s" + originalSourceFile.getAbsolutePath());
        }
        if (tempDir == null) {
            throw new BuildException("Incomplete source definition: temporary directory has not been set for: %s" + originalSourceFile.getAbsolutePath());
        }
        this.tempDir = tempDir;
        this.currentSource = this.originalSourceFile = originalSourceFile;
        this.targetFileName = targetFileName;
    }

    public void setCurrentSource(File currentSource, boolean preserveSource) {
        this.currentSource = currentSource;
        this.preserveCurrentSource = preserveSource;
    }

    public File getCurrentSource() {
        return this.currentSource;
    }

    public void preserveCurrentSource() {
        this.preserveCurrentSource = true;
    }

    public File getCurrentTarget() throws IOException {
        if (this.currentTarget == null) {
            this.currentTarget = this.tempDir.tryCreateTempFile();
        }
        return this.currentTarget;
    }

    public void prepareNextOperation() {
        if (this.currentTarget == null) {
            return;
        }
        if (!this.preserveCurrentSource) {
            this.tryDelete(this.currentSource);
        }
        this.preserveCurrentSource = false;
        this.currentSource = this.currentTarget;
        this.currentTarget = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File finalizeAndReset(File targetFile, File targetDirectory) throws IOException {
        try {
            File lastProcessed = this.getLastProcessed();
            if (targetFile != null && (!targetFile.exists() || targetFile.delete()) && targetFile.getParentFile().exists() && targetFile.getParentFile().canWrite()) {
                FileUtils.copyFile((File)lastProcessed, (File)targetFile);
                File file = targetFile;
                return file;
            }
            if (targetDirectory != null && targetDirectory.exists() && targetDirectory.isDirectory() && targetDirectory.canWrite()) {
                File result = new File(targetDirectory, this.targetFileName);
                FileUtils.copyFile((File)lastProcessed, (File)result);
                File file = result;
                return file;
            }
            File file = lastProcessed;
            return file;
        }
        finally {
            this.reset();
        }
    }

    File getLastProcessed() {
        return this.currentTarget != null ? this.currentTarget : this.currentSource;
    }

    public void reset() {
        if (!this.preserveCurrentSource) {
            this.tryDelete(this.currentSource);
        }
        this.tryDelete(this.currentTarget);
        this.currentTarget = null;
        this.currentSource = this.originalSourceFile;
        this.preserveCurrentSource();
    }

    public void dropCurrentTarget() {
        if (this.currentTarget != null) {
            this.tryDelete(this.currentTarget);
        }
        this.currentTarget = null;
    }

    private void tryDelete(File file) {
        if (!this.originalSourceFile.equals(file) && file != null && file.exists() && file.isFile() && file.canWrite()) {
            FileUtils.deleteQuietly((File)file);
        }
    }

    public void tryPublish(Variable variable) {
        if (this.currentTarget != null && this.currentTarget.exists() && this.currentTarget.isFile() && this.currentTarget.canRead()) {
            variable.setValue(this.currentTarget.getAbsolutePath().replaceAll("\\\\", "/"));
            variable.execute();
            this.currentTarget = null;
        }
    }
}

