/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.ant.task.credentials;

import net.webpdf.ant.task.credentials.NTCredentials;
import net.webpdf.ant.task.credentials.UserCredentials;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class CredentialsFactory {
    private CredentialsFactory() {
    }

    public static Credentials produceCredentials(Task credentialTask) throws BuildException {
        if (credentialTask instanceof NTCredentials) {
            NTCredentials credentials = (NTCredentials)credentialTask;
            try {
                return new org.apache.http.auth.NTCredentials(credentials.getUsername(), credentials.getPassword(), credentials.getWorkstation(), credentials.getDomain());
            }
            catch (IllegalArgumentException ex) {
                throw new BuildException((Throwable)ex);
            }
        }
        if (credentialTask instanceof UserCredentials) {
            UserCredentials credentials = (UserCredentials)credentialTask;
            try {
                return new UsernamePasswordCredentials(credentials.getUsername(), credentials.getPassword());
            }
            catch (IllegalArgumentException ex) {
                throw new BuildException((Throwable)ex);
            }
        }
        return null;
    }
}

