/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.ant;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.webpdf.ant.GroupTask;
import net.webpdf.ant.OperationTask;
import net.webpdf.ant.task.Task;
import net.webpdf.ant.task.TaskConfiguration;
import net.webpdf.ant.task.TaskName;
import net.webpdf.ant.task.credentials.NTCredentials;
import net.webpdf.ant.task.credentials.UserCredentials;
import net.webpdf.ant.task.files.IterativeTaskFile;
import net.webpdf.ant.task.logging.LogTag;
import net.webpdf.ant.task.variable.Variable;
import net.webpdf.ant.task.variable.VariableRole;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.TaskContainer;
import org.apache.tools.ant.types.ResourceCollection;
import org.apache.tools.ant.util.FileNameMapper;

public class WebPDFTask
extends Task
implements TaskContainer {
    private final List<org.apache.tools.ant.Task> tasks = new ArrayList<org.apache.tools.ant.Task>();

    public WebPDFTask() {
        super(TaskName.WEBPDF);
        this.setTaskConfiguration(new TaskConfiguration());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void execute() throws BuildException {
        if (this.getVariables().isRoleTaken(VariableRole.INPUT)) {
            try {
                this.getTaskConfiguration().getTaskFiles().replaceWithInputVar(this.getVariables().getVar(VariableRole.INPUT));
            }
            catch (IOException ex) {
                throw new BuildException(ex.getMessage(), (Throwable)ex, this.getLocation());
            }
        }
        try {
            for (IterativeTaskFile taskFile : this.getTaskConfiguration().getTaskFiles()) {
                this.getLogger().info(LogTag.WEBPDF_TASK);
                for (org.apache.tools.ant.Task task : this.tasks) {
                    this.processTask(task, taskFile);
                }
                try {
                    File target = taskFile.finalizeAndReset(this.getTaskConfiguration().getTaskFiles().getTargetFile(), this.getTaskConfiguration().getTaskFiles().getTargetDirectory());
                    if (this.getVariables().isRoleTaken(VariableRole.OUTPUT)) {
                        Variable targetVar = this.getVariables().getVar(VariableRole.OUTPUT);
                        targetVar.setValue(target.getAbsolutePath().replaceAll("\\\\", "/"));
                        targetVar.execute();
                    }
                    this.getLogger().info("Write to " + (target != null ? target.getAbsolutePath() : "FILE NAME UNKNOWN"), LogTag.TARGET);
                }
                catch (IOException ex) {
                    String message = "Creation of the final target file failed.";
                    this.getLogger().error(message, ex, LogTag.WEBPDF_TASK);
                    throw new BuildException(message, (Throwable)ex, this.getLocation());
                    return;
                }
            }
        }
        finally {
            this.getTaskConfiguration().getTaskFiles().getTempDir().cleanTemp();
        }
    }

    private void processTask(org.apache.tools.ant.Task task, IterativeTaskFile taskFile) throws BuildException {
        if (task instanceof GroupTask) {
            GroupTask group = (GroupTask)task;
            try {
                group.setFiles(taskFile);
                task.execute();
            }
            catch (BuildException ex) {
                if (this.getTaskConfiguration().isFailOnError()) {
                    taskFile.reset();
                    this.getLogger().error(ex, LogTag.WEBPDF_TASK);
                    throw ex;
                }
                this.getLogger().warn(ex, LogTag.WEBPDF_TASK);
            }
        } else {
            task.reconfigure();
            task.execute();
        }
    }

    public void addTask(org.apache.tools.ant.Task task) {
        if (task instanceof OperationTask) {
            if (this.getTaskConfiguration().isFailOnError()) {
                throw new BuildException("A webPDF task may not contain operations directly.");
            }
            this.getLogger().warn("A webPDF task may not contain operations directly.", LogTag.WEBPDF_TASK);
            return;
        }
        this.tasks.add(task);
    }

    public void add(ResourceCollection resourceCollection) {
        this.getTaskConfiguration().getTaskFiles().add(resourceCollection);
    }

    public void add(FileNameMapper fileNameMapper) {
        this.getTaskConfiguration().getTaskFiles().setMapper(fileNameMapper);
    }

    public void add(GroupTask task) {
        task.setTaskConfiguration(this.getTaskConfiguration());
        this.tasks.add(task);
    }

    public void add(UserCredentials credentials) {
        this.getTaskConfiguration().setCredentialsTask(credentials);
    }

    public void add(NTCredentials credentials) {
        this.getTaskConfiguration().setCredentialsTask(credentials);
    }

    public final void add(Variable variable) {
        this.getVariables().add(variable);
    }

    public void setFailOnError(boolean failOnError) {
        this.getTaskConfiguration().setFailOnError(failOnError);
    }

    public void setServerUrl(String serverUrl) {
        this.getTaskConfiguration().setServerUrl(serverUrl);
    }

    public void setTargetDir(File targetDir) {
        String path;
        String string = path = targetDir != null ? targetDir.getAbsolutePath() : " ";
        if (!(targetDir != null && targetDir.exists() && targetDir.canWrite() && targetDir.isDirectory())) {
            String errorMessage = String.format("The given target directory could not be accessed. %s", path);
            this.getLogger().error(errorMessage, LogTag.WEBPDF_TASK);
            throw new BuildException(errorMessage, this.getLocation());
        }
        this.getTaskConfiguration().getTaskFiles().setTargetDirectory(targetDir);
    }

    public void setTargetFile(File targetFile) {
        this.getTaskConfiguration().getTaskFiles().setTargetFile(targetFile);
    }

    public void setTempDir(File tempDir) {
        String path;
        String string = path = tempDir != null ? tempDir.getAbsolutePath() : " ";
        if (!(tempDir != null && tempDir.exists() && tempDir.canWrite() && tempDir.isDirectory())) {
            String errorMsg = String.format("The given temporary directory could not be accessed. %s", path);
            this.getLogger().error(errorMsg, LogTag.WEBPDF_TASK);
            throw new BuildException(errorMsg, this.getLocation());
        }
        this.getTaskConfiguration().getTaskFiles().setTempDir(tempDir);
    }
}

