/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.ant;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.xml.bind.JAXBException;
import javax.xml.transform.stream.StreamSource;
import net.webpdf.ant.task.Task;
import net.webpdf.ant.task.TaskName;
import net.webpdf.ant.task.logging.LogTag;
import net.webpdf.ant.task.xml.XMLElement;
import net.webpdf.wsclient.WebService;
import net.webpdf.wsclient.WebServiceFactory;
import net.webpdf.wsclient.WebServiceProtocol;
import net.webpdf.wsclient.documents.Document;
import net.webpdf.wsclient.documents.SoapDocument;
import net.webpdf.wsclient.exception.ResultException;
import net.webpdf.wsclient.session.Session;
import net.webpdf.wsclient.session.SessionFactory;
import org.apache.http.auth.Credentials;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.filters.StringInputStream;

public class OperationTask
extends Task {
    private final XMLElement xmlElement;

    OperationTask(XMLElement xmlElement, Project project) {
        super(TaskName.OPERATION);
        this.xmlElement = xmlElement;
        this.setProject(project);
    }

    @Override
    public void execute() throws BuildException {
        try {
            if (this.xmlElement == null || this.getFiles() == null || this.getTaskConfiguration() == null || this.getProject() == null) {
                throw new BuildException("The operation tasks definition is incomplete");
            }
            try (Session session = SessionFactory.createInstance((WebServiceProtocol)WebServiceProtocol.SOAP, (URL)this.getTaskConfiguration().getServerURL());
                 StringInputStream xmlInputStream = new StringInputStream(this.xmlElement.prepareConfiguration(this.getProject()));
                 SoapDocument soapDocument = new SoapDocument(this.getFiles().getCurrentSource().toURI(), this.getFiles().getCurrentTarget());){
                Credentials credentials = this.getTaskConfiguration().getCredentials();
                if (credentials != null) {
                    session.setCredentials(credentials);
                }
                WebService webservice = WebServiceFactory.createInstance((Session)session, (StreamSource)new StreamSource((InputStream)xmlInputStream));
                this.getLogger().info(webservice.getClass().getSimpleName(), LogTag.OPERATION);
                webservice.setDocument((Document)soapDocument);
                webservice.process();
            }
        }
        catch (ResultException ex) {
            this.getFiles().dropCurrentTarget();
            throw new BuildException(ex.getResult().getMessage() + " [EC " + ex.getResult().getCode() + "]", (Throwable)ex);
        }
        catch (IOException | JAXBException ex) {
            this.getFiles().dropCurrentTarget();
            throw new BuildException(ex.getMessage(), ex);
        }
    }
}

