/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.ant;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.webpdf.ant.OperationTask;
import net.webpdf.ant.task.Task;
import net.webpdf.ant.task.TaskName;
import net.webpdf.ant.task.logging.LogTag;
import net.webpdf.ant.task.variable.Variable;
import net.webpdf.ant.task.variable.VariableRole;
import net.webpdf.ant.task.xml.XMLElement;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.TaskContainer;
import org.apache.tools.ant.UnknownElement;

public class GroupTask
extends Task
implements TaskContainer {
    private List<OperationTask> operations = new ArrayList<OperationTask>();

    public GroupTask() {
        super(TaskName.GROUP);
    }

    @Override
    public void execute() {
        this.getLogger().info(LogTag.GROUP);
        if (this.getFiles() == null || this.getTaskConfiguration() == null || this.getProject() == null) {
            throw new BuildException("The operation tasks definition is incomplete");
        }
        File storedSource = null;
        if (this.getVariables().getVar(VariableRole.OUTPUT) != null) {
            storedSource = this.getFiles().getCurrentSource();
            this.getFiles().preserveCurrentSource();
        }
        this.initialize();
        this.processOperations();
        this.publishResult(storedSource);
    }

    private void initialize() {
        if (this.getVariables().isRoleTaken(VariableRole.INPUT)) {
            Variable input = this.getVariables().getVar(VariableRole.INPUT);
            input.execute();
            File srcFile = new File(this.getProject().replaceProperties(this.getProject().getProperty(input.getName())));
            if (!(srcFile.exists() && srcFile.isFile() && srcFile.canRead())) {
                if (this.getTaskConfiguration().isFailOnError()) {
                    throw new BuildException("The set source file can not be read: " + input);
                }
                this.getLogger().warn("The group is skipped, as the set source file can not be read: " + input, LogTag.GROUP);
                return;
            }
            this.getFiles().setCurrentSource(srcFile, true);
        }
    }

    private void processOperations() {
        Iterator<OperationTask> iter = this.operations.iterator();
        while (iter.hasNext()) {
            OperationTask operation = iter.next();
            try {
                operation.setFiles(this.getFiles());
                operation.setTaskConfiguration(this.getTaskConfiguration());
                operation.execute();
                if (this.getVariables().isRoleTaken(VariableRole.OUTPUT) && !iter.hasNext()) continue;
                this.getFiles().prepareNextOperation();
            }
            catch (BuildException ex) {
                if (this.getTaskConfiguration().isFailOnError()) {
                    throw ex;
                }
                this.getLogger().warn(ex.getMessage(), ex, LogTag.GROUP);
            }
        }
    }

    private void publishResult(File storedSource) {
        if (this.getVariables().isRoleTaken(VariableRole.OUTPUT) && storedSource != null) {
            this.getFiles().tryPublish(this.getVariables().getVar(VariableRole.OUTPUT));
            this.getFiles().setCurrentSource(storedSource, false);
        }
    }

    public void addTask(org.apache.tools.ant.Task task) {
        if (task instanceof UnknownElement) {
            this.add((UnknownElement)task);
        }
    }

    public final void add(UnknownElement task) {
        OperationTask operationTask = new OperationTask(XMLElement.parseUnknownElement(task), this.getProject());
        operationTask.setLocation(task.getLocation());
        this.operations.add(operationTask);
    }

    public final void add(Variable variable) {
        this.getVariables().add(variable);
    }
}

