package net.webpdf.ant.task;

/**
 * Stores names and types for the different defined task classes.
 */
public enum TaskName {
    WEBPDF("webPDF", "webPDF"),
    GROUP("group", "group"),
    OPERATION("operation", "operation"),
    VARIABLE("variable", "variable");

    private final String name;
    private final String type;

    /**
     * Stores the given name and type for the enumerated task class.
     *
     * @param name The name of the task.
     * @param type The type of the task.
     */
    TaskName(String name, String type) {
        this.name = name;
        this.type = type;
    }

    /**
     * Return the name of the defined task.
     *
     * @return The name of the defined task.
     */
    public String getName() {
        return name;
    }

    /**
     * Return the type of the defined task.
     *
     * @return The type of the defined task.
     */
    public String getType() {
        return type;
    }
}
