/*
 * Decompiled with CFR 0.152.
 */
package net.vieiro.toml;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.vieiro.toml.TOMLStringVisitor;
import net.vieiro.toml.antlr4.TomlParserInternal;
import net.vieiro.toml.antlr4.TomlParserInternalVisitor;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.Parser;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.atn.ATNConfigSet;
import org.antlr.v4.runtime.dfa.DFA;
import org.antlr.v4.runtime.misc.ParseCancellationException;
import org.antlr.v4.runtime.tree.ErrorNode;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeVisitor;
import org.antlr.v4.runtime.tree.RuleNode;
import org.antlr.v4.runtime.tree.TerminalNode;

final class TOMLVisitor
implements ANTLRErrorListener,
TomlParserInternalVisitor<Object> {
    private static final Level LEVEL = Level.FINE;
    private static final Logger LOG = Logger.getLogger(TOMLVisitor.class.getName());
    private HashSet<List<String>> standardTableKeys;
    private List<String> errors = new ArrayList<String>();
    private Map<String, Object> root;
    private Stack<List<Object>> arrayStack;
    private Map<String, Object> currentTable;
    private static final DateTimeFormatter DATETIME_WITH_SPACES = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");

    TOMLVisitor() {
        this.reset();
    }

    private void reset() {
        this.root = new HashMap<String, Object>();
        this.arrayStack = new Stack();
        this.currentTable = this.root;
        this.standardTableKeys = new HashSet();
    }

    public List<String> getErrors() {
        return this.errors;
    }

    public Map<String, Object> getRoot() {
        return this.root;
    }

    public void syntaxError(Recognizer<?, ?> rcgnzr, Object o, int line, int col, String message, RecognitionException re) {
        String error = String.format("Syntax error at %d:%d %s", line, col, message);
        this.errors.add(error);
    }

    public void reportAmbiguity(Parser recognizer, DFA dfa, int startIndex, int stopIndex, boolean exact, BitSet ambigAlts, ATNConfigSet configs) {
    }

    public void reportAttemptingFullContext(Parser parser, DFA dfa, int i, int i1, BitSet bitset, ATNConfigSet atncs) {
    }

    public void reportContextSensitivity(Parser parser, DFA dfa, int i, int i1, int i2, ATNConfigSet atncs) {
    }

    @Override
    public Object visitDocument(TomlParserInternal.DocumentContext ctx) {
        this.reset();
        if (ctx.expression() != null) {
            for (ParserRuleContext parserRuleContext : ctx.expression()) {
                parserRuleContext.accept((ParseTreeVisitor)this);
            }
        }
        return this.root;
    }

    @Override
    public Object visitExpression(TomlParserInternal.ExpressionContext ctx) {
        if (ctx.key_value() != null) {
            return ctx.key_value().accept(this);
        }
        if (ctx.table() != null) {
            return ctx.table().accept(this);
        }
        if (ctx.comment() != null) {
            return null;
        }
        if (ctx.exception != null) {
            throw ctx.exception;
        }
        throw TOMLVisitor.newPCException((ParserRuleContext)ctx, "Parser does not recognize this expression type");
    }

    @Override
    public Object visitComment(TomlParserInternal.CommentContext ctx) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Object visitKey(TomlParserInternal.KeyContext ctx) {
        if (ctx.simple_key() != null) {
            return ctx.simple_key().accept(this);
        }
        if (ctx.dotted_key() != null) {
            return ctx.dotted_key().accept(this);
        }
        throw TOMLVisitor.newPCException((ParserRuleContext)ctx, String.format("Unknown key type '%s'", ctx.getText()));
    }

    @Override
    public Object visitSimple_key(TomlParserInternal.Simple_keyContext ctx) {
        if (ctx.quoted_key() != null) {
            return ctx.quoted_key().accept(this);
        }
        if (ctx.unquoted_key() != null) {
            return ctx.unquoted_key().accept(this);
        }
        throw TOMLVisitor.newPCException((ParserRuleContext)ctx, "Unrecognized key type");
    }

    @Override
    public Object visitUnquoted_key(TomlParserInternal.Unquoted_keyContext ctx) {
        return TOMLStringVisitor.visitUnquoted_key(ctx);
    }

    @Override
    public Object visitQuoted_key(TomlParserInternal.Quoted_keyContext ctx) {
        return TOMLStringVisitor.visitQuoted_key(ctx);
    }

    @Override
    public Object visitDotted_key(TomlParserInternal.Dotted_keyContext ctx) {
        return ctx.simple_key().stream().map(simple_key -> simple_key.accept(this)).collect(Collectors.toList());
    }

    @Override
    public Object visitValue(TomlParserInternal.ValueContext ctx) {
        if (ctx.string() != null) {
            return ctx.string().accept(this);
        }
        if (ctx.integer() != null) {
            return ctx.integer().accept(this);
        }
        if (ctx.floating_point() != null) {
            return ctx.floating_point().accept(this);
        }
        if (ctx.bool_() != null) {
            return ctx.bool_().accept(this);
        }
        if (ctx.date_time() != null) {
            return ctx.date_time().accept(this);
        }
        if (ctx.array_() != null) {
            return ctx.array_().accept(this);
        }
        if (ctx.inline_table() != null) {
            return ctx.inline_table().accept(this);
        }
        throw TOMLVisitor.newPCException((ParserRuleContext)ctx, "Value could not be parsed");
    }

    @Override
    public Object visitString(TomlParserInternal.StringContext ctx) {
        return TOMLStringVisitor.visitString(ctx);
    }

    @Override
    public Object visitInteger(TomlParserInternal.IntegerContext ctx) {
        int radix = 10;
        String longText = null;
        if (ctx.DEC_INT() != null) {
            longText = ctx.DEC_INT().getText();
            radix = 10;
        } else if (ctx.HEX_INT() != null) {
            longText = ctx.HEX_INT().getText().substring(2);
            radix = 16;
        } else if (ctx.OCT_INT() != null) {
            longText = ctx.OCT_INT().getText().substring(2);
            radix = 8;
        } else if (ctx.BIN_INT() != null) {
            longText = ctx.BIN_INT().getText().substring(2);
            radix = 2;
        } else {
            throw new UnsupportedOperationException("Not supported yet.");
        }
        longText = longText.replace("_", "");
        return Long.valueOf(longText, radix);
    }

    @Override
    public Object visitFloating_point(TomlParserInternal.Floating_pointContext ctx) {
        if (ctx.NAN() != null) {
            return Double.NaN;
        }
        if (ctx.INF() != null) {
            return ctx.INF().getText().indexOf(45) == -1 ? Double.POSITIVE_INFINITY : Double.NEGATIVE_INFINITY;
        }
        String doubleText = ctx.FLOAT().getText();
        doubleText = doubleText.replace("_", "");
        return Double.valueOf(doubleText);
    }

    @Override
    public Object visitBool_(TomlParserInternal.Bool_Context ctx) {
        String BOOLEAN = ctx.BOOLEAN().getText();
        return Boolean.valueOf(BOOLEAN);
    }

    @Override
    public Object visitDate_time(TomlParserInternal.Date_timeContext ctx) {
        try {
            if (ctx.OFFSET_DATE_TIME() != null) {
                String OFFSET_DATE_TIME = ctx.OFFSET_DATE_TIME().getText();
                OFFSET_DATE_TIME = OFFSET_DATE_TIME.replace(" ", "T");
                try {
                    return OffsetDateTime.parse(OFFSET_DATE_TIME);
                }
                catch (DateTimeParseException dtpe) {
                    return OffsetDateTime.from(DateTimeFormatter.ISO_ZONED_DATE_TIME.parse(OFFSET_DATE_TIME));
                }
            }
            if (ctx.LOCAL_DATE_TIME() != null) {
                String LOCAL_DATE_TIME = ctx.LOCAL_DATE_TIME().getText();
                try {
                    return LocalDateTime.parse(LOCAL_DATE_TIME);
                }
                catch (DateTimeParseException dtpe) {
                    return LocalDateTime.from(DATETIME_WITH_SPACES.parse(LOCAL_DATE_TIME));
                }
            }
            if (ctx.LOCAL_DATE() != null) {
                String LOCAL_DATE = ctx.LOCAL_DATE().getText();
                return LocalDate.parse(LOCAL_DATE);
            }
            if (ctx.LOCAL_TIME() != null) {
                String LOCAL_TIME = ctx.LOCAL_TIME().getText();
                return LocalTime.parse(LOCAL_TIME);
            }
        }
        catch (Exception e) {
            throw TOMLVisitor.newPCException((ParserRuleContext)ctx, e);
        }
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Object visitInline_table(TomlParserInternal.Inline_tableContext ctx) {
        HashMap<String, Object> inlineTable = new HashMap<String, Object>();
        if (ctx.key() != null) {
            List listOfKeys = ctx.key().stream().map(k -> k.accept(this)).map(TOMLVisitor::toKey).collect(Collectors.toList());
            boolean equalOrRdefined = false;
            for (int i = 0; i < listOfKeys.size() && !equalOrRdefined; ++i) {
                List keyI = (List)listOfKeys.get(i);
                for (int j = i + 1; j < listOfKeys.size() && !equalOrRdefined; ++j) {
                    List keyJ = (List)listOfKeys.get(j);
                    if (!TOMLVisitor.isPrefix(keyI, keyJ)) continue;
                    throw TOMLVisitor.newPCException((ParserRuleContext)ctx, String.format("Redefinition of keys %s and %s", keyI, keyJ));
                }
            }
            List listOfValues = ctx.inline_value().stream().map(v -> v.accept(this)).collect(Collectors.toList());
            if (listOfKeys.size() != listOfValues.size()) {
                throw TOMLVisitor.newPCException((ParserRuleContext)ctx, String.format("Table does not have same number of keys (%d) and values (%d)", listOfKeys.size(), listOfValues.size()));
            }
            for (int i = 0; i < listOfKeys.size(); ++i) {
                List key = (List)listOfKeys.get(i);
                Object value = listOfValues.get(i);
                Map<String, Object> map = this.getTableForKeyValue(ctx, inlineTable, key, value);
            }
        }
        return Collections.unmodifiableMap(inlineTable);
    }

    @Override
    public Object visitInner_array(TomlParserInternal.Inner_arrayContext ctx) {
        if (ctx.inline_value() != null) {
            List innerArray = ctx.inline_value().stream().map(v -> v.accept(this)).collect(Collectors.toList());
            return Collections.unmodifiableList(innerArray);
        }
        return Collections.emptyList();
    }

    @Override
    public Object visitInline_value(TomlParserInternal.Inline_valueContext ctx) {
        if (ctx.string() != null) {
            return ctx.string().accept(this);
        }
        if (ctx.integer() != null) {
            return ctx.integer().accept(this);
        }
        if (ctx.floating_point() != null) {
            return ctx.floating_point().accept(this);
        }
        if (ctx.bool_() != null) {
            return ctx.bool_().accept(this);
        }
        if (ctx.date_time() != null) {
            return ctx.date_time().accept(this);
        }
        if (ctx.inner_array() != null) {
            return ctx.inner_array().accept(this);
        }
        if (ctx.inline_table() != null) {
            return ctx.inline_table().accept(this);
        }
        throw TOMLVisitor.newPCException((ParserRuleContext)ctx, "Unknown inline value type");
    }

    @Override
    public Object visitArray_(TomlParserInternal.Array_Context ctx) {
        ArrayList array = new ArrayList();
        this.arrayStack.push(array);
        if (ctx.array_values() != null) {
            ctx.array_values().accept(this);
        }
        this.arrayStack.pop();
        return Collections.unmodifiableList(array);
    }

    @Override
    public Object visitArray_values(TomlParserInternal.Array_valuesContext ctx) {
        List<Object> current = this.arrayStack.peek();
        if (ctx.value() != null) {
            current.add(ctx.value().accept(this));
        }
        if (ctx.array_values() != null) {
            ctx.array_values().accept(this);
        }
        return current;
    }

    @Override
    public Object visitComment_or_nl(TomlParserInternal.Comment_or_nlContext ctx) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Object visitTable(TomlParserInternal.TableContext ctx) {
        if (ctx.standard_table() != null) {
            return ctx.standard_table().accept(this);
        }
        if (ctx.array_table() != null) {
            return ctx.array_table().accept(this);
        }
        throw TOMLVisitor.newPCException((ParserRuleContext)ctx, "Unkonwn table type in parser");
    }

    @Override
    public Object visitKey_value(TomlParserInternal.Key_valueContext ctx) {
        List<String> key = TOMLVisitor.toKey(ctx.key().accept(this));
        LOG.log(LEVEL, "Visiting key-value with key {0}", key);
        if (ctx.exception != null) {
            throw TOMLVisitor.newPCException((ParserRuleContext)ctx, (Exception)((Object)ctx.exception));
        }
        if (ctx.value() == null) {
            throw TOMLVisitor.newPCException((ParserRuleContext)ctx, "Unkonwn table type in parser");
        }
        Object value = ctx.value().accept(this);
        Map<String, Object> table = this.getTableForKeyValue(ctx, key, value);
        return key;
    }

    @Override
    public Object visitStandard_table(TomlParserInternal.Standard_tableContext ctx) {
        List<String> key = TOMLVisitor.toKey(ctx.key().accept(this));
        LOG.log(LEVEL, "Visiting standard table with key {0}", key);
        Map<String, Object> newTable = this.createStandardTable(ctx, key);
        this.currentTable = newTable;
        this.standardTableKeys.add(key);
        return newTable;
    }

    @Override
    public Object visitArray_table(TomlParserInternal.Array_tableContext ctx) {
        List<String> key = TOMLVisitor.toKey(ctx.key().accept(this));
        LOG.log(LEVEL, "Visiting standard table with key {0}", key);
        Map<String, Object> newTable = this.createArrayTable(ctx, key);
        this.currentTable = newTable;
        this.standardTableKeys.add(key);
        return newTable;
    }

    public Object visit(ParseTree pt) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Object visitChildren(RuleNode rn) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Object visitTerminal(TerminalNode tn) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Object visitErrorNode(ErrorNode en) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    static ParseCancellationException newPCException(ParserRuleContext ctx, String errorDescription) {
        Token start = ctx.start;
        Token stop = ctx.stop;
        if (start.getLine() >= stop.getLine() && start.getCharPositionInLine() > stop.getCharPositionInLine()) {
            Token swap = start;
            start = stop;
            stop = swap;
        }
        String message = String.format("%s from line:col %d:%d to %d:%d", errorDescription, start.getLine(), start.getCharPositionInLine(), stop.getLine(), stop.getCharPositionInLine());
        return new ParseCancellationException(message);
    }

    static ParseCancellationException newPCException(ParserRuleContext ctx, Exception exception) {
        return TOMLVisitor.newPCException(ctx, exception.getMessage());
    }

    private List<String> combineKeys(List<String> a, List<String> b) {
        return Stream.concat(a.stream(), b.stream()).collect(Collectors.toList());
    }

    private static List<String> toKey(Object o) {
        return o instanceof List ? (List<String>)o : Arrays.asList(o.toString());
    }

    private Map<String, Object> getTableForKeyValue(ParserRuleContext ctx, List<String> key, Object value) {
        return this.getTableForKeyValue(ctx, this.currentTable, key, value);
    }

    private Map<String, Object> getTableForKeyValue(ParserRuleContext ctx, Map<String, Object> container, List<String> key, Object value) {
        List<String> prefix;
        if (key.size() > 1 && this.standardTableKeys.contains(prefix = key.subList(0, key.size() - 1))) {
            String message = String.format("Using dotted keys to add to %s after defining it is not allowed", prefix);
            throw TOMLVisitor.newPCException(ctx, message);
        }
        for (int i = 0; i < key.size() - 1; ++i) {
            String message;
            String part = key.get(i);
            Object o = container.get(part);
            if (o == null) {
                HashMap<String, HashMap<String, Object>> newTable = new HashMap<String, HashMap<String, Object>>();
                container.put(part, newTable);
                container = newTable;
                continue;
            }
            if (o instanceof Map) {
                container = (HashMap<String, HashMap<String, Object>>)o;
                continue;
            }
            if (o instanceof List) {
                message = String.format("Can't redefinee existing key %s (currently a list)", key);
                throw TOMLVisitor.newPCException(ctx, message);
            }
            message = String.format("Key part '%s' in '%s' refers to an existing scalar", part, key);
            throw TOMLVisitor.newPCException(ctx, message);
        }
        String lastKeyPart = key.get(key.size() - 1);
        if (container.containsKey(lastKeyPart)) {
            String message = String.format("Can't ovewrite existing table with key %s", key);
            throw TOMLVisitor.newPCException(ctx, message);
        }
        try {
            container.put(lastKeyPart, (HashMap<String, Object>)value);
        }
        catch (UnsupportedOperationException uoe) {
            String message = String.format("Can't ovewrite existing table with key %s", key);
            throw TOMLVisitor.newPCException(ctx, message);
        }
        return container;
    }

    private Map<String, Object> createStandardTable(TomlParserInternal.Standard_tableContext ctx, List<String> key) {
        String message;
        Map<String, HashMap<String, HashMap<String, Object>>> container = this.root;
        for (int i = 0; i < key.size() - 1; ++i) {
            String part = key.get(i);
            Object o = container.get(part);
            if (o == null) {
                HashMap<String, HashMap<String, HashMap<String, Object>>> newTable = new HashMap<String, HashMap<String, HashMap<String, Object>>>();
                container.put(part, newTable);
                container = newTable;
                continue;
            }
            if (o instanceof Map) {
                container = (HashMap<String, HashMap<String, HashMap<String, Object>>>)o;
                continue;
            }
            if (o instanceof List) {
                List arrayTable = (List)o;
                container = (Map)arrayTable.get(arrayTable.size() - 1);
                continue;
            }
            message = String.format("Key '%s' for a scalar value cannot be overwritten with key %s", part, key);
            throw TOMLVisitor.newPCException((ParserRuleContext)ctx, message);
        }
        String lastKeyPart = key.get(key.size() - 1);
        if (container.containsKey(lastKeyPart)) {
            if (!this.keyIsSuffixOfStandardTable(key)) {
                String message2 = String.format("Can't ovewrite existing standard table with key %s", key);
                throw TOMLVisitor.newPCException((ParserRuleContext)ctx, message2);
            }
            Object o = container.get(lastKeyPart);
            if (!(o instanceof Map)) {
                String message3 = String.format("Can't ovewrite existing table with key %s", key);
                throw TOMLVisitor.newPCException((ParserRuleContext)ctx, message3);
            }
            container = (Map)o;
            return container;
        }
        HashMap<String, Object> newTable = new HashMap<String, Object>();
        try {
            container.put(lastKeyPart, newTable);
        }
        catch (UnsupportedOperationException uoe) {
            message = String.format("Can't ovewrite existing table with key %s", key);
            throw TOMLVisitor.newPCException((ParserRuleContext)ctx, message);
        }
        return newTable;
    }

    private Map<String, Object> createArrayTable(TomlParserInternal.Array_tableContext ctx, List<String> key) {
        String message;
        Object o;
        Map<String, HashMap<String, ArrayList<Object>>> container = this.root;
        for (int i = 0; i < key.size() - 1; ++i) {
            String part = key.get(i);
            o = container.get(part);
            if (o == null) {
                HashMap newTable = new HashMap();
                container.put(part, newTable);
                container = newTable;
                continue;
            }
            if (o instanceof Map) {
                container = (HashMap)o;
                continue;
            }
            if (o instanceof List) {
                List arrayTable = (List)o;
                container = (Map)arrayTable.get(arrayTable.size() - 1);
                continue;
            }
            message = String.format("Key '%s' for a scalar value cannot be overwritten with key %s", part, key);
            throw TOMLVisitor.newPCException((ParserRuleContext)ctx, message);
        }
        String lastKeyPart = key.get(key.size() - 1);
        List<HashMap<String, Object>> arrayTable = null;
        if (container.containsKey(lastKeyPart)) {
            o = container.get(lastKeyPart);
            if (!(o instanceof List)) {
                message = String.format("Can't ovewrite existing table with key %s", key);
                throw TOMLVisitor.newPCException((ParserRuleContext)ctx, message);
            }
            arrayTable = (List)o;
        } else {
            arrayTable = new ArrayList();
            try {
                container.put(lastKeyPart, (HashMap<String, ArrayList<Object>>)((Object)arrayTable));
            }
            catch (UnsupportedOperationException uoe) {
                message = String.format("Can't ovewrite existing table with key %s", key);
                throw TOMLVisitor.newPCException((ParserRuleContext)ctx, message);
            }
        }
        HashMap<String, Object> newTable = new HashMap<String, Object>();
        try {
            arrayTable.add(newTable);
        }
        catch (UnsupportedOperationException uoe) {
            String message2 = String.format("Can't ovewrite existing table with key %s", key);
            throw TOMLVisitor.newPCException((ParserRuleContext)ctx, message2);
        }
        return newTable;
    }

    static boolean isPrefix(List<String> min, List<String> max) {
        if (min.size() > max.size()) {
            return TOMLVisitor.isPrefix(max, min);
        }
        boolean equalElements = true;
        for (int i = 0; i < min.size() && equalElements; ++i) {
            equalElements = equalElements && min.get(i).equals(max.get(i));
        }
        return equalElements;
    }

    private boolean keyIsSuffixOfStandardTable(List<String> key) {
        for (List<String> standardKey : this.standardTableKeys) {
            if (key.size() >= standardKey.size()) continue;
            boolean isSuffix = true;
            for (int i = 0; i < key.size() && isSuffix; isSuffix &= key.get(i).equals(standardKey.get(i)), ++i) {
            }
            if (!isSuffix) continue;
            return true;
        }
        return false;
    }
}

