/*
 * Decompiled with CFR 0.152.
 */
package net.vieiro.toml;

import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.vieiro.toml.TOMLJSON;
import net.vieiro.toml.TOMLSimpleQuery;

public final class TOML {
    final Map<String, Object> root;
    final List<String> errors;

    TOML(Map<String, Object> root, List<String> errors) {
        this.root = root;
        this.errors = Collections.unmodifiableList(errors);
    }

    public List<String> getErrors() {
        return this.errors;
    }

    public Map<String, Object> getRoot() {
        return this.root;
    }

    public String toString() {
        return this.root == null ? "null" : this.root.toString();
    }

    private <T> Optional<T> get(String path, Class<T> clazz) {
        return TOMLSimpleQuery.get(this.root, path, clazz);
    }

    public Optional<String> getString(String path) {
        return this.get(path, String.class);
    }

    public Optional<Long> getLong(String path) {
        return this.get(path, Long.class);
    }

    public Optional<Double> getDouble(String path) {
        return this.get(path, Double.class);
    }

    public Optional<List> getArray(String path) {
        return this.get(path, List.class);
    }

    public Optional<Boolean> getBoolean(String path) {
        return this.get(path, Boolean.class);
    }

    public Optional<Instant> getInstant(String path) {
        return this.get(path, Instant.class);
    }

    public Optional<OffsetDateTime> getOffsetDateTime(String path) {
        return this.get(path, OffsetDateTime.class);
    }

    public Optional<LocalDateTime> getLocalDateTime(String path) {
        return this.get(path, LocalDateTime.class);
    }

    public Optional<LocalDate> getLocalDate(String path) {
        return this.get(path, LocalDate.class);
    }

    public Optional<LocalTime> getLocalTime(String path) {
        return this.get(path, LocalTime.class);
    }

    public Optional<Map<String, Object>> getTable(String path) {
        Optional<Map> map = this.get(path, Map.class);
        if (map.isPresent()) {
            Map mapOO = map.get();
            return Optional.of(mapOO);
        }
        return Optional.empty();
    }

    public Optional<List<Map<String, Object>>> getTableArray(String path) {
        Optional<List> list = this.getArray(path);
        if (list.isPresent()) {
            List tables = list.get();
            return Optional.of(tables);
        }
        return Optional.empty();
    }

    public void writeJSON(Writer out) throws IOException {
        TOMLJSON.write(this.root, out, false);
    }

    public void writeJSON(PrintStream out) throws IOException {
        PrintWriter pw = new PrintWriter(out){

            @Override
            public void close() {
            }
        };
        this.writeJSON(pw);
        pw.flush();
    }
}

