/*
 * Copyright (c) 2016, Peter Rader. All rights reserved.
 *  ___ ___               __                 ______         __     __  __         __
 * |   |   |.-----..----.|  |_ .-----..----.|   __ \.--.--.|  |--.|  ||__|.-----.|  |--.
 * |   |   ||  -__||  __||   _||  _  ||   _||    __/|  |  ||  _  ||  ||  ||__ --||     |
 *  \_____/ |_____||____||____||_____||__|  |___|   |_____||_____||__||__||_____||__|__|
 *
 * http://www.gnu.org/licenses/gpl-3.0.html
 */
package net.vectorpublish.desktop.vp.article.text;

public interface TextChunkCouncillor {

	/**
	 * Vote for or against the split of a text.
	 * <p>
	 * Text will contains only parts that not have been splitted yet.
	 * 
	 * @param text
	 *            The text left to split.
	 * @param splitBeforeIndex
	 *            The index to split the text (never 0)
	 * @return <code>true</code> if the character on that index is not allowed
	 *         to be in a new line, <code>false</code> if the character on that
	 *         index is allowed to be in the next line.
	 */
	boolean hasVeto(String text, int splitBeforeIndex);

}
