/*
 * Copyright (c) 2016, Peter Rader. All rights reserved.
 *  ___ ___               __                 ______         __     __  __         __
 * |   |   |.-----..----.|  |_ .-----..----.|   __ \.--.--.|  |--.|  ||__|.-----.|  |--.
 * |   |   ||  -__||  __||   _||  _  ||   _||    __/|  |  ||  _  ||  ||  ||__ --||     |
 *  \_____/ |_____||____||____||_____||__|  |___|   |_____||_____||__||__||_____||__|__|
 *
 * http://www.gnu.org/licenses/gpl-3.0.html
 */
package net.vectorpublish.desktop.vp.article;

import java.io.File;
import java.io.IOException;
import java.util.List;

import net.vectorpublish.desktop.vp.api.InheritanceExclusion;

public interface TextReader extends InheritanceExclusion<InheritanceExclusion.CDIBean> {
	/**
	 * Returns the paragraphs found in the {@link File} or <code>null</code> if
	 * the {@link File} could not be read.
	 * 
	 * @param f
	 *            The File to read from.
	 * @return The paragraphs or <code>null</code> if the document could not be
	 *         read.
	 * @throws IOException
	 *             If an file has no read-permissions, has been removed
	 *             meanwhile, is too large or the physical device has been
	 *             removed or is defect.
	 */
	List<String> read(File f) throws IOException;
}
