/*
 * Copyright (c) 2016, Peter Rader. All rights reserved.
 *  ___ ___               __                 ______         __     __  __         __
 * |   |   |.-----..----.|  |_ .-----..----.|   __ \.--.--.|  |--.|  ||__|.-----.|  |--.
 * |   |   ||  -__||  __||   _||  _  ||   _||    __/|  |  ||  _  ||  ||  ||__ --||     |
 *  \_____/ |_____||____||____||_____||__|  |___|   |_____||_____||__||__||_____||__|__|
 *
 * http://www.gnu.org/licenses/gpl-3.0.html
 */
package net.vectorpublish.desktop.vp.article;

import java.util.List;

import net.vectorpublish.desktop.vp.api.ui.MouseParticipant;
import net.vectorpublish.desktop.vp.api.vpd.ModificationContext;
import net.vectorpublish.desktop.vp.api.vpd.ModificationContext.LayerNodeImpl;
import net.vectorpublish.desktop.vp.split.SplitNode;

public class ArticleNode extends LayerNodeImpl {

	private final Article a;

	public ArticleNode(ModificationContext ctx, SplitNode parent, List<String> paragraphs) {
		ctx.super(parent);
		a = new Article(parent, paragraphs, ctx.getDocument());
	}

	@Override
	public Article getParticipant() {
		return a;
	}

	@Override
	public boolean getAllowsChildren() {
		return false;
	}

	@Override
	public String toString() {
		return a.toString();
	}
}
