/*
 * Copyright (c) 2016, Peter Rader. All rights reserved.
 *  ___ ___               __                 ______         __     __  __         __
 * |   |   |.-----..----.|  |_ .-----..----.|   __ \.--.--.|  |--.|  ||__|.-----.|  |--.
 * |   |   ||  -__||  __||   _||  _  ||   _||    __/|  |  ||  _  ||  ||  ||__ --||     |
 *  \_____/ |_____||____||____||_____||__|  |___|   |_____||_____||__||__||_____||__|__|
 *
 * http://www.gnu.org/licenses/gpl-3.0.html
 */
package net.vectorpublish.desktop.vp.article;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Image;
import java.awt.geom.Rectangle2D.Float;
import java.util.List;

import javax.swing.ImageIcon;

import net.vectorpublish.desktop.vp.DefaultI8nImageFactory;
import net.vectorpublish.desktop.vp.Startup;
import net.vectorpublish.desktop.vp.api.DrawParticipant;
import net.vectorpublish.desktop.vp.api.layer.IllegalParentException;
import net.vectorpublish.desktop.vp.api.ui.MouseParticipant;
import net.vectorpublish.desktop.vp.api.vpd.DocumentNode;
import net.vectorpublish.desktop.vp.api.vpd.ModificationContext.LayerNodeImpl;
import net.vectorpublish.desktop.vp.api.vpd.VectorPublishNode;
import net.vectorpublish.desktop.vp.article.text.TextChunkCalculator;
import net.vectorpublish.desktop.vp.io.VPDocumentNode;
import net.vectorpublish.desktop.vp.pd.official.RelativeKeyframeRecalculator;
import net.vectorpublish.desktop.vp.pd.official.TechnicalMouseDrag;
import net.vectorpublish.desktop.vp.pd.official.VectorPublishGraphics;
import net.vectorpublish.desktop.vp.split.Split;
import net.vectorpublish.desktop.vp.split.SplitNode;
import net.vectorpublish.desktop.vp.ui.ImageKey;
import net.vectorpublish.desktop.vp.ui.i8n.I8nImageFactory;

public class Article implements DrawParticipant {

	private final SplitNode parent;
	private List<String> paragraphs;
	private final DocumentNode doc;
	private static Image tooWide;
	private static Image littleHeight;

	@SuppressWarnings("deprecation")
	public Article(SplitNode parent, List<String> paragraphs, DocumentNode documentNode) {
		this.parent = parent;
		this.paragraphs = paragraphs;
		this.doc = documentNode;
		if (tooWide == null) {
			I8nImageFactory bean = Startup.context.getBean(I8nImageFactory.class);
			tooWide = bean.get(ArticleTexts.NS, ImageKey.get("inplace_too_wide"), false).getImage();
			littleHeight = bean.get(ArticleTexts.NS, ImageKey.get("inplace_little_height"), false).getImage();
		}
	}

	@Override
	public Cursor updateMouse(int markerX, int markerY, float docRelX, float docRelY, RelativeKeyframeRecalculator rel,
			TechnicalMouseDrag pressedLMBSince) {
		return null;
	}

	public List<String> getParagraphs() {
		return paragraphs;
	}

	public void setParagraphs(List<String> paragraphs) {
		this.paragraphs = paragraphs;
	}

	@Override
	public Dimension getDimensions() {
		return null;
	}

	@Override
	public boolean opacity() {
		return false;
	}

	@Override
	public void paint(VectorPublishGraphics g, int documentWidth, int documentHeight) {
		FontMetrics fm = g.getFontMetrics();
		g.setColor(Color.black);
		Float rect;
		try {
			VectorPublishNode ppNode = doc.findSelfOrChildByPaintParticipant(this);
			rect = Split.calculateRectangle((LayerNodeImpl) ppNode);
		} catch (IllegalParentException e) {
			rect = null;
		}
		int lines = 0;
		boolean tooHigh = false;
		if (rect != null) {
			int y = (int) rect.y;
			LOOP: for (String paragraph : paragraphs) {

				TextChunkCalculator tbc = new TextChunkCalculator(rect.width, paragraph, fm);
				while (tbc.hasNext()) {
					y += fm.getHeight();
					if (y > rect.y + rect.height) {
						tooHigh = true;
						break LOOP;
					}
					String string = tbc.next();
					g.drawString(string, rect.x, y);
					lines++;
				}
				y += fm.getHeight() / 2;
			}
		}
		doc.paintChildren(this, g, documentWidth, documentHeight);
		int imageX = 0;
		if (rect != null && lines > 3) {
			if (rect.width > fm.stringWidth("a") * fm.getHeight() * 3) {
				if (tooWide != null) {
					g.drawImage(tooWide, (int) rect.x, (int) rect.y, null);
					imageX += tooWide.getWidth(null);
				}
			}
			if (tooHigh) {
				if (littleHeight != null) {
					g.drawImage(littleHeight, (int) rect.x + imageX, (int) rect.y, null);
					imageX += littleHeight.getWidth(null);
				}
			}
		}
	}

	@Override
	public void paintOutside(VectorPublishGraphics graphics, RelativeKeyframeRecalculator relativeRecalculator,
			int documentWidth, int documentHeight) {
		doc.paintChildrenOuter(this, graphics, relativeRecalculator, documentWidth, documentHeight);
	}

	@Override
	public String toString() {
		String first = paragraphs.iterator().next();
		return first.substring(0, Math.min(first.length() - 1, 40));
	}
}
