/*
 * Copyright (c) 2016, Peter Rader. All rights reserved.
 *  ___ ___               __                 ______         __     __  __         __
 * |   |   |.-----..----.|  |_ .-----..----.|   __ \.--.--.|  |--.|  ||__|.-----.|  |--.
 * |   |   ||  -__||  __||   _||  _  ||   _||    __/|  |  ||  _  ||  ||  ||__ --||     |
 *  \_____/ |_____||____||____||_____||__|  |___|   |_____||_____||__||__||_____||__|__|
 *
 * http://www.gnu.org/licenses/gpl-3.0.html
 */
package net.vectorpublish.desktop.vp.ah;

import java.util.List;

import net.vectorpublish.desktop.vp.api.history.ReadOnlyHistoryStepDataBean;

public class SetArticleData implements ReadOnlyHistoryStepDataBean {

	private final List<Integer> indexs;
	private final List<String> paragraphs;

	public SetArticleData(List<Integer> nodeToImmutableIndex, List<String> lines) {
		this.indexs = nodeToImmutableIndex;
		this.paragraphs = lines;
	}

	public List<String> getParagraphs() {
		return paragraphs;
	}

	public List<Integer> getIndexs() {
		return indexs;
	}
}
