/*
 * Copyright (c) 2016, Peter Rader. All rights reserved.
 *  ___ ___               __                 ______         __     __  __         __
 * |   |   |.-----..----.|  |_ .-----..----.|   __ \.--.--.|  |--.|  ||__|.-----.|  |--.
 * |   |   ||  -__||  __||   _||  _  ||   _||    __/|  |  ||  _  ||  ||  ||__ --||     |
 *  \_____/ |_____||____||____||_____||__|  |___|   |_____||_____||__||__||_____||__|__|
 *
 * http://www.gnu.org/licenses/gpl-3.0.html
 */
package net.vectorpublish.desktop.vp;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;

import javax.inject.Named;

import net.vectorpublish.desktop.vp.article.TextReader;

@Named
public class TextFileReader implements TextReader {

	private static final String EMPTY = "";

	@Override
	public List<String> read(File f) throws IOException {
		if (!f.getName().endsWith(".nfo") && !f.getName().endsWith(".asc") && !f.getName().endsWith(".txt")
				&& !f.getName().endsWith(".text") && !f.getName().endsWith(".me") && !f.getName().endsWith(".txt.bak")
				&& f.getName().contains(".")) {
			return null;
		}

		LinkedList<String> lst = new LinkedList<>();
		FileReader fr = new FileReader(f);
		BufferedReader br = new BufferedReader(fr);
		String line, lastLine = null;
		String paragraphCandidate = "";
		while ((line = br.readLine()) != null) {
			if (EMPTY.equals(line)) {
				lst.add(paragraphCandidate);
				paragraphCandidate = "";
			} else {
				paragraphCandidate += line;
			}
			lastLine = line;
		}
		if (!paragraphCandidate.equals("")) {
			lst.add(paragraphCandidate);
		}
		br.close();
		return lst;
	}
}
