/*
 * Copyright (c) 2016, Peter Rader. All rights reserved.
 *  ___ ___               __                 ______         __     __  __         __
 * |   |   |.-----..----.|  |_ .-----..----.|   __ \.--.--.|  |--.|  ||__|.-----.|  |--.
 * |   |   ||  -__||  __||   _||  _  ||   _||    __/|  |  ||  _  ||  ||  ||__ --||     |
 *  \_____/ |_____||____||____||_____||__|  |___|   |_____||_____||__||__||_____||__|__|
 *
 * http://www.gnu.org/licenses/gpl-3.0.html
 */
package net.vectorpublish.desktop.vp;

import javax.inject.Named;

import net.vectorpublish.desktop.vp.article.text.TextChunkCouncillor;

@Named
public class BlockSplitInNumber implements TextChunkCouncillor {

	@Override
	public boolean hasVeto(String text, int splitAtIndex) {
		// check if in number;
		char before = text.charAt(splitAtIndex-1);
		char after = text.charAt(splitAtIndex);
		return before>='0' & before<='9'& after>='0' & after<='9' ;
	}

}
