/*
 * Decompiled with CFR 0.152.
 */
package net.vatov.ampl.solver.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.List;
import java.util.Scanner;
import net.vatov.ampl.solver.io.InvalidUserInputException;
import net.vatov.ampl.solver.io.SolverIOException;
import net.vatov.ampl.solver.io.UserIO;

public class StdUserIO
implements UserIO {
    private InputStream in;
    private PrintStream out;

    StdUserIO(InputStream in, PrintStream out) {
        this.in = in;
        this.out = out;
    }

    @Override
    public Integer getChoice(List<String> options, Integer defaultOption, String question) {
        int i = 1;
        for (String option : options) {
            this.out.println(String.format("[%d]:\n%s", i, option));
            ++i;
        }
        Integer ret = this.getInt(defaultOption, question);
        if (null == ret || ret < 1 || ret > options.size()) {
            throw new InvalidUserInputException("Invalid choice " + ret);
        }
        return ret;
    }

    @Override
    public Integer getInt(Integer defaultValue, String question) {
        if (null != defaultValue) {
            this.out.print(String.format("%s [%d]: ", question, defaultValue));
            Integer ret = this.getInt(true);
            if (null == ret) {
                return defaultValue;
            }
            return ret;
        }
        this.out.print(question + ": ");
        return this.getInt(false);
    }

    private Integer getInt(boolean hasDefault) {
        Scanner scanner = new Scanner(this.in);
        String line = scanner.nextLine();
        if ("".equals(line) && hasDefault) {
            return null;
        }
        try {
            return Integer.parseInt(line);
        }
        catch (NumberFormatException e) {
            throw new InvalidUserInputException(e.getMessage());
        }
    }

    @Override
    public Boolean getYesNo(Boolean defaultValue, String question) {
        if (null != defaultValue) {
            this.out.print(String.format("%s [%s]: ", question, defaultValue != false ? "yes" : "no"));
        } else {
            this.out.print(question + ": ");
        }
        Scanner scanner = new Scanner(this.in);
        String line = scanner.nextLine();
        if (line == null || line.trim().isEmpty()) {
            if (defaultValue != null) {
                return defaultValue;
            }
            throw new InvalidUserInputException("Input missing");
        }
        return line.trim().equalsIgnoreCase("yes");
    }

    @Override
    public void refreshData(Object data) {
        this.out.println(data);
    }

    @Override
    public void pause(String question) {
        this.out.println(question + ": ");
        Scanner scanner = new Scanner(this.in);
        scanner.nextLine();
    }

    public void message(String question) {
        this.out.println(question + ": ");
    }

    public void close() {
        try {
            this.in.close();
        }
        catch (IOException e) {
            throw new SolverIOException(e);
        }
        this.out.close();
    }
}

