/*
 * Decompiled with CFR 0.152.
 */
package net.vatov.ampl.solver.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.vatov.ampl.model.Expression;
import net.vatov.ampl.model.ModelException;
import net.vatov.ampl.model.NodeValue;
import net.vatov.ampl.model.SymbolDeclaration;
import net.vatov.ampl.solver.impl.PolinomException;

public class Util {
    static List<SymbolDeclaration> getSymRefs(Expression e, List<SymbolDeclaration> symRefs) {
        switch (e.getType()) {
            case DOUBLE: {
                return symRefs;
            }
            case SYMREF: {
                symRefs.add(e.getSymRef());
                return symRefs;
            }
            case TREE: {
                Expression[] expressions;
                for (Expression ex : expressions = e.getTreeValue().getOperands()) {
                    Util.getSymRefs(ex, symRefs);
                }
                return symRefs;
            }
        }
        throw new ModelException(e.getType().toString());
    }

    static Map<SymbolDeclaration, Double> getPolinomCoeff(Expression e, Map<SymbolDeclaration, Double> coeffs) {
        return Util.getPolinomCoeff(e, coeffs, NodeValue.OperationType.PLUS);
    }

    static Map<SymbolDeclaration, Double> getPolinomCoeff(Expression e, Map<SymbolDeclaration, Double> coeffs, NodeValue.OperationType parentOp) {
        SymbolDeclaration sd = null;
        if (Util.isNormalMonom(e)) {
            Double coef = 0.0;
            int sign = 1;
            if (NodeValue.OperationType.MINUS == parentOp) {
                sign = -1;
            }
            if (e.getTreeValue().getOperands()[0].getType().equals((Object)Expression.ExpressionType.DOUBLE)) {
                coef = e.getTreeValue().getOperands()[0].getValue() * (double)sign;
                sd = e.getTreeValue().getOperands()[1].getSymRef();
            } else {
                coef = e.getTreeValue().getOperands()[1].getValue() * (double)sign;
                sd = e.getTreeValue().getOperands()[0].getSymRef();
            }
            if (coeffs.containsKey(sd)) {
                throw new PolinomException(sd.getName());
            }
            coeffs.put(sd, coef);
        } else if (e.getType().equals((Object)Expression.ExpressionType.SYMREF)) {
            sd = e.getSymRef();
            if (coeffs.containsKey(sd)) {
                throw new PolinomException(sd.getName());
            }
            coeffs.put(sd, 1.0);
        } else if (e.getType().equals((Object)Expression.ExpressionType.TREE)) {
            NodeValue.OperationType op = e.getTreeValue().getOperation();
            if (NodeValue.OperationType.PLUS != op && NodeValue.OperationType.MINUS != op) {
                throw new PolinomException(op.toString());
            }
            for (Expression ex : e.getTreeValue().getOperands()) {
                Util.getPolinomCoeff(ex, coeffs, op);
            }
        } else {
            throw new PolinomException(e.getType().toString());
        }
        return coeffs;
    }

    static boolean isNormalMonom(Expression e) {
        return e.getType().equals((Object)Expression.ExpressionType.TREE) && e.getTreeValue().getOperation() == NodeValue.OperationType.MULT && 2 == e.getTreeValue().getOperands().length && e.getTreeValue().getOperands()[0].getType().equals((Object)Expression.ExpressionType.SYMREF) ^ e.getTreeValue().getOperands()[1].getType().equals((Object)Expression.ExpressionType.SYMREF) && e.getTreeValue().getOperands()[0].getType().equals((Object)Expression.ExpressionType.DOUBLE) ^ e.getTreeValue().getOperands()[1].getType().equals((Object)Expression.ExpressionType.DOUBLE);
    }

    static double[] sortCoeffs(List<SymbolDeclaration> sds, Expression e) {
        Map<SymbolDeclaration, Double> polinomCoeff = Util.getPolinomCoeff(e, new HashMap<SymbolDeclaration, Double>(sds.size()));
        double[] coeffs = new double[sds.size()];
        int idx = 0;
        for (SymbolDeclaration sd : sds) {
            coeffs[idx] = !polinomCoeff.containsKey(sd) ? 0.0 : polinomCoeff.get(sd);
            ++idx;
        }
        return coeffs;
    }
}

