/*
 * Decompiled with CFR 0.152.
 */
package net.vatov.ampl.solver;

import java.util.ArrayList;
import java.util.Arrays;
import net.vatov.ampl.model.ConstraintDeclaration;
import net.vatov.ampl.model.Expression;
import net.vatov.ampl.model.NodeValue;
import net.vatov.ampl.model.ObjectiveDeclaration;
import net.vatov.ampl.model.OptimModel;
import net.vatov.ampl.model.SymbolDeclaration;
import net.vatov.ampl.solver.InterpreterException;
import org.apache.commons.math3.analysis.function.Acosh;
import org.apache.commons.math3.analysis.function.Asinh;
import org.apache.commons.math3.analysis.function.Atanh;
import org.apache.commons.math3.util.Precision;

public class OptimModelInterpreter {
    private final OptimModel model;
    private final Acosh acosh = new Acosh();
    private final Asinh asinh = new Asinh();
    private final Atanh atanh = new Atanh();

    public OptimModelInterpreter(OptimModel model) {
        this.model = model;
    }

    public void initialBind() {
        ArrayList symbolDeclarations = this.model.getSymbolDeclarations();
        for (SymbolDeclaration sd : symbolDeclarations) {
            Double exprVal = this.evaluateExpression(sd.getValue());
            if (null == exprVal) continue;
            sd.setBindValue(exprVal);
        }
    }

    public Boolean evaluateConstraint(int index) {
        ConstraintDeclaration cd = (ConstraintDeclaration)this.model.getConstraints().get(index);
        Double aExpr = this.evaluateExpression(cd.getaExpr());
        Double bExpr = this.evaluateExpression(cd.getbExpr());
        switch (cd.getRelop()) {
            case EQ: {
                return aExpr.equals(bExpr);
            }
            case GE: {
                return aExpr >= bExpr;
            }
            case LE: {
                return aExpr <= bExpr;
            }
        }
        throw new InterpreterException(cd.getRelop().name() + " not supported");
    }

    public Double evaluateGoal(int index) {
        return this.evaluateExpression(((ObjectiveDeclaration)this.model.getObjectives().get(index)).getExpression());
    }

    public Double evaluateExpression(Expression expr) {
        if (null == expr) {
            return null;
        }
        switch (expr.getType()) {
            case DOUBLE: {
                return expr.getValue();
            }
            case SYMREF: {
                Double value = expr.getSymRef().getBindValue();
                if (null == value) {
                    throw new InterpreterException(expr.getSymRef() + " undefined");
                }
                return expr.getSymRef().getBindValue();
            }
            case TREE: {
                NodeValue nodeValue = expr.getTreeValue();
                Expression[] operands = nodeValue.getOperands();
                NodeValue.OperationType operation = nodeValue.getOperation();
                switch (operation) {
                    case PLUS: {
                        return this.evaluateExpression(operands[0]) + this.evaluateExpression(operands[1]);
                    }
                    case MINUS: {
                        return this.evaluateExpression(operands[0]) - this.evaluateExpression(operands[1]);
                    }
                    case MULT: {
                        return this.evaluateExpression(operands[0]) * this.evaluateExpression(operands[1]);
                    }
                    case DIV_SLASH: {
                        return this.evaluateExpression(operands[0]) / this.evaluateExpression(operands[1]);
                    }
                    case MOD: {
                        return this.evaluateExpression(operands[0]) % this.evaluateExpression(operands[1]);
                    }
                    case POW: {
                        return Math.pow(this.evaluateExpression(operands[0]), this.evaluateExpression(operands[1]));
                    }
                    case UNARY_MINUS: {
                        return -this.evaluateExpression(operands[0]).doubleValue();
                    }
                    case UNARY_PLUS: {
                        return this.evaluateExpression(operands[0]);
                    }
                    case BUILTIN_FUNCTION: {
                        return this.evaluateBuiltinFunction(expr.getTreeValue().getBuiltinFunction(), operands);
                    }
                }
                throw new InterpreterException("Not implemented");
            }
        }
        throw new InterpreterException("Unknown type " + expr.getType());
    }

    private Double evaluateBuiltinFunction(NodeValue.BuiltinFunction f, Expression[] operands) {
        switch (f) {
            case ABS: {
                return Math.abs(this.evaluateExpression(operands[0]));
            }
            case ACOS: {
                return Math.acos(this.evaluateExpression(operands[0]));
            }
            case ACOSH: {
                return this.acosh.value(this.evaluateExpression(operands[0]).doubleValue());
            }
            case ASIN: {
                return Math.asin(this.evaluateExpression(operands[0]));
            }
            case ASINH: {
                return this.asinh.value(this.evaluateExpression(operands[0]).doubleValue());
            }
            case ATAN: {
                return Math.atan(this.evaluateExpression(operands[0]));
            }
            case ATAN2: {
                return Math.atan2(this.evaluateExpression(operands[0]), this.evaluateExpression(operands[1]));
            }
            case ATANH: {
                return this.atanh.value(this.evaluateExpression(operands[0]).doubleValue());
            }
            case CEIL: {
                return Math.ceil(this.evaluateExpression(operands[0]));
            }
            case COS: {
                return Math.cos(this.evaluateExpression(operands[0]));
            }
            case CTIME: {
                throw new InterpreterException("Still working only with double as expression type");
            }
            case EXP: {
                return Math.exp(this.evaluateExpression(operands[0]));
            }
            case FLOOR: {
                return Math.floor(this.evaluateExpression(operands[0]));
            }
            case LOG: {
                return Math.log(this.evaluateExpression(operands[0]));
            }
            case LOG10: {
                return Math.log10(this.evaluateExpression(operands[0]));
            }
            case MAX: {
                double[] vals = this.evaluateAndSort(operands);
                return vals[vals.length - 1];
            }
            case MIN: {
                double[] vals = this.evaluateAndSort(operands);
                return vals[0];
            }
            case PRECISION: {
                return Precision.round((double)this.evaluateExpression(operands[0]), (int)this.evaluateExpression(operands[1]).intValue());
            }
            case ROUND: {
                if (operands.length > 1) {
                    return Precision.round((double)this.evaluateExpression(operands[0]), (int)this.evaluateExpression(operands[1]).intValue());
                }
                return Math.round(this.evaluateExpression(operands[0]));
            }
            case SIN: {
                return Math.sin(this.evaluateExpression(operands[0]));
            }
            case SINH: {
                return Math.sinh(this.evaluateExpression(operands[0]));
            }
            case SQRT: {
                return Math.sqrt(this.evaluateExpression(operands[0]));
            }
            case TAN: {
                return Math.tan(this.evaluateExpression(operands[0]));
            }
            case TANH: {
                return Math.tanh(this.evaluateExpression(operands[0]));
            }
            case TIME: {
                return Long.valueOf(System.currentTimeMillis()).doubleValue();
            }
            case TRUNC: {
                int precision = 0;
                if (operands.length > 1) {
                    precision = this.evaluateExpression(operands[1]).intValue();
                }
                return Precision.round((double)this.evaluateExpression(operands[0]), (int)precision, (int)1);
            }
        }
        throw new InterpreterException("Unknown builtin function " + f);
    }

    private double[] evaluateAndSort(Expression[] operands) {
        double[] vals = new double[operands.length];
        for (int i = 0; i < operands.length; ++i) {
            vals[i] = this.evaluateExpression(operands[i]);
        }
        Arrays.sort(vals);
        return vals;
    }
}

