/*
 * Decompiled with CFR 0.152.
 */
package net.utsuro.mask;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParsePosition;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.chrono.JapaneseChronology;
import java.time.chrono.JapaneseDate;
import java.time.chrono.JapaneseEra;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.utsuro.mask.DataMask;
import net.utsuro.mask.MaskingRule;
import net.utsuro.mask.MaskingUtil;

public class TypeConverter
implements DataMask {
    private static final DateTimeFormatter NUMYEAR_FORMATTER = DateTimeFormatter.ofPattern("yyyy");
    private static final DateTimeFormatter NUMYEARMONTH_FORMATTER = DateTimeFormatter.ofPattern("yyyyMM");
    private static final DateTimeFormatter NUMDATE_FORMATTER = DateTimeFormatter.ofPattern("yyyyMMdd");
    private static final DateTimeFormatter NUMDATETIME_FORMATTER = DateTimeFormatter.ofPattern("yyyyMMddHHmmss");
    private static final DateTimeFormatter NUMTIME_FORMATTER = DateTimeFormatter.ofPattern("HHmmss");
    private static final DateTimeFormatter JISDATETIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    private static final DateTimeFormatter JPDATE_FORMATTER = DateTimeFormatter.ofPattern("yyyy/MM/dd");
    private static final DateTimeFormatter JPDATETIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy/MM/dd HH:mm:ss");
    private static final DateTimeFormatter JPTIME_FORMATTER = DateTimeFormatter.ofPattern("HH:mm:ss");
    private static final Pattern YEARMONTH_PATTERN = Pattern.compile("^([0-9]{4})[-/\\.\u5e74]([0-9]{1,2})([-/\\.\u6708])*$");
    private static final Pattern DATE_PATTERN = Pattern.compile("^([0-9]{4})[-/\\.\u5e74]([0-9]{1,2})[-/\\.\u6708]([0-9]{1,2})(\u65e5)*$");
    private static final Pattern DATETIME_PATTERN = Pattern.compile("^([0-9]{4})[-/\\.\u5e74]([0-9]{1,2})[-/\\.\u6708]([0-9]{1,2})[\u65e5]* ([0-9]{1,2})[:\u6642]([0-9]{1,2})([:\u5206]([0-9]{1,2})[\u79d2]*)*$");
    private static final Pattern TIME_PATTERN = Pattern.compile("^([0-9]{1,2})[:\u6642]([0-9]{1,2})([:\u5206]([0-9]{1,2})[\u79d2]*)*$");
    private static Map<Class<?>, Class<?>> primitiveClassMap = new HashMap();

    @Override
    public Object execute(Object src, MaskingRule rule) throws Exception {
        return TypeConverter.convert(src, rule);
    }

    public static Object convert(Object src, MaskingRule rule) throws Exception {
        Class<?> clazz;
        if (rule == null || src == null) {
            return src;
        }
        if (rule.getToClassName() == null || rule.getToClassName().isEmpty()) {
            throw new IllegalArgumentException("\u578b\u5909\u63db\u5148\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
        }
        Object obj = null;
        try {
            clazz = Class.forName(rule.getToClassName());
        }
        catch (ClassNotFoundException | IllegalArgumentException | SecurityException e) {
            throw new IllegalArgumentException(String.format("\u578b\u5909\u63db\u5148\u306e\u6307\u5b9a %s \u306b\u554f\u984c\u304c\u3042\u308a\u307e\u3059\u3002", rule.getToClassName()), e);
        }
        if (clazz == String.class && clazz == src.getClass()) {
            String s = (String)src;
            if (rule.useUpperCaseKana()) {
                s = MaskingUtil.toUpperHalfKana(s);
                s = MaskingUtil.toUpperWideKana(s);
                s = MaskingUtil.toUpperHiragana(s);
            }
            if (rule.useHalfKana()) {
                s = MaskingUtil.hiraganaToWideKana(s);
                s = MaskingUtil.wideKanaToHalfKana(s);
            }
            if (rule.useWideKana()) {
                s = MaskingUtil.halfKanaToWideKana(s);
                s = MaskingUtil.hiraganaToWideKana(s);
            }
            if (rule.useHiragana()) {
                s = MaskingUtil.halfKanaToWideKana(s);
                s = MaskingUtil.wideKanaToHiragana(s);
            }
            if (rule.useUpperCase()) {
                s = s.toUpperCase();
            }
            if (rule.useLowerCase()) {
                s = s.toLowerCase();
            }
            return s;
        }
        if (clazz == src.getClass()) {
            return src;
        }
        if (TypeConverter.isDateTimeClass(clazz)) {
            return TypeConverter.toDateTime(src, clazz, rule);
        }
        if (TypeConverter.isDateTimeClass(src.getClass())) {
            return TypeConverter.fromDateTime(src, clazz, rule);
        }
        if (clazz == String.class) {
            return src.toString();
        }
        Constructor<?>[] constructors = clazz.getConstructors();
        for (int i = 0; i < constructors.length; ++i) {
            if (constructors[i].getParameterCount() != 1 || constructors[i].getParameterTypes()[0] != src.getClass()) continue;
            obj = constructors[i].newInstance(src);
            break;
        }
        if (obj == null) {
            Method method2;
            try {
                method2 = clazz.getMethod("valueOf", src.getClass());
                obj = method2.invoke(null, src);
            }
            catch (NoSuchMethodException method2) {
                // empty catch block
            }
            if (obj == null && primitiveClassMap.containsKey(src.getClass())) {
                try {
                    method2 = clazz.getMethod("valueOf", primitiveClassMap.get(src.getClass()));
                    obj = method2.invoke(null, src);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
        }
        if (obj == null) {
            throw new IllegalArgumentException(String.format("\u578b\u5909\u63db %s \u2192 %s \u306f\u975e\u5bfe\u5fdc\u3002", src.getClass().getSimpleName(), clazz.getSimpleName()));
        }
        return obj;
    }

    public static boolean isDateTimeClass(Class<?> clazz) {
        return clazz == java.util.Date.class || clazz == Date.class || clazz == Time.class || clazz == Timestamp.class || clazz == LocalDate.class || clazz == LocalDateTime.class || clazz == LocalTime.class;
    }

    public static boolean isTimeClass(Class<?> clazz) {
        return clazz == Time.class || clazz == LocalTime.class;
    }

    public static boolean isNumClass(Class<?> clazz) {
        return clazz == Long.class || clazz == Integer.class || clazz == BigInteger.class || clazz == BigDecimal.class;
    }

    public static Object toDateTime(Object src, Class<?> clazz) {
        return TypeConverter.toDateTime(src, clazz, null);
    }

    public static Object toDateTime(Object src, Class<?> clazz, MaskingRule rule) {
        if (src == null) {
            return src;
        }
        if (src instanceof String && ((String)src).isEmpty()) {
            return src;
        }
        if (src.getClass().isArray()) {
            throw new IllegalArgumentException(String.format("\u65e5\u4ed8\u578b\u5909\u63db %s \u2192 %s \u306f\u975e\u5bfe\u5fdc\u3002", src.getClass().getSimpleName(), clazz.getSimpleName()));
        }
        LocalDateTime dt = null;
        if (TypeConverter.isNumClass(src.getClass()) || src instanceof String) {
            int ss;
            JapaneseEra ee;
            String dd;
            String mm;
            String yy;
            Matcher m;
            DateTimeFormatter df;
            String s = src.toString();
            if (rule != null && rule.getDateTimeFormat() != null && !rule.getDateTimeFormat().isEmpty()) {
                df = rule.getDateTimeFormat().indexOf("GGGG") >= 0 ? DateTimeFormatter.ofPattern(rule.getDateTimeFormat()).withChronology(JapaneseChronology.INSTANCE) : DateTimeFormatter.ofPattern(rule.getDateTimeFormat());
            } else if (s.matches("[0-9]{4}") && !TypeConverter.isTimeClass(clazz)) {
                df = NUMYEAR_FORMATTER;
            } else if (s.matches("[0-9]{1,6}") && TypeConverter.isTimeClass(clazz)) {
                s = String.format("%06d", Integer.parseInt(s));
                df = NUMTIME_FORMATTER;
            } else if (s.matches("[0-9]{6}")) {
                df = NUMYEARMONTH_FORMATTER;
            } else if (s.matches("[0-9]{8}")) {
                df = NUMDATE_FORMATTER;
            } else if (s.matches("[0-9]{14}")) {
                df = NUMDATETIME_FORMATTER;
            } else if (DATETIME_PATTERN.matcher(s).find()) {
                m = DATETIME_PATTERN.matcher(s);
                m.find();
                yy = m.group(1);
                mm = m.group(2);
                dd = m.group(3);
                String hh = m.group(4);
                String nn = m.group(5);
                String ss2 = m.group(7);
                s = String.format("%04d-%02d-%02d %02d:%02d:%02d", Integer.parseInt(yy), Integer.parseInt(mm), Integer.parseInt(dd), Integer.parseInt(hh), Integer.parseInt(nn), ss2 == null ? 0 : Integer.parseInt(ss2));
                df = JISDATETIME_FORMATTER;
            } else if (DATE_PATTERN.matcher(s).find()) {
                m = DATE_PATTERN.matcher(s);
                m.find();
                yy = m.group(1);
                mm = m.group(2);
                dd = m.group(3);
                s = String.format("%04d-%02d-%02d 00:00:00", Integer.parseInt(yy), Integer.parseInt(mm), Integer.parseInt(dd));
                df = JISDATETIME_FORMATTER;
            } else if (YEARMONTH_PATTERN.matcher(s).find()) {
                m = YEARMONTH_PATTERN.matcher(s);
                m.find();
                yy = m.group(1);
                mm = m.group(2);
                s = String.format("%04d-%02d-01 00:00:00", Integer.parseInt(yy), Integer.parseInt(mm));
                df = JISDATETIME_FORMATTER;
            } else if (TIME_PATTERN.matcher(s).find()) {
                m = TIME_PATTERN.matcher(s);
                m.find();
                String hh = m.group(1);
                String nn = m.group(2);
                String ss3 = m.group(4);
                s = String.format("%02d%02d%02d", Integer.parseInt(hh), Integer.parseInt(nn), ss3 == null ? 0 : Integer.parseInt(ss3));
                df = NUMTIME_FORMATTER;
            } else {
                df = DateTimeFormatter.ISO_LOCAL_DATE_TIME;
            }
            ParsePosition pos = new ParsePosition(0);
            TemporalAccessor temp = df.parseUnresolved(s, pos);
            if (temp == null) {
                throw new IllegalArgumentException(String.format("'%s'\u304c\u73fe\u5728\u306e\u65e5\u4ed8\u66f8\u5f0f\u3067\u89e3\u6790\u3067\u304d\u307e\u305b\u3093\u3002", s));
            }
            JapaneseEra japaneseEra = ee = temp.isSupported(ChronoField.ERA) ? JapaneseEra.of((int)temp.getLong(ChronoField.ERA)) : null;
            int yy2 = temp.isSupported(ChronoField.YEAR) ? (int)temp.getLong(ChronoField.YEAR) : (temp.isSupported(ChronoField.YEAR_OF_ERA) ? (int)temp.getLong(ChronoField.YEAR_OF_ERA) : 0);
            int mm2 = temp.isSupported(ChronoField.MONTH_OF_YEAR) ? (int)temp.getLong(ChronoField.MONTH_OF_YEAR) : 1;
            int dd2 = temp.isSupported(ChronoField.DAY_OF_MONTH) ? (int)temp.getLong(ChronoField.DAY_OF_MONTH) : 1;
            int hh = temp.isSupported(ChronoField.HOUR_OF_DAY) ? (int)temp.getLong(ChronoField.HOUR_OF_DAY) : 0;
            int nn = temp.isSupported(ChronoField.MINUTE_OF_HOUR) ? (int)temp.getLong(ChronoField.MINUTE_OF_HOUR) : 0;
            int n = ss = temp.isSupported(ChronoField.SECOND_OF_MINUTE) ? (int)temp.getLong(ChronoField.SECOND_OF_MINUTE) : 0;
            dt = ee != null ? LocalDateTime.of(LocalDate.ofEpochDay(JapaneseDate.of(ee, yy2, mm2, dd2).toEpochDay()), LocalTime.of(hh, nn, ss)) : LocalDateTime.of(yy2, mm2, dd2, hh, nn, ss);
        } else if (src instanceof Date) {
            dt = ((Date)src).toLocalDate().atTime(LocalTime.MIN);
        } else if (src instanceof Time) {
            dt = LocalDateTime.of(LocalDate.MIN, ((Time)src).toLocalTime());
        } else if (src instanceof Timestamp) {
            dt = ((Timestamp)src).toLocalDateTime();
        } else if (src instanceof java.util.Date) {
            dt = ((java.util.Date)src).toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
        } else if (src instanceof LocalDate) {
            dt = ((LocalDate)src).atTime(LocalTime.MIN);
        } else if (src instanceof LocalTime) {
            dt = LocalDateTime.of(LocalDate.MIN, (LocalTime)src);
        } else if (src instanceof LocalDateTime) {
            dt = (LocalDateTime)src;
        }
        if (dt != null) {
            if (clazz == LocalDateTime.class) {
                return dt;
            }
            if (clazz == LocalDate.class) {
                return dt.toLocalDate();
            }
            if (clazz == LocalTime.class) {
                return dt.toLocalTime();
            }
            if (clazz == Date.class) {
                return Date.valueOf(dt.toLocalDate());
            }
            if (clazz == Time.class) {
                return Time.valueOf(dt.toLocalTime());
            }
            if (clazz == Timestamp.class) {
                return Timestamp.valueOf(dt);
            }
            if (clazz == java.util.Date.class) {
                return java.util.Date.from(ZonedDateTime.of(dt, ZoneId.systemDefault()).toInstant());
            }
        }
        throw new IllegalArgumentException(String.format("\u65e5\u4ed8\u578b\u5909\u63db %s \u2192 %s \u306f\u975e\u5bfe\u5fdc\u3002", src.getClass().getSimpleName(), clazz.getSimpleName()));
    }

    public static Object fromDateTime(Object src, Class<?> clazz) {
        return TypeConverter.fromDateTime(src, clazz, null);
    }

    public static Object fromDateTime(Object src, Class<?> clazz, MaskingRule rule) {
        LocalDateTime dt;
        if (src == null) {
            return src;
        }
        if (src.getClass().isArray()) {
            throw new IllegalArgumentException(String.format("\u65e5\u4ed8\u578b\u5909\u63db %s \u2192 %s \u306f\u975e\u5bfe\u5fdc\u3002", src.getClass().getSimpleName(), clazz.getSimpleName()));
        }
        boolean isDateTime = false;
        boolean isTime = false;
        if (src instanceof Date) {
            dt = ((Date)src).toLocalDate().atTime(LocalTime.MIN);
        } else if (src instanceof Time) {
            dt = LocalDateTime.of(LocalDate.MIN, ((Time)src).toLocalTime());
            isTime = true;
        } else if (src instanceof Timestamp) {
            dt = ((Timestamp)src).toLocalDateTime();
            isDateTime = true;
        } else if (src instanceof java.util.Date) {
            dt = ((java.util.Date)src).toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
        } else if (src instanceof LocalDate) {
            dt = ((LocalDate)src).atTime(LocalTime.MIN);
        } else if (src instanceof LocalDateTime) {
            dt = (LocalDateTime)src;
            isDateTime = true;
        } else if (src instanceof LocalTime) {
            dt = LocalDateTime.of(LocalDate.MIN, (LocalTime)src);
            isTime = true;
        } else {
            throw new IllegalArgumentException(String.format("\u65e5\u4ed8\u578b\u5909\u63db %s \u2192 %s \u306f\u975e\u5bfe\u5fdc\u3002", src.getClass().getSimpleName(), clazz.getSimpleName()));
        }
        DateTimeFormatter df = rule != null && rule.getDateTimeFormat() != null && !rule.getDateTimeFormat().isEmpty() ? (rule.getDateTimeFormat().indexOf("GGGG") >= 0 ? DateTimeFormatter.ofPattern(rule.getDateTimeFormat()).withChronology(JapaneseChronology.INSTANCE) : DateTimeFormatter.ofPattern(rule.getDateTimeFormat())) : (isTime ? (TypeConverter.isNumClass(clazz) ? NUMTIME_FORMATTER : JPTIME_FORMATTER) : (isDateTime ? (TypeConverter.isNumClass(clazz) ? (clazz == Integer.class ? NUMDATE_FORMATTER : NUMDATETIME_FORMATTER) : JPDATETIME_FORMATTER) : (TypeConverter.isNumClass(clazz) ? NUMDATE_FORMATTER : JPDATE_FORMATTER)));
        if (clazz == Long.class) {
            return Long.parseLong(dt.format(df));
        }
        if (clazz == Integer.class) {
            return Integer.parseInt(dt.format(df));
        }
        if (clazz == BigInteger.class) {
            return new BigInteger(dt.format(df));
        }
        if (clazz == BigDecimal.class) {
            return new BigDecimal(dt.format(df));
        }
        if (clazz == String.class) {
            return dt.format(df);
        }
        throw new IllegalArgumentException(String.format("\u65e5\u4ed8\u578b\u5909\u63db %s \u2192 %s \u306f\u975e\u5bfe\u5fdc\u3002", src.getClass().getSimpleName(), clazz.getSimpleName()));
    }

    static {
        primitiveClassMap.put(Byte.class, Byte.TYPE);
        primitiveClassMap.put(Short.class, Short.TYPE);
        primitiveClassMap.put(Integer.class, Integer.TYPE);
        primitiveClassMap.put(Long.class, Long.TYPE);
        primitiveClassMap.put(Float.class, Float.TYPE);
        primitiveClassMap.put(Double.class, Double.TYPE);
        primitiveClassMap.put(Double.class, Double.TYPE);
        primitiveClassMap.put(Boolean.class, Boolean.TYPE);
    }
}

