/*
 * Decompiled with CFR 0.152.
 */
package net.utsuro.mask;

import java.sql.Connection;
import java.sql.SQLIntegrityConstraintViolationException;
import java.util.concurrent.ThreadLocalRandom;
import net.utsuro.mask.DataMask;
import net.utsuro.mask.MaskedTextReplacer;
import net.utsuro.mask.MaskingRule;
import net.utsuro.mask.MaskingUtil;
import net.utsuro.mask.TypeConverter;

public class RandomTextGenerator
implements DataMask {
    private static final int RETRY_MAX = 5;
    private Connection conn;

    @Override
    public boolean useDatabase(MaskingRule rule) {
        return rule.isUniqueValue() || rule.isDeterministicReplace();
    }

    @Override
    public Connection getConnection() {
        return this.conn;
    }

    @Override
    public void setConnection(Connection conn) {
        this.conn = conn;
    }

    @Override
    public Object execute(Object src, MaskingRule rule) throws Exception {
        if (rule == null || !rule.isNullReplace() && src == null) {
            return src;
        }
        String tarStr = src instanceof String || src == null ? (String)src : src.toString();
        String ret = null;
        if (tarStr != null && rule.isDeterministicReplace()) {
            ret = (String)this.getRegisteredUniqueVal(rule.getUniqueId(), tarStr);
        }
        if (ret == null) {
            boolean isValid = false;
            int retryCount = 0;
            while (!isValid) {
                ret = RandomTextGenerator.generate(tarStr, rule);
                if (rule.isUniqueValue() && this.isExistsInUniqueList(rule.getUniqueId(), ret)) continue;
                isValid = true;
                if (tarStr == null || !rule.isUniqueValue() && !rule.isDeterministicReplace()) continue;
                isValid = this.addUniqueList(rule.getUniqueId(), tarStr, ret);
                if (!isValid) {
                    ++retryCount;
                }
                if (retryCount <= 5) continue;
                throw new SQLIntegrityConstraintViolationException(String.format("%d\u56de\u91cd\u8907\u3057\u3066\u30e6\u30cb\u30fc\u30af\u30ea\u30b9\u30c8\u306e\u767b\u9332\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", 5));
            }
        }
        return ret;
    }

    public static String generate(String src, MaskingRule rule) throws Exception {
        int byteCount;
        if (rule == null || !rule.isNullReplace() && src == null) {
            return src;
        }
        if (src != null && rule.getIgnoreValuePattern() != null && rule.getIgnoreValuePattern().matcher(src).find()) {
            return src;
        }
        String tarStr = src;
        if (rule.isNullReplace() && tarStr == null) {
            tarStr = "";
        }
        if (rule.getMinSjisByteCount() > 0 || rule.getMaxSjisByteCount() > 0) {
            int min = Math.max(rule.getMinSjisByteCount(), 1);
            int max = rule.getMaxSjisByteCount() == 0 ? MaskingUtil.getSjisByteCount(tarStr) : Math.max(rule.getMaxSjisByteCount(), rule.getMinSjisByteCount());
            byteCount = ThreadLocalRandom.current().nextInt(max + 1 - min) + min;
        } else {
            byteCount = MaskingUtil.getSjisByteCount(tarStr);
        }
        byteCount -= MaskingUtil.getSjisByteCount(rule.getPrefix());
        if ((byteCount -= MaskingUtil.getSjisByteCount(rule.getSuffix())) <= 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(rule.getPrefix());
        MaskingUtil.CharType charType = rule.useRandomGenCharType() ? rule.getRandomGenCharType() : MaskingUtil.CharType.getTypeByString(tarStr);
        if (charType != MaskingUtil.CharType.UNKNOWN) {
            sb.append(MaskingUtil.getRandomString(byteCount, charType, rule.getRandomNoGenCharPattern()));
        } else {
            sb.append(MaskingUtil.getRandomString(byteCount, MaskingUtil.CharType.ALL, rule.getRandomNoGenCharPattern()));
        }
        sb.append(rule.getSuffix());
        if (rule.useUpperCaseKana() || rule.useHalfKana() || rule.useWideKana() || rule.useHiragana() || rule.useUpperCase() || rule.useLowerCase()) {
            MaskingRule afterRepRule = new MaskingRule(rule);
            afterRepRule.setToClassName(String.class.getName());
            sb = new StringBuilder().append(TypeConverter.convert(sb.toString(), afterRepRule));
        }
        if (rule.useAfterTextReplace()) {
            MaskingRule afterRepRule = new MaskingRule(rule);
            afterRepRule.useOddCharMask(rule.useAfterRepOddCharMask());
            afterRepRule.useEvenCharMask(rule.useAfterRepEvenCharMask());
            sb = new StringBuilder(MaskedTextReplacer.replace(sb.toString(), afterRepRule));
        }
        return sb.toString();
    }
}

