/*
 * Decompiled with CFR 0.152.
 */
package net.utsuro.mask;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLIntegrityConstraintViolationException;
import java.text.Normalizer;
import java.util.Arrays;
import net.utsuro.mask.DataMask;
import net.utsuro.mask.MaskingRule;
import net.utsuro.mask.MaskingUtil;
import net.utsuro.mask.TextTrim;

public class RandomFullNameGenerator
implements DataMask {
    private static final int RETRY_MAX = 5;
    private Connection conn;
    private long lastNameMaxSeq = -1L;
    private long firstNameMaxSeq = -1L;

    @Override
    public boolean useDatabase(MaskingRule rule) {
        return true;
    }

    @Override
    public Connection getConnection() {
        return this.conn;
    }

    @Override
    public void setConnection(Connection conn) {
        this.conn = conn;
    }

    @Override
    public Object execute(Object src, MaskingRule rule) throws Exception {
        String buff;
        if (rule == null || !rule.isNullReplace() && src == null) {
            return src;
        }
        CharSequence[] names = null;
        if (rule.isNullReplace() && src == null) {
            names = new String[]{};
        } else if (src instanceof String[] || src instanceof Object[]) {
            names = (String[])Arrays.copyOf((Object[])src, ((Object[])src).length, String[].class);
            if (rule.isBeforeTrim()) {
                for (int i = 0; i < names.length; ++i) {
                    if (names[i] == null) continue;
                    names[i] = TextTrim.trim((String)names[i], rule);
                }
            }
        } else {
            return src;
        }
        CharSequence[] ret = null;
        if (rule.isDeterministicReplace() && (buff = (String)this.getRegisteredUniqueVal(rule.getUniqueId(), String.join((CharSequence)"<>", names))) != null) {
            ret = buff.split("<>", -1);
        }
        if (ret == null) {
            boolean isValid = false;
            int retryCount = 0;
            while (!isValid) {
                ret = this.generate((String[])names, rule);
                if (rule.isUniqueValue() && this.isExistsInUniqueList(rule.getUniqueId(), String.join((CharSequence)"<>", ret))) continue;
                isValid = true;
                if (ret == null || !rule.isUniqueValue() && !rule.isDeterministicReplace()) continue;
                isValid = this.addUniqueList(rule.getUniqueId(), String.join((CharSequence)"<>", names), String.join((CharSequence)"<>", ret));
                if (!isValid) {
                    ++retryCount;
                }
                if (retryCount <= 5) continue;
                throw new SQLIntegrityConstraintViolationException(String.format("%d\u56de\u91cd\u8907\u3057\u3066\u30e6\u30cb\u30fc\u30af\u30ea\u30b9\u30c8\u306e\u767b\u9332\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", 5));
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] generate(String[] src, MaskingRule rule) throws Exception {
        PreparedStatement stmt;
        StringBuilder sql;
        if (rule == null || !rule.isNullReplace() && src == null) {
            return src;
        }
        String namesBuff = rule.getFullNameFormat();
        if (namesBuff == null || namesBuff.isEmpty()) {
            return src;
        }
        RandomFullNameGenerator randomFullNameGenerator = this;
        synchronized (randomFullNameGenerator) {
            if (this.lastNameMaxSeq < 0L) {
                sql = new StringBuilder();
                sql.append("SELECT").append(" MAX(CASE WHEN name_type = 'LAST_NAME' THEN ").append(rule.getSelectListSeqNoColName()).append(" ELSE -1 END) AS sei_maxseq").append(",MAX(CASE WHEN name_type = 'FIRST_NAME' THEN ").append(rule.getSelectListSeqNoColName()).append(" ELSE -1 END) AS mei_maxseq").append(" FROM m_jinmei");
                stmt = this.conn.prepareStatement(sql.toString());
                try (ResultSet rs = stmt.executeQuery();){
                    if (rs.next()) {
                        this.lastNameMaxSeq = rs.getLong("sei_maxseq");
                        this.firstNameMaxSeq = rs.getLong("mei_maxseq");
                    }
                }
                finally {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
            }
        }
        if (this.lastNameMaxSeq < 0L) {
            return null;
        }
        sql = new StringBuilder();
        sql.append("SELECT").append(" name_type, kanji, yomi").append(" FROM m_jinmei").append(" WHERE (name_type = 'LAST_NAME' AND ").append(rule.getSelectListSeqNoColName()).append(" = ?)").append(" OR (name_type = 'FIRST_NAME' AND ").append(rule.getSelectListSeqNoColName()).append(" = ?)");
        boolean isExists = false;
        stmt = this.conn.prepareStatement(sql.toString());
        try {
            long tarLastNameNo = MaskingUtil.getRandomNumber(0L, this.lastNameMaxSeq);
            long tarFirstNameNo = MaskingUtil.getRandomNumber(0L, this.firstNameMaxSeq);
            stmt.setLong(1, tarLastNameNo);
            stmt.setLong(2, tarFirstNameNo);
            try (ResultSet rs = stmt.executeQuery();){
                while (rs.next()) {
                    isExists = true;
                    String kana = rs.getString("yomi");
                    if (rule.useUpperCaseKana()) {
                        kana = MaskingUtil.toUpperHiragana(kana);
                    }
                    if (rule.useWideKana() || rule.useHalfKana()) {
                        kana = MaskingUtil.hiraganaToWideKana(kana);
                        if (rule.useHalfKana()) {
                            kana = MaskingUtil.wideKanaToHalfKana(Normalizer.normalize(kana, Normalizer.Form.NFKC));
                        }
                    }
                    if ("LAST_NAME".equals(rs.getString("name_type"))) {
                        namesBuff = namesBuff.replaceAll("%lastNameKanji", rs.getString("kanji"));
                        namesBuff = namesBuff.replaceAll("%lastNameKana", kana);
                        continue;
                    }
                    namesBuff = namesBuff.replaceAll("%firstNameKanji", rs.getString("kanji"));
                    namesBuff = namesBuff.replaceAll("%firstNameKana", kana);
                }
            }
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
        }
        String[] ret = null;
        if (isExists) {
            ret = namesBuff.split(",", -1);
        }
        return ret;
    }
}

