/*
 * Decompiled with CFR 0.152.
 */
package net.utsuro.mask;

import java.sql.Connection;
import java.sql.SQLIntegrityConstraintViolationException;
import java.time.DateTimeException;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.utsuro.mask.DataMask;
import net.utsuro.mask.MaskingRule;
import net.utsuro.mask.MaskingUtil;
import net.utsuro.mask.TypeConverter;

public class RandomDateGenerator
implements DataMask {
    private static final int RETRY_MAX = 5;
    private Connection conn;

    @Override
    public boolean useDatabase(MaskingRule rule) {
        return rule.isUniqueValue() || rule.isDeterministicReplace();
    }

    @Override
    public Connection getConnection() {
        return this.conn;
    }

    @Override
    public void setConnection(Connection conn) {
        this.conn = conn;
    }

    @Override
    public Object execute(Object src, MaskingRule rule) throws Exception {
        if (rule == null || !rule.isNullReplace() && src == null) {
            return src;
        }
        LocalDateTime dt = null;
        String dtStr = null;
        MaskingRule tempRule = new MaskingRule(rule);
        tempRule.setToClassName(LocalDateTime.class.getName());
        if (src != null) {
            if (src.getClass() != LocalDateTime.class) {
                try {
                    dt = (LocalDateTime)TypeConverter.convert(src, tempRule);
                    dtStr = dt.toString();
                }
                catch (IllegalArgumentException | DateTimeException e) {
                    if (rule.isInvalidDateReplace()) {
                        dt = LocalDateTime.now().truncatedTo(ChronoUnit.HOURS);
                        dtStr = src.toString();
                    }
                    return src;
                }
            } else {
                dt = (LocalDateTime)src;
                dtStr = dt.toString();
            }
        }
        LocalDateTime ret = null;
        String retStr = null;
        if (dtStr != null && rule.isDeterministicReplace() && (retStr = (String)this.getRegisteredUniqueVal(rule.getUniqueId(), dtStr)) != null) {
            try {
                ret = (LocalDateTime)TypeConverter.convert(retStr, tempRule);
            }
            catch (IllegalArgumentException | DateTimeException e) {
                return retStr;
            }
        }
        if (ret == null) {
            boolean isValid = false;
            int retryCount = 0;
            while (!isValid) {
                ret = RandomDateGenerator.generate(dt, rule);
                if (rule.isUniqueValue() && this.isExistsInUniqueList(rule.getUniqueId(), ret.toString())) continue;
                isValid = true;
                if (!rule.isUniqueValue() && !rule.isDeterministicReplace()) continue;
                isValid = this.addUniqueList(rule.getUniqueId(), dtStr, ret.toString());
                if (!isValid) {
                    ++retryCount;
                }
                if (retryCount <= 5) continue;
                throw new SQLIntegrityConstraintViolationException(String.format("%d\u56de\u91cd\u8907\u3057\u3066\u30e6\u30cb\u30fc\u30af\u30ea\u30b9\u30c8\u306e\u767b\u9332\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", 5));
            }
        }
        return ret;
    }

    public static LocalDateTime generate(LocalDateTime src, MaskingRule rule) {
        LocalDateTime buff;
        Matcher m;
        if (rule == null || !rule.isNullReplace() && src == null) {
            return src;
        }
        if (src != null && rule.getIgnoreValuePattern() != null && rule.getIgnoreValuePattern().matcher(src.toString()).find()) {
            return src;
        }
        LocalDateTime dt = src;
        if (rule.isNullReplace() && src == null) {
            dt = LocalDateTime.now().truncatedTo(ChronoUnit.HOURS);
        }
        LocalDateTime min = rule.getMinDate();
        LocalDateTime max = rule.getMaxDate();
        Pattern ptn = Pattern.compile("(([-0-9]+)Y)?(([-0-9]+)M)?(([-0-9]+)D)?");
        if (rule.getTermFrom() != null && !rule.getTermFrom().isEmpty() && (m = ptn.matcher(rule.getTermFrom())).find()) {
            buff = dt.plusDays(0L);
            if (m.group(2) != null) {
                buff = buff.plusYears(Integer.parseInt(m.group(2)));
            }
            if (m.group(4) != null) {
                buff = buff.plusMonths(Integer.parseInt(m.group(4)));
            }
            if (m.group(6) != null) {
                buff = buff.plusDays(Integer.parseInt(m.group(6)));
            }
            min = buff;
        }
        if (rule.getTermTo() != null && !rule.getTermTo().isEmpty() && (m = ptn.matcher(rule.getTermTo())).find()) {
            buff = dt.plusDays(0L);
            if (m.group(2) != null) {
                buff = buff.plusYears(Integer.parseInt(m.group(2)));
            }
            if (m.group(4) != null) {
                buff = buff.plusMonths(Integer.parseInt(m.group(4)));
            }
            if (m.group(6) != null) {
                buff = buff.plusDays(Integer.parseInt(m.group(6)));
            }
            max = buff;
        }
        if (min == null) {
            min = LocalDateTime.parse("0000-01-01T00:00:00");
        }
        if (max == null) {
            max = LocalDateTime.parse("9999-12-31T23:59:59");
        }
        return MaskingUtil.getRandomDate(min, max);
    }
}

