/*
 * Decompiled with CFR 0.152.
 */
package net.utsuro.mask;

import java.sql.Connection;
import java.sql.SQLIntegrityConstraintViolationException;
import java.util.regex.Pattern;
import net.utsuro.mask.DataMask;
import net.utsuro.mask.MaskingRule;
import net.utsuro.mask.MaskingUtil;

public class RandomCardnoReplacer
implements DataMask {
    private static final int RETRY_MAX = 5;
    private Connection conn;

    @Override
    public boolean useDatabase(MaskingRule rule) {
        return rule.isUniqueValue() || rule.isDeterministicReplace();
    }

    @Override
    public Connection getConnection() {
        return this.conn;
    }

    @Override
    public void setConnection(Connection conn) {
        this.conn = conn;
    }

    @Override
    public Object execute(Object src, MaskingRule rule) throws Exception {
        if (rule == null || src == null) {
            return src;
        }
        String tarStr = src instanceof String ? (String)src : src.toString();
        String ret = null;
        if (tarStr != null && rule.isDeterministicReplace()) {
            ret = (String)this.getRegisteredUniqueVal(rule.getUniqueId(), tarStr);
        }
        if (ret == null) {
            boolean isValid = false;
            int retryCount = 0;
            while (!isValid) {
                ret = RandomCardnoReplacer.replace(tarStr, rule);
                if (rule.isUniqueValue() && this.isExistsInUniqueList(rule.getUniqueId(), ret)) continue;
                isValid = true;
                if (!rule.isUniqueValue() && !rule.isDeterministicReplace()) continue;
                isValid = this.addUniqueList(rule.getUniqueId(), tarStr, ret);
                if (!isValid) {
                    ++retryCount;
                }
                if (retryCount <= 5) continue;
                throw new SQLIntegrityConstraintViolationException(String.format("%d\u56de\u91cd\u8907\u3057\u3066\u30e6\u30cb\u30fc\u30af\u30ea\u30b9\u30c8\u306e\u767b\u9332\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", 5));
            }
        }
        return ret;
    }

    public static String replace(String src, MaskingRule rule) {
        StringBuilder sb = new StringBuilder();
        if (rule == null || src == null) {
            return src;
        }
        if (src.isEmpty()) {
            return src;
        }
        if (rule.getIgnoreValuePattern() != null && rule.getIgnoreValuePattern().matcher(src).find()) {
            return src;
        }
        String[] c = src.split("");
        int len = c.length;
        int start = rule.getUnmaksedLengthLeft();
        if (start < 0) {
            start = len + start;
        }
        int end = len - rule.getUnmaksedLengthRight() - 1;
        Pattern ptn = Pattern.compile("[- ]");
        for (int i = 0; i < len; ++i) {
            if (i >= start && i <= end) {
                if (!ptn.matcher(c[i]).find()) {
                    sb.append(MaskingUtil.getRandomString(1, MaskingUtil.CharType.NUMBER, rule.getRandomNoGenCharPattern()));
                    continue;
                }
                sb.append(c[i]);
                continue;
            }
            sb.append(c[i]);
        }
        String checkDigit = MaskingUtil.getLuhnDigit(sb.toString());
        sb.replace(sb.length() - 1, sb.length(), checkDigit);
        return sb.toString();
    }
}

