/*
 * Decompiled with CFR 0.152.
 */
package net.utsuro.mask;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.security.SecureRandom;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class MaskingUtil {
    static final String[] LOWER_ALPHA_CHARACTER;
    static final String[] UPPER_ALPHA_CHARACTER;
    static final String[] NUMBER_CHARACTER;
    static final String[] SPECIAL_CHARACTER;
    static final String[] WSPECIAL_CHARACTER;
    static final String[] HKANA_CHARACTER_FULL;
    static final String[] WKANA_CHARACTER_FULL;
    static final String[] HKANA_CHARACTER;
    static final int[] HKANA_RATIO;
    static final String[] HIRAGANA_CHARACTER;
    static final int[] HIRAGANA_RATIO;
    static int halfKanaTotalWeight;
    static int hiraganaTotalWeight;
    private static final SecureRandom rnd;
    private static Map<String, String> lowerHalfKanaMap;
    private static Map<String, String> lowerWideKanaMap;
    private static Map<String, String> lowerHiraganaMap;
    private static List<String> halfKanaTable;
    private static List<String> wideKanaTable;

    static EnumSet<CharType> charTypeNormalize(EnumSet<CharType> types) {
        EnumSet<CharType> ret = types;
        if (types.contains((Object)CharType.ALL)) {
            ret = EnumSet.range(CharType.LOWER_ALPHA, CharType.WIDE_SPECIAL);
            ret.remove((Object)CharType.ALL);
        } else {
            if (types.contains((Object)CharType.HALF)) {
                ret.add(CharType.LOWER_ALPHA);
                ret.add(CharType.UPPER_ALPHA);
                ret.add(CharType.NUMBER);
                ret.add(CharType.HALF_KANA);
                ret.remove((Object)CharType.HALF);
            }
            if (types.contains((Object)CharType.HALF_WITH_SPECIAL)) {
                ret.add(CharType.LOWER_ALPHA);
                ret.add(CharType.UPPER_ALPHA);
                ret.add(CharType.NUMBER);
                ret.add(CharType.SPECIAL);
                ret.add(CharType.HALF_KANA);
                ret.remove((Object)CharType.HALF_WITH_SPECIAL);
            }
            if (types.contains((Object)CharType.WIDE)) {
                ret.add(CharType.WIDE_LOWER_ALPHA);
                ret.add(CharType.WIDE_UPPER_ALPHA);
                ret.add(CharType.WIDE_ALPHANUM);
                ret.add(CharType.WIDE_KANA);
                ret.add(CharType.HIRAGANA);
                ret.add(CharType.KANJI);
                ret.remove((Object)CharType.WIDE);
            }
            if (types.contains((Object)CharType.WIDE_WITH_SPECIAL)) {
                ret.add(CharType.WIDE_LOWER_ALPHA);
                ret.add(CharType.WIDE_UPPER_ALPHA);
                ret.add(CharType.WIDE_SPECIAL);
                ret.add(CharType.WIDE_ALPHANUM);
                ret.add(CharType.WIDE_KANA);
                ret.add(CharType.HIRAGANA);
                ret.add(CharType.KANJI);
                ret.remove((Object)CharType.WIDE_WITH_SPECIAL);
            }
            if (types.contains((Object)CharType.ALPHA)) {
                ret.add(CharType.LOWER_ALPHA);
                ret.add(CharType.UPPER_ALPHA);
                ret.remove((Object)CharType.ALPHA);
            }
            if (types.contains((Object)CharType.ALPHANUM)) {
                ret.add(CharType.LOWER_ALPHA);
                ret.add(CharType.UPPER_ALPHA);
                ret.add(CharType.NUMBER);
                ret.remove((Object)CharType.ALPHANUM);
            }
            if (types.contains((Object)CharType.WIDE_ALPHA)) {
                ret.add(CharType.WIDE_LOWER_ALPHA);
                ret.add(CharType.WIDE_UPPER_ALPHA);
                ret.remove((Object)CharType.WIDE_ALPHA);
            }
            if (types.contains((Object)CharType.WIDE_ALPHANUM)) {
                ret.add(CharType.WIDE_LOWER_ALPHA);
                ret.add(CharType.WIDE_UPPER_ALPHA);
                ret.add(CharType.WIDE_NUMBER);
                ret.remove((Object)CharType.WIDE_ALPHANUM);
            }
        }
        return ret;
    }

    public static boolean isWideChar(String s) {
        boolean ret = false;
        if (s != null && s.length() > 0) {
            ret = s.getBytes(Charset.forName("MS932")).length != s.length();
        }
        return ret;
    }

    public static int getSjisByteCount(String s) {
        int ret = 0;
        if (s != null && s.length() > 0) {
            ret = s.getBytes(Charset.forName("MS932")).length;
        }
        return ret;
    }

    public static String[] splitBySjisBytes(String s, int bytes) {
        String[] ret = new String[]{null, null};
        if (s != null) {
            ret = new String[2];
            int cnt = 0;
            boolean isOverflow = false;
            List<String> charList = Arrays.asList(s.split(""));
            StringBuilder buff = new StringBuilder();
            for (String c : charList) {
                if ((cnt += MaskingUtil.getSjisByteCount(c)) <= bytes) {
                    buff.append(c);
                    continue;
                }
                isOverflow = true;
                break;
            }
            ret[0] = buff.toString();
            if (isOverflow) {
                ret[1] = s.substring(buff.length());
            }
        }
        return ret;
    }

    public static String toUpperHalfKana(String s) {
        StringBuffer sb = new StringBuffer();
        Pattern p = Pattern.compile("[\uff67\uff68\uff69\uff6a\uff6b\uff6f\uff6c\uff6d\uff6e]");
        Matcher m = p.matcher(s);
        while (m.find()) {
            m.appendReplacement(sb, lowerHalfKanaMap.get(m.group()));
        }
        m.appendTail(sb);
        return sb.toString();
    }

    public static String toUpperWideKana(String s) {
        StringBuffer sb = new StringBuffer();
        Pattern p = Pattern.compile("[\u30a1\u30a3\u30a5\u30a7\u30a9\u30f5\u30f6\u30c3\u30e3\u30e5\u30e7\u30ee]");
        Matcher m = p.matcher(s);
        while (m.find()) {
            m.appendReplacement(sb, lowerWideKanaMap.get(m.group()));
        }
        m.appendTail(sb);
        return sb.toString();
    }

    public static String toUpperHiragana(String s) {
        StringBuffer sb = new StringBuffer();
        Pattern p = Pattern.compile("[\u3041\u3043\u3045\u3047\u3049\u3063\u3083\u3085\u3087\u308e]");
        Matcher m = p.matcher(s);
        while (m.find()) {
            m.appendReplacement(sb, lowerHiraganaMap.get(m.group()));
        }
        m.appendTail(sb);
        return sb.toString();
    }

    public static String wideKanaToHalfKana(String s) {
        StringBuffer sb = new StringBuffer();
        String[] c = s.split("");
        int len = c.length;
        for (int i = 0; i < len; ++i) {
            int idx = wideKanaTable.indexOf(c[i]);
            if (idx < 0) {
                sb.append(c[i]);
                continue;
            }
            sb.append(halfKanaTable.get(idx));
        }
        return sb.toString();
    }

    public static String halfKanaToWideKana(String s) {
        StringBuffer sb = new StringBuffer();
        String[] c = s.split("");
        int len = c.length;
        for (int i = 0; i < len; ++i) {
            int idx;
            if (c[i].isEmpty()) continue;
            if (i < c.length - 1 && c[i + 1].matches("[\uff9f\uff9e]")) {
                c[i] = c[i].concat(c[i + 1]);
                c[i + 1] = "";
            }
            if ((idx = halfKanaTable.indexOf(c[i])) < 0) {
                sb.append(c[i]);
                continue;
            }
            sb.append(wideKanaTable.get(idx));
        }
        return sb.toString();
    }

    public static String halfNumberToWideNumber(String s) {
        StringBuffer sb = new StringBuffer();
        String[] c = s.split("");
        int len = c.length;
        for (int i = 0; i < len; ++i) {
            if (c[i].matches("[0-9]")) {
                sb.append((char)(c[i].charAt(0) + 65248));
                continue;
            }
            sb.append(c[i]);
        }
        return sb.toString();
    }

    public static String hiraganaToWideKana(String s) {
        StringBuffer sb = new StringBuffer();
        String[] c = s.split("");
        int len = c.length;
        for (int i = 0; i < len; ++i) {
            if (c[i].matches("[\u3041-\u3093]")) {
                sb.append((char)(c[i].charAt(0) + 96));
                continue;
            }
            sb.append(c[i]);
        }
        return sb.toString();
    }

    public static String wideKanaToHiragana(String s) {
        StringBuffer sb = new StringBuffer();
        String[] c = s.split("");
        int len = c.length;
        for (int i = 0; i < len; ++i) {
            if (c[i].matches("[\u30a1-\u30f3]")) {
                sb.append((char)(c[i].charAt(0) - 96));
                continue;
            }
            sb.append(c[i]);
        }
        return sb.toString();
    }

    public static boolean isInvalidNextLetter(StringBuilder str, String nextChar) {
        return MaskingUtil.isInvalidNextLetter(str.toString(), nextChar);
    }

    public static boolean isInvalidNextLetter(String str, String nextChar) {
        String lastChar;
        boolean ret = false;
        String string = lastChar = str.isEmpty() ? "" : str.substring(str.length() - 1);
        if (lastChar.matches("[\uff9f\uff9e]")) {
            if (str.length() >= 2) {
                lastChar = str.substring(str.length() - 2);
            }
        } else if (lastChar.matches("[-\u3001\u3002\uff64\uff61\r\n\t \u3000]")) {
            lastChar = "";
        }
        if (nextChar.matches("[\u3041\u3043\u3045\u3047\u3049\u3063\u3083\u3085\u3087\u308e\u3093\u3001\u3002]")) {
            if (lastChar.isEmpty() || lastChar.matches("[\u3041\u3043\u3045\u3047\u3049\u3063]") && nextChar.matches("[\u3041\u3043\u3045\u3047\u3049]") || !lastChar.matches("[\u304d\u3057\u3061\u306b\u3072\u307f\u308a\u304e\u3058\u3062\u3073\u3074]") && nextChar.matches("[\u3083\u3085\u3087]")) {
                ret = true;
            }
        } else if (nextChar.matches("[\u30a1\u30a3\u30a5\u30a7\u30a9\u30c3\u30e3\u30e5\u30e7\u30ee\u30f3\u30fc]")) {
            if (lastChar.isEmpty() || lastChar.matches("[\u30a1\u30a3\u30a5\u30a7\u30a9\u30c3\uff70]") && nextChar.matches("[\u30a1\u30a3\u30a5\u30a7\u30a9]") || !lastChar.matches("[\u30ad\u30b7\u30c1\u30cb\u30d2\u30df\u30ea\u30ae\u30b8\u30c2\u30d3\u30d4]") && nextChar.matches("[\u30e3\u30e5\u30e7]")) {
                ret = true;
            }
        } else if (nextChar.matches("[\uff67\uff68\uff69\uff6a\uff6b\uff6f\uff6c\uff6d\uff6e\uff9d\uff70\uff9f\uff9e\uff64\uff61]") && (lastChar.isEmpty() || lastChar.matches("[\uff67\uff68\uff69\uff6a\uff6b\uff6f\uff70]") && nextChar.matches("[\uff67\uff68\uff69\uff6a\uff6b]") || !lastChar.matches("(\uff77\uff9e|\uff7c\uff9e|\uff81\uff9e|\uff8b\uff9e|\uff8b\uff9f|[\uff77\uff7c\uff81\uff86\uff8b\uff90\uff98])") && nextChar.matches("[\uff6c\uff6d\uff6e]"))) {
            ret = true;
        }
        return ret;
    }

    public static String getRandomString(int sjisLen, CharType charType) {
        return MaskingUtil.getRandomString(sjisLen, EnumSet.of(charType), null);
    }

    public static String getRandomString(int sjisLen, CharType charType, Pattern noGenPattern) {
        return MaskingUtil.getRandomString(sjisLen, EnumSet.of(charType), noGenPattern);
    }

    public static String getRandomString(int sjisLen, EnumSet<CharType> charType) {
        return MaskingUtil.getRandomString(sjisLen, charType, null);
    }

    public static String getRandomString(int sjisLen, EnumSet<CharType> charType, Pattern noGenPattern) {
        ArrayList<String> tarCharList = new ArrayList<String>();
        boolean useHalfChar = false;
        boolean useSjisGenerator = false;
        int cardinality = 0;
        StringBuilder sb = new StringBuilder();
        if (sjisLen <= 0 || charType == null || charType.isEmpty()) {
            return "";
        }
        EnumSet<CharType> tarType = MaskingUtil.charTypeNormalize(charType);
        if (tarType.contains((Object)CharType.LOWER_ALPHA)) {
            tarCharList.addAll(Arrays.asList(LOWER_ALPHA_CHARACTER));
            useHalfChar = true;
            cardinality += LOWER_ALPHA_CHARACTER.length;
        }
        if (tarType.contains((Object)CharType.UPPER_ALPHA)) {
            tarCharList.addAll(Arrays.asList(UPPER_ALPHA_CHARACTER));
            useHalfChar = true;
            cardinality += UPPER_ALPHA_CHARACTER.length;
        }
        if (tarType.contains((Object)CharType.NUMBER)) {
            tarCharList.addAll(Arrays.asList(NUMBER_CHARACTER));
            useHalfChar = true;
            cardinality += NUMBER_CHARACTER.length;
        }
        if (tarType.contains((Object)CharType.SPECIAL)) {
            tarCharList.addAll(Arrays.asList(SPECIAL_CHARACTER));
            useHalfChar = true;
            cardinality += SPECIAL_CHARACTER.length;
        }
        if (tarType.contains((Object)CharType.WIDE_LOWER_ALPHA)) {
            useSjisGenerator = true;
        }
        if (tarType.contains((Object)CharType.WIDE_UPPER_ALPHA)) {
            useSjisGenerator = true;
        }
        if (tarType.contains((Object)CharType.WIDE_NUMBER)) {
            useSjisGenerator = true;
        }
        if (tarType.contains((Object)CharType.WIDE_SPECIAL)) {
            tarCharList.addAll(Arrays.asList(WSPECIAL_CHARACTER));
            cardinality += WSPECIAL_CHARACTER.length;
        }
        if (tarType.contains((Object)CharType.HIRAGANA)) {
            useSjisGenerator = true;
        }
        if (tarType.contains((Object)CharType.WIDE_KANA)) {
            useSjisGenerator = true;
        }
        if (tarType.contains((Object)CharType.HALF_KANA)) {
            useHalfChar = true;
            useSjisGenerator = true;
        }
        if (tarType.contains((Object)CharType.KANJI)) {
            useSjisGenerator = true;
        }
        if (!useHalfChar && sjisLen < 2) {
            return "";
        }
        int i = 0;
        while (i < sjisLen) {
            int plen;
            String s;
            if (useSjisGenerator) {
                if (EnumSet.of(CharType.KANJI).equals(tarType) || tarType.contains((Object)CharType.KANJI) && rnd.nextInt(100) < 30) {
                    s = MaskingUtil.getRandomSjisKanji();
                } else if (EnumSet.of(CharType.HIRAGANA).equals(tarType) || tarType.contains((Object)CharType.HIRAGANA) && rnd.nextInt(100) < 90) {
                    s = "";
                    while (MaskingUtil.isInvalidNextLetter(sb, s = MaskingUtil.getRandomHiragana())) {
                    }
                } else if (EnumSet.of(CharType.WIDE_LOWER_ALPHA).equals(tarType) || tarType.contains((Object)CharType.WIDE_LOWER_ALPHA) && rnd.nextInt(100) < 10) {
                    s = MaskingUtil.getRandomSjisWideLowerAlpha();
                } else if (EnumSet.of(CharType.WIDE_UPPER_ALPHA).equals(tarType) || tarType.contains((Object)CharType.WIDE_UPPER_ALPHA) && rnd.nextInt(100) < 10) {
                    s = MaskingUtil.getRandomSjisWideUpperAlpha();
                } else if (EnumSet.of(CharType.WIDE_NUMBER).equals(tarType) || tarType.contains((Object)CharType.WIDE_NUMBER) && rnd.nextInt(100) < 10) {
                    s = MaskingUtil.getRandomSjisWideNumber();
                } else if (EnumSet.of(CharType.WIDE_KANA).equals(tarType) || tarType.contains((Object)CharType.WIDE_KANA) && rnd.nextInt(100) < 10) {
                    s = "";
                    while (MaskingUtil.isInvalidNextLetter(sb, s = MaskingUtil.getRandomSjisWideKana())) {
                    }
                } else if (EnumSet.of(CharType.HALF_KANA).equals(tarType) || tarType.contains((Object)CharType.HALF_KANA) && rnd.nextInt(100) < 10) {
                    s = "";
                    while (MaskingUtil.isInvalidNextLetter(sb, s = MaskingUtil.getRandomHalfKana())) {
                    }
                } else {
                    if (cardinality <= 0) continue;
                    s = (String)tarCharList.get(rnd.nextInt(cardinality));
                }
                plen = s.getBytes(Charset.forName("MS932")).length;
            } else {
                s = (String)tarCharList.get(rnd.nextInt(cardinality));
                plen = s.getBytes(Charset.forName("MS932")).length;
            }
            if (noGenPattern != null && noGenPattern.matcher(s).find()) continue;
            if (i + plen <= sjisLen) {
                sb.append(s);
                i += plen;
            }
            if (useHalfChar || sjisLen - i != 1) continue;
            break;
        }
        return sb.toString();
    }

    public static int getRandomIndex(int[] weights) {
        return MaskingUtil.getRandomIndex(weights, -1);
    }

    public static int getRandomIndex(int[] weights, int totalWeight) {
        int total = totalWeight;
        if (total < 0) {
            total = 0;
            for (int i = 0; i < weights.length; ++i) {
                total += weights[i];
            }
        }
        int val = rnd.nextInt(total) + 1;
        int idx = -1;
        int len = weights.length;
        for (int i = 0; i < len; ++i) {
            if (weights[i] >= val) {
                idx = i;
                break;
            }
            val -= weights[i];
        }
        return idx;
    }

    public static String getRandomHiragana() {
        int idx = -1;
        while (idx < 0) {
            idx = MaskingUtil.getRandomIndex(HIRAGANA_RATIO, hiraganaTotalWeight);
        }
        return HIRAGANA_CHARACTER[idx];
    }

    public static String getRandomHalfKana() {
        int idx = -1;
        while (idx < 0) {
            idx = MaskingUtil.getRandomIndex(HKANA_RATIO, halfKanaTotalWeight);
        }
        return HKANA_CHARACTER[idx];
    }

    public static String getRandomSjisKanji() {
        int[] bytes = new int[2];
        boolean isValid = false;
        while (!isValid) {
            int code;
            int max;
            int min;
            if (rnd.nextInt(100) < 80) {
                min = 136;
                max = 152;
            } else {
                min = 152;
                max = 252;
            }
            bytes[0] = rnd.nextInt(max + 1 - min) + min;
            bytes[1] = rnd.nextInt(189) + 64;
            if (bytes[1] == 127 || bytes[0] >= 160 && bytes[0] <= 223 || bytes[0] >= 235 && bytes[0] <= 249 || !((code = Integer.valueOf(String.format("%02x%02x", bytes[0], bytes[1]), 16).intValue()) >= 34975 && code <= 39026 || code >= 39071 && code <= 40956 || code >= 57408 && code <= 60068) && (code < 64092 || code > 64587)) continue;
            isValid = true;
        }
        return new String(new byte[]{(byte)bytes[0], (byte)bytes[1]}, Charset.forName("MS932"));
    }

    public static String getRandomSjisWideKana() {
        int[] bytes = new int[2];
        boolean isValid = false;
        while (!isValid) {
            bytes[0] = 131;
            bytes[1] = rnd.nextInt(85) + 64;
            if (bytes[1] == 127) continue;
            isValid = true;
        }
        return new String(new byte[]{(byte)bytes[0], (byte)bytes[1]}, Charset.forName("MS932"));
    }

    public static String getRandomSjisWideUpperAlpha() {
        int[] bytes = new int[]{130, rnd.nextInt(26) + 96};
        return new String(new byte[]{(byte)bytes[0], (byte)bytes[1]}, Charset.forName("MS932"));
    }

    public static String getRandomSjisWideLowerAlpha() {
        int[] bytes = new int[]{130, rnd.nextInt(26) + 129};
        return new String(new byte[]{(byte)bytes[0], (byte)bytes[1]}, Charset.forName("MS932"));
    }

    public static String getRandomSjisWideNumber() {
        int[] bytes = new int[]{130, rnd.nextInt(10) + 79};
        return new String(new byte[]{(byte)bytes[0], (byte)bytes[1]}, Charset.forName("MS932"));
    }

    public static int getRandomNumber(int min, int max) {
        return MaskingUtil.getRandomNumber(BigInteger.valueOf(min), BigInteger.valueOf(max)).intValue();
    }

    public static long getRandomNumber(long min, long max) {
        return MaskingUtil.getRandomNumber(BigInteger.valueOf(min), BigInteger.valueOf(max)).longValue();
    }

    public static BigInteger getRandomNumber(BigInteger min, BigInteger max) {
        BigInteger upperLimit = max.subtract(min);
        int len = upperLimit.bitLength();
        BigInteger bi = new BigInteger(len, new SecureRandom());
        if (bi.compareTo(upperLimit) > 0) {
            bi = bi.mod(upperLimit);
        }
        return bi.add(min);
    }

    public static BigDecimal getRandomNumber(BigDecimal min, BigDecimal max) {
        BigDecimal p = BigDecimal.TEN.pow(Math.max(min.scale(), max.scale()));
        BigInteger biMin = min.multiply(p).toBigInteger();
        BigInteger biMax = max.multiply(p).toBigInteger();
        BigDecimal ret = new BigDecimal(MaskingUtil.getRandomNumber(biMin, biMax));
        return ret.divide(p);
    }

    public static LocalDateTime getRandomDate(LocalDateTime min, LocalDateTime max) {
        long days = ChronoUnit.DAYS.between(min, max);
        return min.plusDays(ThreadLocalRandom.current().nextLong(days + 1L));
    }

    public static String getLuhnDigit(String cardNo) {
        int[] numbers = cardNo.chars().map(e -> Character.digit(e, 10)).toArray();
        int len = numbers.length - 1;
        int sum = 0;
        for (int i = 0; i < len; ++i) {
            if (i % 2 != 0) {
                int n = i;
                numbers[n] = numbers[n] * 2;
            }
            if (numbers[i] > 9) {
                numbers[i] = numbers[i] % 10 + numbers[i] / 10;
            }
            sum += numbers[i];
        }
        int checkDigit = (10 - sum % 10) % 10;
        return Integer.toString(checkDigit);
    }

    static {
        int i;
        LOWER_ALPHA_CHARACTER = new String[]{"a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z"};
        UPPER_ALPHA_CHARACTER = new String[]{"A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z"};
        NUMBER_CHARACTER = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9"};
        SPECIAL_CHARACTER = new String[]{"!", "\"", "#", "$", "%", "&", "'", "(", ")", "*", "+", ",", "-", ".", "/", ":", ";", "<", "=", ">", "?", "@", "[", "\\", "]", "^", "_", "`", "{", "|", "}", "~"};
        WSPECIAL_CHARACTER = new String[]{"\uff01", "\u201d", "\uff03", "\uff04", "\uff05", "\uff06", "\u2019", "\uff08", "\uff09", "\uff0a", "\uff0b", "\uff0c", "\uff0d", "\uff0e", "\uff0f", "\uff1a", "\uff1b", "\uff1c", "\uff1d", "\uff1e", "\uff1f", "\uff20", "\uff3b", "\uffe5", "\uff3d", "\uff3e", "\uff3f", "\uff40", "\uff5b", "\uff5c", "\uff5d", "\uffe3"};
        HKANA_CHARACTER_FULL = new String[]{"\uff71", "\uff72", "\uff73", "\uff74", "\uff75", "\uff76", "\uff77", "\uff78", "\uff79", "\uff7a", "\uff7b", "\uff7c", "\uff7d", "\uff7e", "\uff7f", "\uff80", "\uff81", "\uff82", "\uff83", "\uff84", "\uff85", "\uff86", "\uff87", "\uff88", "\uff89", "\uff8a", "\uff8b", "\uff8c", "\uff8d", "\uff8e", "\uff8f", "\uff90", "\uff91", "\uff92", "\uff93", "\uff94", "\uff95", "\uff96", "\uff97", "\uff98", "\uff99", "\uff9a", "\uff9b", "\uff9c", "\uff66", "\uff9d", "\uff76\uff9e", "\uff77\uff9e", "\uff78\uff9e", "\uff79\uff9e", "\uff7a\uff9e", "\uff7b\uff9e", "\uff7c\uff9e", "\uff7d\uff9e", "\uff7e\uff9e", "\uff7f\uff9e", "\uff80\uff9e", "\uff81\uff9e", "\uff82\uff9e", "\uff83\uff9e", "\uff84\uff9e", "\uff8a\uff9e", "\uff8b\uff9e", "\uff8c\uff9e", "\uff8d\uff9e", "\uff8e\uff9e", "\uff73\uff9e", "\uff70", "\uff61", "\uff64", "\uff62", "\uff63", "\uff8a\uff9f", "\uff8b\uff9f", "\uff8c\uff9f", "\uff8d\uff9f", "\uff8e\uff9f", "\uff67", "\uff68", "\uff69", "\uff6a", "\uff6b", "\uff6f", "\uff6c", "\uff6d", "\uff6e"};
        WKANA_CHARACTER_FULL = new String[]{"\u30a2", "\u30a4", "\u30a6", "\u30a8", "\u30aa", "\u30ab", "\u30ad", "\u30af", "\u30b1", "\u30b3", "\u30b5", "\u30b7", "\u30b9", "\u30bb", "\u30bd", "\u30bf", "\u30c1", "\u30c4", "\u30c6", "\u30c8", "\u30ca", "\u30cb", "\u30cc", "\u30cd", "\u30ce", "\u30cf", "\u30d2", "\u30d5", "\u30d8", "\u30db", "\u30de", "\u30df", "\u30e0", "\u30e1", "\u30e2", "\u30e4", "\u30e6", "\u30e8", "\u30e9", "\u30ea", "\u30eb", "\u30ec", "\u30ed", "\u30ef", "\u30f2", "\u30f3", "\u30ac", "\u30ae", "\u30b0", "\u30b2", "\u30b4", "\u30b6", "\u30b8", "\u30ba", "\u30bc", "\u30be", "\u30c0", "\u30c2", "\u30c5", "\u30c7", "\u30c9", "\u30d0", "\u30d3", "\u30d6", "\u30d9", "\u30dc", "\u30f4", "\u30fc", "\u3002", "\u3001", "\u300c", "\u300d", "\u30d1", "\u30d4", "\u30d7", "\u30da", "\u30dd", "\u30a1", "\u30a3", "\u30a5", "\u30a7", "\u30a9", "\u30c3", "\u30e3", "\u30e5", "\u30e7"};
        HKANA_CHARACTER = new String[]{"\uff73", "\uff81", "\uff7c", "\uff6e", "\uff76", "\uff8f", "\uff72", "\uff90", "\uff9d", "\uff80", "\uff75", "\uff85", "\uff9c", "\uff77", "\uff76\uff9e", "\uff78", "\uff89", "\uff97", "\uff94", "\uff7b", "\uff7c\uff9e", "\uff84", "\uff80\uff9e", "\uff86", "\uff93", "\uff8b", "\uff98", "\uff82", "\uff8a", "\uff7a", "\uff71", "\uff74", "\uff99", "\uff7d", "\uff8a\uff9e", "\uff8c", "\uff9b", "\uff84\uff9e", "\uff96", "\uff7e", "\uff8e", "\uff7a\uff9e", "\uff6d", "\uff79", "\uff70", "\uff77\uff9e", "\uff78\uff9e", "\uff92", "\uff7d\uff9e", "\uff7b\uff9e", "\uff91", "\uff83", "\uff83\uff9e", "\uff88", "\uff7f", "\uff8b\uff9e", "\uff8d\uff9e", "\uff8c\uff9e", "\uff8e\uff9e", "\uff6f", "\uff82\uff9e", "\uff79\uff9e", "\uff95", "\uff87", "\uff7e\uff9e", "\uff68", "\uff7f\uff9e", "\uff9a", "\uff6c", "\uff8e\uff9f", "\uff8d", "\uff8a\uff9f", "\uff6a", "\uff8c\uff9f", "\uff8b\uff9f", "\uff8d\uff9f", "\uff81\uff9e", "\uff73\uff9e", "\uff66"};
        HKANA_RATIO = new int[]{533, 509, 367, 348, 336, 335, 274, 227, 218, 208, 197, 162, 154, 146, 145, 144, 142, 138, 137, 118, 117, 112, 98, 93, 91, 88, 88, 87, 85, 80, 74, 63, 56, 54, 52, 47, 46, 46, 44, 42, 38, 36, 35, 34, 33, 33, 32, 31, 29, 28, 27, 26, 26, 26, 25, 23, 22, 20, 20, 19, 19, 13, 12, 11, 9, 8, 8, 8, 7, 5, 5, 4, 3, 3, 2, 2, 1, 1, 1};
        HIRAGANA_CHARACTER = new String[]{"\u3044", "\u3057", "\u3046", "\u3093", "\u305f", "\u306e", "\u304b", "\u3068", "\u306b", "\u306a", "\u3066", "\u306f", "\u304f", "\u307e", "\u3053", "\u304d", "\u3063", "\u304c", "\u308b", "\u3067", "\u304a", "\u3082", "\u3042", "\u308a", "\u3092", "\u3089", "\u3059", "\u3087", "\u3058", "\u3064", "\u3055", "\u3061", "\u3060", "\u308c", "\u305d", "\u3088", "\u308f", "\u3051", "\u3048", "\u305b", "\u307f", "\u3069", "\u308d", "\u3085", "\u3072", "\u3081", "\u3084", "\u3070", "\u3054", "\u3075", "\u3083", "\u306d", "\u307b", "\u3076", "\u3052", "\u3080", "\u304e", "\u3073", "\u305a", "\u3078", "\u307c", "\u3086", "\u3050", "\u3079", "\u3056", "\u305c", "\u3071", "\u305e", "\u3077", "\u3074", "\u3065", "\u307d", "\u306c", "\u3043", "\u307a", "\u3047", "\u3041", "\u3049", "\u3045", "\u3062", "\u308e"};
        HIRAGANA_RATIO = new int[]{621, 467, 460, 440, 413, 394, 363, 324, 273, 267, 25, 259, 233, 233, 232, 218, 217, 209, 184, 172, 168, 165, 165, 165, 165, 162, 158, 149, 145, 143, 139, 137, 136, 135, 113, 102, 96, 96, 92, 90, 90, 81, 77, 74, 65, 64, 62, 55, 54, 51, 50, 47, 45, 44, 35, 35, 34, 34, 33, 31, 27, 21, 21, 20, 17, 17, 16, 15, 11, 10, 9, 7, 7, 7, 4, 3, 3, 2, 1, 1, 1};
        halfKanaTotalWeight = 0;
        hiraganaTotalWeight = 0;
        rnd = new SecureRandom();
        lowerHalfKanaMap = new HashMap<String, String>();
        lowerWideKanaMap = new HashMap<String, String>();
        lowerHiraganaMap = new HashMap<String, String>();
        halfKanaTable = new ArrayList<String>();
        wideKanaTable = new ArrayList<String>();
        for (i = 0; i < HKANA_RATIO.length; ++i) {
            halfKanaTotalWeight += HKANA_RATIO[i];
        }
        for (i = 0; i < HIRAGANA_RATIO.length; ++i) {
            hiraganaTotalWeight += HIRAGANA_RATIO[i];
        }
        lowerHalfKanaMap.put("\uff67", "\uff71");
        lowerHalfKanaMap.put("\uff68", "\uff72");
        lowerHalfKanaMap.put("\uff69", "\uff73");
        lowerHalfKanaMap.put("\uff6a", "\uff74");
        lowerHalfKanaMap.put("\uff6b", "\uff75");
        lowerHalfKanaMap.put("\uff6f", "\uff82");
        lowerHalfKanaMap.put("\uff6c", "\uff94");
        lowerHalfKanaMap.put("\uff6d", "\uff95");
        lowerHalfKanaMap.put("\uff6e", "\uff96");
        lowerWideKanaMap.put("\u30a1", "\u30a2");
        lowerWideKanaMap.put("\u30a3", "\u30a4");
        lowerWideKanaMap.put("\u30a5", "\u30a6");
        lowerWideKanaMap.put("\u30a7", "\u30a8");
        lowerWideKanaMap.put("\u30a9", "\u30aa");
        lowerWideKanaMap.put("\u30f5", "\u30ab");
        lowerWideKanaMap.put("\u30f6", "\u30b1");
        lowerWideKanaMap.put("\u30c3", "\u30c4");
        lowerWideKanaMap.put("\u30e3", "\u30e4");
        lowerWideKanaMap.put("\u30e5", "\u30e6");
        lowerWideKanaMap.put("\u30e7", "\u30e8");
        lowerWideKanaMap.put("\u30ee", "\u30ef");
        lowerHiraganaMap.put("\u3041", "\u3042");
        lowerHiraganaMap.put("\u3043", "\u3044");
        lowerHiraganaMap.put("\u3045", "\u3046");
        lowerHiraganaMap.put("\u3047", "\u3048");
        lowerHiraganaMap.put("\u3049", "\u304a");
        lowerHiraganaMap.put("\u3063", "\u3064");
        lowerHiraganaMap.put("\u3083", "\u3084");
        lowerHiraganaMap.put("\u3085", "\u3086");
        lowerHiraganaMap.put("\u3087", "\u3088");
        lowerHiraganaMap.put("\u308e", "\u308f");
        halfKanaTable = Arrays.asList(HKANA_CHARACTER_FULL);
        wideKanaTable = Arrays.asList(WKANA_CHARACTER_FULL);
    }

    public static enum CharType {
        NONE(-1, "\u306a\u3057", 0),
        UNKNOWN(0, "\u4e0d\u660e", 2),
        LOWER_ALPHA(1, "\u82f1\u5c0f\u6587\u5b57", 1),
        UPPER_ALPHA(2, "\u82f1\u5927\u6587\u5b57", 1),
        NUMBER(3, "\u6570\u5b57", 1),
        HALF_KANA(4, "\u534a\u89d2\u30ab\u30bf\u30ab\u30ca", 1),
        SPECIAL(5, "\u8a18\u53f7", 1),
        WIDE_LOWER_ALPHA(10, "\u5168\u89d2\u82f1\u5c0f\u6587\u5b57", 2),
        WIDE_UPPER_ALPHA(11, "\u5168\u89d2\u82f1\u5927\u6587\u5b57", 2),
        WIDE_NUMBER(12, "\u5168\u89d2\u6570\u5b57", 2),
        WIDE_KANA(13, "\u5168\u89d2\u30ab\u30bf\u30ab\u30ca", 2),
        HIRAGANA(14, "\u3072\u3089\u304c\u306a", 2),
        KANJI(15, "\u6f22\u5b57", 2),
        WIDE_SPECIAL(16, "\u5168\u89d2\u8a18\u53f7", 2),
        ALPHA(80, "\u82f1\u5b57", 1),
        ALPHANUM(81, "\u82f1\u6570", 1),
        HALF(82, "\u8a18\u53f7\u3092\u9664\u304f\u534a\u89d2\u6587\u5b57", 1),
        HALF_WITH_SPECIAL(83, "\u534a\u89d2\u6587\u5b57", 1),
        WIDE_ALPHA(90, "\u5168\u89d2\u82f1\u5b57", 2),
        WIDE_ALPHANUM(91, "\u5168\u89d2\u82f1\u6570", 2),
        WIDE(92, "\u8a18\u53f7\u3092\u9664\u304f\u5168\u89d2\u6587\u5b57", 2),
        WIDE_WITH_SPECIAL(93, "\u5168\u89d2\u6587\u5b57", 2),
        ALL(99, "\u3059\u3079\u3066", 2);

        private int code;
        private String name;
        private int reqByte;

        private CharType(int code, String name, int reqByte) {
            this.code = code;
            this.name = name;
            this.reqByte = reqByte;
        }

        public int getCode() {
            return this.code;
        }

        public String getName() {
            return this.name;
        }

        public int getReqByte() {
            return this.reqByte;
        }

        public static CharType getTypeByString(String str) {
            CharType ret = UNKNOWN;
            if (str != null && str.length() > 0) {
                char c = str.charAt(0);
                String s = String.valueOf(c);
                Character.UnicodeBlock uniBlock = Character.UnicodeBlock.of(c);
                if (uniBlock == Character.UnicodeBlock.HIRAGANA) {
                    ret = HIRAGANA;
                } else if (uniBlock == Character.UnicodeBlock.KATAKANA) {
                    ret = WIDE_KANA;
                } else if (uniBlock == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS) {
                    ret = KANJI;
                } else if (uniBlock == Character.UnicodeBlock.BASIC_LATIN) {
                    if (s.matches("[a-z]")) {
                        ret = LOWER_ALPHA;
                    } else if (s.matches("[A-Z]")) {
                        ret = UPPER_ALPHA;
                    } else if (s.matches("[0-9]")) {
                        ret = NUMBER;
                    } else if (s.matches("[!\"#$%&'()*+,-./:;<=>?@\\[\\]^_`{|}~]")) {
                        ret = SPECIAL;
                    }
                } else if (uniBlock == Character.UnicodeBlock.HALFWIDTH_AND_FULLWIDTH_FORMS) {
                    if (s.matches("[\uff41-\uff5a]")) {
                        ret = WIDE_LOWER_ALPHA;
                    } else if (s.matches("[\uff21-\uff3a]")) {
                        ret = WIDE_UPPER_ALPHA;
                    } else if (s.matches("[\uff10-\uff19]")) {
                        ret = WIDE_NUMBER;
                    } else if (s.matches("[\uff01\u201d\uff03\uff04\uff05\uff06\u2019\uff08\uff09\uff0a\uff0b\uff0c\uff0d\uff0e\uff0f\uff1a\uff1b\uff1c\uff1d\uff1e\uff1f\uff20\uff3b\uffe5\uff3d\uff3e\uff3f\uff40\uff5b\uff5c\uff5d\uffe3]")) {
                        ret = WIDE_SPECIAL;
                    } else if (s.matches("[\\uFF61-\\uFF9F]")) {
                        ret = HALF_KANA;
                    }
                }
            }
            return ret;
        }
    }
}

