/*
 * Decompiled with CFR 0.152.
 */
package net.utsuro.mask;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import lombok.Generated;
import net.utsuro.mask.MaskingUtil;

public class MaskingRule {
    private int unmaksedLengthLeft = 0;
    private int unmaksedLengthRight = 0;
    private Pattern unmaksedCharPattern = null;
    private Pattern ignoreValuePattern = null;
    private boolean useOddCharMask = false;
    private boolean useEvenCharMask = false;
    private boolean useAfterTextReplace = false;
    private boolean useAfterRepOddCharMask = false;
    private boolean useAfterRepEvenCharMask = false;
    private boolean useWhiteSpaceMask = false;
    private String replacementHalfChar = "X";
    private String replacementWideChar = "\u25cb";
    private String replacementHalfNum = "9";
    private String replacementWideNum = "\uff19";
    private boolean nullReplace = false;
    private boolean invalidDateReplace = false;
    private MaskingUtil.CharType randomGenCharType = null;
    private Pattern randomNoGenCharPattern = null;
    private String minValue = "";
    private String maxValue = "";
    private BigDecimal minDecimalValue = null;
    private BigDecimal maxDecimalValue = null;
    private String prefix = "";
    private String suffix = "";
    private int minSjisByteCount = 0;
    private int maxSjisByteCount = 0;
    private String domainReplacement = "";
    private LocalDateTime minDate = null;
    private LocalDateTime maxDate = null;
    private String termFrom = null;
    private String termTo = null;
    private String[] pickupList = null;
    private int[] pickupWeights = null;
    private String selectListTableName = "";
    private String selectListColName = "";
    private String selectListSeqNoColName = "";
    private boolean usePostCodeFormat = true;
    private boolean useHalfKana = false;
    private boolean useUpperCaseKana = false;
    private boolean useWideKana = false;
    private boolean useHiragana = false;
    private boolean useUpperCase = false;
    private boolean useLowerCase = false;
    private boolean useBanchiGenerate = true;
    private String addrFormat = "%zip,%pref,%city,%town,%street,%prefKana,%cityKana,%townKana,%streetKana,%jisKenCode,%jisCityCode,%jisCityShortCode,%addrCode";
    private int[] maxSjisByteCounts = null;
    private boolean[] shiftOverflowStrings = null;
    private String fullNameFormat = "%lastNameKanji %firstNameKanji,%lastNameKana %firstNameKana";
    private boolean isDeterministicReplace = false;
    private boolean isUniqueValue = false;
    private String uniqueId = "";
    private String toClassName = "";
    private List<String> toClassNames = null;
    private String dateTimeFormat = "";
    private String fixedValue = "";
    private boolean keepWideSpaceTrim = false;
    private boolean useLTrim = false;
    private boolean useRTrim = false;
    private String separator = "";
    private int beginIndex = 0;
    private int endIndex = 0;
    private String textReplaceRegex = "";
    private String textReplacement = "";
    private boolean beforeTrim = false;

    public MaskingRule() {
    }

    public MaskingRule(MaskingRule that) {
        this.unmaksedLengthLeft = that.getUnmaksedLengthLeft();
        this.unmaksedLengthRight = that.getUnmaksedLengthRight();
        this.unmaksedCharPattern = that.getUnmaksedCharPattern();
        this.ignoreValuePattern = that.getIgnoreValuePattern();
        this.useOddCharMask = that.useOddCharMask();
        this.useEvenCharMask = that.useEvenCharMask();
        this.useAfterTextReplace = that.useAfterTextReplace();
        this.useAfterRepOddCharMask = that.useAfterRepOddCharMask();
        this.useAfterRepEvenCharMask = that.useAfterRepEvenCharMask();
        this.useWhiteSpaceMask = that.useWhiteSpaceMask();
        this.replacementHalfChar = that.getReplacementHalfChar();
        this.replacementWideChar = that.getReplacementWideChar();
        this.replacementHalfNum = that.getReplacementHalfNum();
        this.replacementWideNum = that.getReplacementWideNum();
        this.nullReplace = that.isNullReplace();
        this.invalidDateReplace = that.isInvalidDateReplace();
        this.randomGenCharType = that.getRandomGenCharType();
        this.randomNoGenCharPattern = that.getRandomNoGenCharPattern();
        this.minValue = that.getMinValue();
        this.maxValue = that.getMaxValue();
        this.minDecimalValue = that.getMinDecimalValue();
        this.maxDecimalValue = that.getMaxDecimalValue();
        this.prefix = that.getPrefix();
        this.suffix = that.getSuffix();
        this.minSjisByteCount = that.getMinSjisByteCount();
        this.maxSjisByteCount = that.getMaxSjisByteCount();
        this.domainReplacement = that.getDomainReplacement();
        this.minDate = that.getMinDate();
        this.maxDate = that.getMaxDate();
        this.termFrom = that.getTermFrom();
        this.termTo = that.getTermTo();
        if (that.getPickupList() != null) {
            this.pickupList = new String[that.getPickupList().length];
            System.arraycopy(that.getPickupList(), 0, this.pickupList, 0, that.getPickupList().length);
        }
        if (that.getPickupWeights() != null) {
            this.pickupWeights = new int[that.getPickupWeights().length];
            System.arraycopy(that.getPickupWeights(), 0, this.pickupWeights, 0, that.getPickupWeights().length);
        }
        this.selectListTableName = that.getSelectListTableName();
        this.selectListColName = that.getSelectListColName();
        this.selectListSeqNoColName = that.getSelectListSeqNoColName();
        this.usePostCodeFormat = that.usePostCodeFormat();
        this.useHalfKana = that.useHalfKana();
        this.useUpperCaseKana = that.useUpperCaseKana();
        this.useWideKana = that.useWideKana();
        this.useHiragana = that.useHiragana();
        this.useUpperCase = that.useUpperCase();
        this.useLowerCase = that.useLowerCase();
        this.useBanchiGenerate = that.useBanchiGenerate();
        this.addrFormat = that.getAddrFormat();
        this.fullNameFormat = that.getFullNameFormat();
        this.isDeterministicReplace = that.isDeterministicReplace();
        this.isUniqueValue = that.isUniqueValue();
        this.toClassName = that.getToClassName();
        if (that.getToClassNames() != null) {
            this.toClassNames = new ArrayList<String>(that.getToClassNames());
        }
        this.dateTimeFormat = that.getDateTimeFormat();
        this.fixedValue = that.getFixedValue();
        this.keepWideSpaceTrim = that.isKeepWideSpaceTrim();
        this.useLTrim = that.useLTrim();
        this.useRTrim = that.useRTrim();
        this.separator = that.getSeparator();
        this.beginIndex = that.getBeginIndex();
        this.endIndex = that.getEndIndex();
        this.textReplaceRegex = that.getTextReplaceRegex();
        this.textReplacement = that.getTextReplacement();
        this.beforeTrim = that.isBeforeTrim();
    }

    public int getUnmaksedLengthRight() {
        return Math.max(this.unmaksedLengthRight, 0);
    }

    public String getUnmaksedChar() {
        return this.unmaksedCharPattern != null ? this.unmaksedCharPattern.toString() : "";
    }

    public void setUnmaksedChar(String unmaksedChar) {
        this.unmaksedCharPattern = unmaksedChar != null && !unmaksedChar.isEmpty() ? Pattern.compile(unmaksedChar, 2) : null;
    }

    public String getIgnoreValue() {
        return this.ignoreValuePattern != null ? this.ignoreValuePattern.toString() : "";
    }

    public void setIgnoreValue(String ignoreValue) {
        this.ignoreValuePattern = ignoreValue != null && !ignoreValue.isEmpty() ? Pattern.compile(ignoreValue, 2) : null;
    }

    public boolean useReplacementHalfChar() {
        return this.replacementHalfChar != null && !this.replacementHalfChar.isEmpty();
    }

    public boolean useReplacementHalfNum() {
        return this.replacementHalfNum != null && !this.replacementHalfNum.isEmpty();
    }

    public boolean useReplacementWideChar() {
        return this.replacementWideChar != null && !this.replacementWideChar.isEmpty();
    }

    public boolean useReplacementWideNum() {
        return this.replacementWideNum != null && !this.replacementWideNum.isEmpty();
    }

    public boolean useRandomGenCharType() {
        return this.randomGenCharType != null && this.randomGenCharType != MaskingUtil.CharType.UNKNOWN;
    }

    public String getRandomNoGenChar() {
        return this.randomNoGenCharPattern != null ? this.randomNoGenCharPattern.toString() : "";
    }

    public void setRandomNoGenChar(String randomNoGenChar) {
        this.randomNoGenCharPattern = randomNoGenChar != null && !randomNoGenChar.isEmpty() ? Pattern.compile(randomNoGenChar, 2) : null;
    }

    public void setMinValue(String minValue) {
        this.minValue = minValue;
        this.minDecimalValue = minValue != null && !minValue.isEmpty() && minValue.matches("-?\\d+(\\.\\d+)?") ? new BigDecimal(minValue) : null;
    }

    public void setMaxValue(String maxValue) {
        this.maxValue = maxValue;
        this.maxDecimalValue = maxValue != null && !maxValue.isEmpty() && maxValue.matches("-?\\d+(\\.\\d+)?") ? new BigDecimal(maxValue) : null;
    }

    public void setMinDecimalValue(BigDecimal minDecimalValue) {
        this.minDecimalValue = minDecimalValue;
        if (minDecimalValue != null) {
            this.minValue = this.minDecimalValue.toString();
        }
    }

    public void setMaxDecimalValue(BigDecimal maxDecimalValue) {
        this.maxDecimalValue = maxDecimalValue;
        if (maxDecimalValue != null) {
            this.maxValue = this.maxDecimalValue.toString();
        }
    }

    public String getSelectListSeqNoColName() {
        if (this.selectListSeqNoColName == null || this.selectListSeqNoColName.isEmpty()) {
            return "seqno";
        }
        return this.selectListSeqNoColName;
    }

    @Generated
    public int getUnmaksedLengthLeft() {
        return this.unmaksedLengthLeft;
    }

    @Generated
    public Pattern getUnmaksedCharPattern() {
        return this.unmaksedCharPattern;
    }

    @Generated
    public Pattern getIgnoreValuePattern() {
        return this.ignoreValuePattern;
    }

    @Generated
    public boolean useOddCharMask() {
        return this.useOddCharMask;
    }

    @Generated
    public boolean useEvenCharMask() {
        return this.useEvenCharMask;
    }

    @Generated
    public boolean useAfterTextReplace() {
        return this.useAfterTextReplace;
    }

    @Generated
    public boolean useAfterRepOddCharMask() {
        return this.useAfterRepOddCharMask;
    }

    @Generated
    public boolean useAfterRepEvenCharMask() {
        return this.useAfterRepEvenCharMask;
    }

    @Generated
    public boolean useWhiteSpaceMask() {
        return this.useWhiteSpaceMask;
    }

    @Generated
    public String getReplacementHalfChar() {
        return this.replacementHalfChar;
    }

    @Generated
    public String getReplacementWideChar() {
        return this.replacementWideChar;
    }

    @Generated
    public String getReplacementHalfNum() {
        return this.replacementHalfNum;
    }

    @Generated
    public String getReplacementWideNum() {
        return this.replacementWideNum;
    }

    @Generated
    public boolean isNullReplace() {
        return this.nullReplace;
    }

    @Generated
    public boolean isInvalidDateReplace() {
        return this.invalidDateReplace;
    }

    @Generated
    public MaskingUtil.CharType getRandomGenCharType() {
        return this.randomGenCharType;
    }

    @Generated
    public Pattern getRandomNoGenCharPattern() {
        return this.randomNoGenCharPattern;
    }

    @Generated
    public String getMinValue() {
        return this.minValue;
    }

    @Generated
    public String getMaxValue() {
        return this.maxValue;
    }

    @Generated
    public BigDecimal getMinDecimalValue() {
        return this.minDecimalValue;
    }

    @Generated
    public BigDecimal getMaxDecimalValue() {
        return this.maxDecimalValue;
    }

    @Generated
    public String getPrefix() {
        return this.prefix;
    }

    @Generated
    public String getSuffix() {
        return this.suffix;
    }

    @Generated
    public int getMinSjisByteCount() {
        return this.minSjisByteCount;
    }

    @Generated
    public int getMaxSjisByteCount() {
        return this.maxSjisByteCount;
    }

    @Generated
    public String getDomainReplacement() {
        return this.domainReplacement;
    }

    @Generated
    public LocalDateTime getMinDate() {
        return this.minDate;
    }

    @Generated
    public LocalDateTime getMaxDate() {
        return this.maxDate;
    }

    @Generated
    public String getTermFrom() {
        return this.termFrom;
    }

    @Generated
    public String getTermTo() {
        return this.termTo;
    }

    @Generated
    public String[] getPickupList() {
        return this.pickupList;
    }

    @Generated
    public int[] getPickupWeights() {
        return this.pickupWeights;
    }

    @Generated
    public String getSelectListTableName() {
        return this.selectListTableName;
    }

    @Generated
    public String getSelectListColName() {
        return this.selectListColName;
    }

    @Generated
    public boolean usePostCodeFormat() {
        return this.usePostCodeFormat;
    }

    @Generated
    public boolean useHalfKana() {
        return this.useHalfKana;
    }

    @Generated
    public boolean useUpperCaseKana() {
        return this.useUpperCaseKana;
    }

    @Generated
    public boolean useWideKana() {
        return this.useWideKana;
    }

    @Generated
    public boolean useHiragana() {
        return this.useHiragana;
    }

    @Generated
    public boolean useUpperCase() {
        return this.useUpperCase;
    }

    @Generated
    public boolean useLowerCase() {
        return this.useLowerCase;
    }

    @Generated
    public boolean useBanchiGenerate() {
        return this.useBanchiGenerate;
    }

    @Generated
    public String getAddrFormat() {
        return this.addrFormat;
    }

    @Generated
    public int[] getMaxSjisByteCounts() {
        return this.maxSjisByteCounts;
    }

    @Generated
    public boolean[] getShiftOverflowStrings() {
        return this.shiftOverflowStrings;
    }

    @Generated
    public String getFullNameFormat() {
        return this.fullNameFormat;
    }

    @Generated
    public boolean isDeterministicReplace() {
        return this.isDeterministicReplace;
    }

    @Generated
    public boolean isUniqueValue() {
        return this.isUniqueValue;
    }

    @Generated
    public String getUniqueId() {
        return this.uniqueId;
    }

    @Generated
    public String getToClassName() {
        return this.toClassName;
    }

    @Generated
    public List<String> getToClassNames() {
        return this.toClassNames;
    }

    @Generated
    public String getDateTimeFormat() {
        return this.dateTimeFormat;
    }

    @Generated
    public String getFixedValue() {
        return this.fixedValue;
    }

    @Generated
    public boolean isKeepWideSpaceTrim() {
        return this.keepWideSpaceTrim;
    }

    @Generated
    public boolean useLTrim() {
        return this.useLTrim;
    }

    @Generated
    public boolean useRTrim() {
        return this.useRTrim;
    }

    @Generated
    public String getSeparator() {
        return this.separator;
    }

    @Generated
    public int getBeginIndex() {
        return this.beginIndex;
    }

    @Generated
    public int getEndIndex() {
        return this.endIndex;
    }

    @Generated
    public String getTextReplaceRegex() {
        return this.textReplaceRegex;
    }

    @Generated
    public String getTextReplacement() {
        return this.textReplacement;
    }

    @Generated
    public boolean isBeforeTrim() {
        return this.beforeTrim;
    }

    @Generated
    public void setUnmaksedLengthLeft(int unmaksedLengthLeft) {
        this.unmaksedLengthLeft = unmaksedLengthLeft;
    }

    @Generated
    public void setUnmaksedLengthRight(int unmaksedLengthRight) {
        this.unmaksedLengthRight = unmaksedLengthRight;
    }

    @Generated
    public void setUnmaksedCharPattern(Pattern unmaksedCharPattern) {
        this.unmaksedCharPattern = unmaksedCharPattern;
    }

    @Generated
    public void setIgnoreValuePattern(Pattern ignoreValuePattern) {
        this.ignoreValuePattern = ignoreValuePattern;
    }

    @Generated
    public MaskingRule useOddCharMask(boolean useOddCharMask) {
        this.useOddCharMask = useOddCharMask;
        return this;
    }

    @Generated
    public MaskingRule useEvenCharMask(boolean useEvenCharMask) {
        this.useEvenCharMask = useEvenCharMask;
        return this;
    }

    @Generated
    public MaskingRule useAfterTextReplace(boolean useAfterTextReplace) {
        this.useAfterTextReplace = useAfterTextReplace;
        return this;
    }

    @Generated
    public MaskingRule useAfterRepOddCharMask(boolean useAfterRepOddCharMask) {
        this.useAfterRepOddCharMask = useAfterRepOddCharMask;
        return this;
    }

    @Generated
    public MaskingRule useAfterRepEvenCharMask(boolean useAfterRepEvenCharMask) {
        this.useAfterRepEvenCharMask = useAfterRepEvenCharMask;
        return this;
    }

    @Generated
    public MaskingRule useWhiteSpaceMask(boolean useWhiteSpaceMask) {
        this.useWhiteSpaceMask = useWhiteSpaceMask;
        return this;
    }

    @Generated
    public void setReplacementHalfChar(String replacementHalfChar) {
        this.replacementHalfChar = replacementHalfChar;
    }

    @Generated
    public void setReplacementWideChar(String replacementWideChar) {
        this.replacementWideChar = replacementWideChar;
    }

    @Generated
    public void setReplacementHalfNum(String replacementHalfNum) {
        this.replacementHalfNum = replacementHalfNum;
    }

    @Generated
    public void setReplacementWideNum(String replacementWideNum) {
        this.replacementWideNum = replacementWideNum;
    }

    @Generated
    public void setNullReplace(boolean nullReplace) {
        this.nullReplace = nullReplace;
    }

    @Generated
    public void setInvalidDateReplace(boolean invalidDateReplace) {
        this.invalidDateReplace = invalidDateReplace;
    }

    @Generated
    public void setRandomGenCharType(MaskingUtil.CharType randomGenCharType) {
        this.randomGenCharType = randomGenCharType;
    }

    @Generated
    public void setRandomNoGenCharPattern(Pattern randomNoGenCharPattern) {
        this.randomNoGenCharPattern = randomNoGenCharPattern;
    }

    @Generated
    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    @Generated
    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    @Generated
    public void setMinSjisByteCount(int minSjisByteCount) {
        this.minSjisByteCount = minSjisByteCount;
    }

    @Generated
    public void setMaxSjisByteCount(int maxSjisByteCount) {
        this.maxSjisByteCount = maxSjisByteCount;
    }

    @Generated
    public void setDomainReplacement(String domainReplacement) {
        this.domainReplacement = domainReplacement;
    }

    @Generated
    public void setMinDate(LocalDateTime minDate) {
        this.minDate = minDate;
    }

    @Generated
    public void setMaxDate(LocalDateTime maxDate) {
        this.maxDate = maxDate;
    }

    @Generated
    public void setTermFrom(String termFrom) {
        this.termFrom = termFrom;
    }

    @Generated
    public void setTermTo(String termTo) {
        this.termTo = termTo;
    }

    @Generated
    public void setPickupList(String[] pickupList) {
        this.pickupList = pickupList;
    }

    @Generated
    public void setPickupWeights(int[] pickupWeights) {
        this.pickupWeights = pickupWeights;
    }

    @Generated
    public void setSelectListTableName(String selectListTableName) {
        this.selectListTableName = selectListTableName;
    }

    @Generated
    public void setSelectListColName(String selectListColName) {
        this.selectListColName = selectListColName;
    }

    @Generated
    public void setSelectListSeqNoColName(String selectListSeqNoColName) {
        this.selectListSeqNoColName = selectListSeqNoColName;
    }

    @Generated
    public MaskingRule usePostCodeFormat(boolean usePostCodeFormat) {
        this.usePostCodeFormat = usePostCodeFormat;
        return this;
    }

    @Generated
    public MaskingRule useHalfKana(boolean useHalfKana) {
        this.useHalfKana = useHalfKana;
        return this;
    }

    @Generated
    public MaskingRule useUpperCaseKana(boolean useUpperCaseKana) {
        this.useUpperCaseKana = useUpperCaseKana;
        return this;
    }

    @Generated
    public MaskingRule useWideKana(boolean useWideKana) {
        this.useWideKana = useWideKana;
        return this;
    }

    @Generated
    public MaskingRule useHiragana(boolean useHiragana) {
        this.useHiragana = useHiragana;
        return this;
    }

    @Generated
    public MaskingRule useUpperCase(boolean useUpperCase) {
        this.useUpperCase = useUpperCase;
        return this;
    }

    @Generated
    public MaskingRule useLowerCase(boolean useLowerCase) {
        this.useLowerCase = useLowerCase;
        return this;
    }

    @Generated
    public MaskingRule useBanchiGenerate(boolean useBanchiGenerate) {
        this.useBanchiGenerate = useBanchiGenerate;
        return this;
    }

    @Generated
    public void setAddrFormat(String addrFormat) {
        this.addrFormat = addrFormat;
    }

    @Generated
    public void setMaxSjisByteCounts(int[] maxSjisByteCounts) {
        this.maxSjisByteCounts = maxSjisByteCounts;
    }

    @Generated
    public void setShiftOverflowStrings(boolean[] shiftOverflowStrings) {
        this.shiftOverflowStrings = shiftOverflowStrings;
    }

    @Generated
    public void setFullNameFormat(String fullNameFormat) {
        this.fullNameFormat = fullNameFormat;
    }

    @Generated
    public void setDeterministicReplace(boolean isDeterministicReplace) {
        this.isDeterministicReplace = isDeterministicReplace;
    }

    @Generated
    public void setUniqueValue(boolean isUniqueValue) {
        this.isUniqueValue = isUniqueValue;
    }

    @Generated
    public void setUniqueId(String uniqueId) {
        this.uniqueId = uniqueId;
    }

    @Generated
    public void setToClassName(String toClassName) {
        this.toClassName = toClassName;
    }

    @Generated
    public void setToClassNames(List<String> toClassNames) {
        this.toClassNames = toClassNames;
    }

    @Generated
    public void setDateTimeFormat(String dateTimeFormat) {
        this.dateTimeFormat = dateTimeFormat;
    }

    @Generated
    public void setFixedValue(String fixedValue) {
        this.fixedValue = fixedValue;
    }

    @Generated
    public void setKeepWideSpaceTrim(boolean keepWideSpaceTrim) {
        this.keepWideSpaceTrim = keepWideSpaceTrim;
    }

    @Generated
    public MaskingRule useLTrim(boolean useLTrim) {
        this.useLTrim = useLTrim;
        return this;
    }

    @Generated
    public MaskingRule useRTrim(boolean useRTrim) {
        this.useRTrim = useRTrim;
        return this;
    }

    @Generated
    public void setSeparator(String separator) {
        this.separator = separator;
    }

    @Generated
    public void setBeginIndex(int beginIndex) {
        this.beginIndex = beginIndex;
    }

    @Generated
    public void setEndIndex(int endIndex) {
        this.endIndex = endIndex;
    }

    @Generated
    public void setTextReplaceRegex(String textReplaceRegex) {
        this.textReplaceRegex = textReplaceRegex;
    }

    @Generated
    public void setTextReplacement(String textReplacement) {
        this.textReplacement = textReplacement;
    }

    @Generated
    public void setBeforeTrim(boolean beforeTrim) {
        this.beforeTrim = beforeTrim;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MaskingRule)) {
            return false;
        }
        MaskingRule other = (MaskingRule)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getUnmaksedLengthLeft() != other.getUnmaksedLengthLeft()) {
            return false;
        }
        if (this.getUnmaksedLengthRight() != other.getUnmaksedLengthRight()) {
            return false;
        }
        if (this.useOddCharMask() != other.useOddCharMask()) {
            return false;
        }
        if (this.useEvenCharMask() != other.useEvenCharMask()) {
            return false;
        }
        if (this.useAfterTextReplace() != other.useAfterTextReplace()) {
            return false;
        }
        if (this.useAfterRepOddCharMask() != other.useAfterRepOddCharMask()) {
            return false;
        }
        if (this.useAfterRepEvenCharMask() != other.useAfterRepEvenCharMask()) {
            return false;
        }
        if (this.useWhiteSpaceMask() != other.useWhiteSpaceMask()) {
            return false;
        }
        if (this.isNullReplace() != other.isNullReplace()) {
            return false;
        }
        if (this.isInvalidDateReplace() != other.isInvalidDateReplace()) {
            return false;
        }
        if (this.getMinSjisByteCount() != other.getMinSjisByteCount()) {
            return false;
        }
        if (this.getMaxSjisByteCount() != other.getMaxSjisByteCount()) {
            return false;
        }
        if (this.usePostCodeFormat() != other.usePostCodeFormat()) {
            return false;
        }
        if (this.useHalfKana() != other.useHalfKana()) {
            return false;
        }
        if (this.useUpperCaseKana() != other.useUpperCaseKana()) {
            return false;
        }
        if (this.useWideKana() != other.useWideKana()) {
            return false;
        }
        if (this.useHiragana() != other.useHiragana()) {
            return false;
        }
        if (this.useUpperCase() != other.useUpperCase()) {
            return false;
        }
        if (this.useLowerCase() != other.useLowerCase()) {
            return false;
        }
        if (this.useBanchiGenerate() != other.useBanchiGenerate()) {
            return false;
        }
        if (this.isDeterministicReplace() != other.isDeterministicReplace()) {
            return false;
        }
        if (this.isUniqueValue() != other.isUniqueValue()) {
            return false;
        }
        if (this.isKeepWideSpaceTrim() != other.isKeepWideSpaceTrim()) {
            return false;
        }
        if (this.useLTrim() != other.useLTrim()) {
            return false;
        }
        if (this.useRTrim() != other.useRTrim()) {
            return false;
        }
        if (this.getBeginIndex() != other.getBeginIndex()) {
            return false;
        }
        if (this.getEndIndex() != other.getEndIndex()) {
            return false;
        }
        if (this.isBeforeTrim() != other.isBeforeTrim()) {
            return false;
        }
        Pattern this$unmaksedCharPattern = this.getUnmaksedCharPattern();
        Pattern other$unmaksedCharPattern = other.getUnmaksedCharPattern();
        if (this$unmaksedCharPattern == null ? other$unmaksedCharPattern != null : !this$unmaksedCharPattern.equals(other$unmaksedCharPattern)) {
            return false;
        }
        Pattern this$ignoreValuePattern = this.getIgnoreValuePattern();
        Pattern other$ignoreValuePattern = other.getIgnoreValuePattern();
        if (this$ignoreValuePattern == null ? other$ignoreValuePattern != null : !this$ignoreValuePattern.equals(other$ignoreValuePattern)) {
            return false;
        }
        String this$replacementHalfChar = this.getReplacementHalfChar();
        String other$replacementHalfChar = other.getReplacementHalfChar();
        if (this$replacementHalfChar == null ? other$replacementHalfChar != null : !this$replacementHalfChar.equals(other$replacementHalfChar)) {
            return false;
        }
        String this$replacementWideChar = this.getReplacementWideChar();
        String other$replacementWideChar = other.getReplacementWideChar();
        if (this$replacementWideChar == null ? other$replacementWideChar != null : !this$replacementWideChar.equals(other$replacementWideChar)) {
            return false;
        }
        String this$replacementHalfNum = this.getReplacementHalfNum();
        String other$replacementHalfNum = other.getReplacementHalfNum();
        if (this$replacementHalfNum == null ? other$replacementHalfNum != null : !this$replacementHalfNum.equals(other$replacementHalfNum)) {
            return false;
        }
        String this$replacementWideNum = this.getReplacementWideNum();
        String other$replacementWideNum = other.getReplacementWideNum();
        if (this$replacementWideNum == null ? other$replacementWideNum != null : !this$replacementWideNum.equals(other$replacementWideNum)) {
            return false;
        }
        MaskingUtil.CharType this$randomGenCharType = this.getRandomGenCharType();
        MaskingUtil.CharType other$randomGenCharType = other.getRandomGenCharType();
        if (this$randomGenCharType == null ? other$randomGenCharType != null : !((Object)((Object)this$randomGenCharType)).equals((Object)other$randomGenCharType)) {
            return false;
        }
        Pattern this$randomNoGenCharPattern = this.getRandomNoGenCharPattern();
        Pattern other$randomNoGenCharPattern = other.getRandomNoGenCharPattern();
        if (this$randomNoGenCharPattern == null ? other$randomNoGenCharPattern != null : !this$randomNoGenCharPattern.equals(other$randomNoGenCharPattern)) {
            return false;
        }
        String this$minValue = this.getMinValue();
        String other$minValue = other.getMinValue();
        if (this$minValue == null ? other$minValue != null : !this$minValue.equals(other$minValue)) {
            return false;
        }
        String this$maxValue = this.getMaxValue();
        String other$maxValue = other.getMaxValue();
        if (this$maxValue == null ? other$maxValue != null : !this$maxValue.equals(other$maxValue)) {
            return false;
        }
        BigDecimal this$minDecimalValue = this.getMinDecimalValue();
        BigDecimal other$minDecimalValue = other.getMinDecimalValue();
        if (this$minDecimalValue == null ? other$minDecimalValue != null : !((Object)this$minDecimalValue).equals(other$minDecimalValue)) {
            return false;
        }
        BigDecimal this$maxDecimalValue = this.getMaxDecimalValue();
        BigDecimal other$maxDecimalValue = other.getMaxDecimalValue();
        if (this$maxDecimalValue == null ? other$maxDecimalValue != null : !((Object)this$maxDecimalValue).equals(other$maxDecimalValue)) {
            return false;
        }
        String this$prefix = this.getPrefix();
        String other$prefix = other.getPrefix();
        if (this$prefix == null ? other$prefix != null : !this$prefix.equals(other$prefix)) {
            return false;
        }
        String this$suffix = this.getSuffix();
        String other$suffix = other.getSuffix();
        if (this$suffix == null ? other$suffix != null : !this$suffix.equals(other$suffix)) {
            return false;
        }
        String this$domainReplacement = this.getDomainReplacement();
        String other$domainReplacement = other.getDomainReplacement();
        if (this$domainReplacement == null ? other$domainReplacement != null : !this$domainReplacement.equals(other$domainReplacement)) {
            return false;
        }
        LocalDateTime this$minDate = this.getMinDate();
        LocalDateTime other$minDate = other.getMinDate();
        if (this$minDate == null ? other$minDate != null : !((Object)this$minDate).equals(other$minDate)) {
            return false;
        }
        LocalDateTime this$maxDate = this.getMaxDate();
        LocalDateTime other$maxDate = other.getMaxDate();
        if (this$maxDate == null ? other$maxDate != null : !((Object)this$maxDate).equals(other$maxDate)) {
            return false;
        }
        String this$termFrom = this.getTermFrom();
        String other$termFrom = other.getTermFrom();
        if (this$termFrom == null ? other$termFrom != null : !this$termFrom.equals(other$termFrom)) {
            return false;
        }
        String this$termTo = this.getTermTo();
        String other$termTo = other.getTermTo();
        if (this$termTo == null ? other$termTo != null : !this$termTo.equals(other$termTo)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getPickupList(), other.getPickupList())) {
            return false;
        }
        if (!Arrays.equals(this.getPickupWeights(), other.getPickupWeights())) {
            return false;
        }
        String this$selectListTableName = this.getSelectListTableName();
        String other$selectListTableName = other.getSelectListTableName();
        if (this$selectListTableName == null ? other$selectListTableName != null : !this$selectListTableName.equals(other$selectListTableName)) {
            return false;
        }
        String this$selectListColName = this.getSelectListColName();
        String other$selectListColName = other.getSelectListColName();
        if (this$selectListColName == null ? other$selectListColName != null : !this$selectListColName.equals(other$selectListColName)) {
            return false;
        }
        String this$selectListSeqNoColName = this.getSelectListSeqNoColName();
        String other$selectListSeqNoColName = other.getSelectListSeqNoColName();
        if (this$selectListSeqNoColName == null ? other$selectListSeqNoColName != null : !this$selectListSeqNoColName.equals(other$selectListSeqNoColName)) {
            return false;
        }
        String this$addrFormat = this.getAddrFormat();
        String other$addrFormat = other.getAddrFormat();
        if (this$addrFormat == null ? other$addrFormat != null : !this$addrFormat.equals(other$addrFormat)) {
            return false;
        }
        if (!Arrays.equals(this.getMaxSjisByteCounts(), other.getMaxSjisByteCounts())) {
            return false;
        }
        if (!Arrays.equals(this.getShiftOverflowStrings(), other.getShiftOverflowStrings())) {
            return false;
        }
        String this$fullNameFormat = this.getFullNameFormat();
        String other$fullNameFormat = other.getFullNameFormat();
        if (this$fullNameFormat == null ? other$fullNameFormat != null : !this$fullNameFormat.equals(other$fullNameFormat)) {
            return false;
        }
        String this$uniqueId = this.getUniqueId();
        String other$uniqueId = other.getUniqueId();
        if (this$uniqueId == null ? other$uniqueId != null : !this$uniqueId.equals(other$uniqueId)) {
            return false;
        }
        String this$toClassName = this.getToClassName();
        String other$toClassName = other.getToClassName();
        if (this$toClassName == null ? other$toClassName != null : !this$toClassName.equals(other$toClassName)) {
            return false;
        }
        List<String> this$toClassNames = this.getToClassNames();
        List<String> other$toClassNames = other.getToClassNames();
        if (this$toClassNames == null ? other$toClassNames != null : !((Object)this$toClassNames).equals(other$toClassNames)) {
            return false;
        }
        String this$dateTimeFormat = this.getDateTimeFormat();
        String other$dateTimeFormat = other.getDateTimeFormat();
        if (this$dateTimeFormat == null ? other$dateTimeFormat != null : !this$dateTimeFormat.equals(other$dateTimeFormat)) {
            return false;
        }
        String this$fixedValue = this.getFixedValue();
        String other$fixedValue = other.getFixedValue();
        if (this$fixedValue == null ? other$fixedValue != null : !this$fixedValue.equals(other$fixedValue)) {
            return false;
        }
        String this$separator = this.getSeparator();
        String other$separator = other.getSeparator();
        if (this$separator == null ? other$separator != null : !this$separator.equals(other$separator)) {
            return false;
        }
        String this$textReplaceRegex = this.getTextReplaceRegex();
        String other$textReplaceRegex = other.getTextReplaceRegex();
        if (this$textReplaceRegex == null ? other$textReplaceRegex != null : !this$textReplaceRegex.equals(other$textReplaceRegex)) {
            return false;
        }
        String this$textReplacement = this.getTextReplacement();
        String other$textReplacement = other.getTextReplacement();
        return !(this$textReplacement == null ? other$textReplacement != null : !this$textReplacement.equals(other$textReplacement));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MaskingRule;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getUnmaksedLengthLeft();
        result = result * 59 + this.getUnmaksedLengthRight();
        result = result * 59 + (this.useOddCharMask() ? 79 : 97);
        result = result * 59 + (this.useEvenCharMask() ? 79 : 97);
        result = result * 59 + (this.useAfterTextReplace() ? 79 : 97);
        result = result * 59 + (this.useAfterRepOddCharMask() ? 79 : 97);
        result = result * 59 + (this.useAfterRepEvenCharMask() ? 79 : 97);
        result = result * 59 + (this.useWhiteSpaceMask() ? 79 : 97);
        result = result * 59 + (this.isNullReplace() ? 79 : 97);
        result = result * 59 + (this.isInvalidDateReplace() ? 79 : 97);
        result = result * 59 + this.getMinSjisByteCount();
        result = result * 59 + this.getMaxSjisByteCount();
        result = result * 59 + (this.usePostCodeFormat() ? 79 : 97);
        result = result * 59 + (this.useHalfKana() ? 79 : 97);
        result = result * 59 + (this.useUpperCaseKana() ? 79 : 97);
        result = result * 59 + (this.useWideKana() ? 79 : 97);
        result = result * 59 + (this.useHiragana() ? 79 : 97);
        result = result * 59 + (this.useUpperCase() ? 79 : 97);
        result = result * 59 + (this.useLowerCase() ? 79 : 97);
        result = result * 59 + (this.useBanchiGenerate() ? 79 : 97);
        result = result * 59 + (this.isDeterministicReplace() ? 79 : 97);
        result = result * 59 + (this.isUniqueValue() ? 79 : 97);
        result = result * 59 + (this.isKeepWideSpaceTrim() ? 79 : 97);
        result = result * 59 + (this.useLTrim() ? 79 : 97);
        result = result * 59 + (this.useRTrim() ? 79 : 97);
        result = result * 59 + this.getBeginIndex();
        result = result * 59 + this.getEndIndex();
        result = result * 59 + (this.isBeforeTrim() ? 79 : 97);
        Pattern $unmaksedCharPattern = this.getUnmaksedCharPattern();
        result = result * 59 + ($unmaksedCharPattern == null ? 43 : $unmaksedCharPattern.hashCode());
        Pattern $ignoreValuePattern = this.getIgnoreValuePattern();
        result = result * 59 + ($ignoreValuePattern == null ? 43 : $ignoreValuePattern.hashCode());
        String $replacementHalfChar = this.getReplacementHalfChar();
        result = result * 59 + ($replacementHalfChar == null ? 43 : $replacementHalfChar.hashCode());
        String $replacementWideChar = this.getReplacementWideChar();
        result = result * 59 + ($replacementWideChar == null ? 43 : $replacementWideChar.hashCode());
        String $replacementHalfNum = this.getReplacementHalfNum();
        result = result * 59 + ($replacementHalfNum == null ? 43 : $replacementHalfNum.hashCode());
        String $replacementWideNum = this.getReplacementWideNum();
        result = result * 59 + ($replacementWideNum == null ? 43 : $replacementWideNum.hashCode());
        MaskingUtil.CharType $randomGenCharType = this.getRandomGenCharType();
        result = result * 59 + ($randomGenCharType == null ? 43 : ((Object)((Object)$randomGenCharType)).hashCode());
        Pattern $randomNoGenCharPattern = this.getRandomNoGenCharPattern();
        result = result * 59 + ($randomNoGenCharPattern == null ? 43 : $randomNoGenCharPattern.hashCode());
        String $minValue = this.getMinValue();
        result = result * 59 + ($minValue == null ? 43 : $minValue.hashCode());
        String $maxValue = this.getMaxValue();
        result = result * 59 + ($maxValue == null ? 43 : $maxValue.hashCode());
        BigDecimal $minDecimalValue = this.getMinDecimalValue();
        result = result * 59 + ($minDecimalValue == null ? 43 : ((Object)$minDecimalValue).hashCode());
        BigDecimal $maxDecimalValue = this.getMaxDecimalValue();
        result = result * 59 + ($maxDecimalValue == null ? 43 : ((Object)$maxDecimalValue).hashCode());
        String $prefix = this.getPrefix();
        result = result * 59 + ($prefix == null ? 43 : $prefix.hashCode());
        String $suffix = this.getSuffix();
        result = result * 59 + ($suffix == null ? 43 : $suffix.hashCode());
        String $domainReplacement = this.getDomainReplacement();
        result = result * 59 + ($domainReplacement == null ? 43 : $domainReplacement.hashCode());
        LocalDateTime $minDate = this.getMinDate();
        result = result * 59 + ($minDate == null ? 43 : ((Object)$minDate).hashCode());
        LocalDateTime $maxDate = this.getMaxDate();
        result = result * 59 + ($maxDate == null ? 43 : ((Object)$maxDate).hashCode());
        String $termFrom = this.getTermFrom();
        result = result * 59 + ($termFrom == null ? 43 : $termFrom.hashCode());
        String $termTo = this.getTermTo();
        result = result * 59 + ($termTo == null ? 43 : $termTo.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getPickupList());
        result = result * 59 + Arrays.hashCode(this.getPickupWeights());
        String $selectListTableName = this.getSelectListTableName();
        result = result * 59 + ($selectListTableName == null ? 43 : $selectListTableName.hashCode());
        String $selectListColName = this.getSelectListColName();
        result = result * 59 + ($selectListColName == null ? 43 : $selectListColName.hashCode());
        String $selectListSeqNoColName = this.getSelectListSeqNoColName();
        result = result * 59 + ($selectListSeqNoColName == null ? 43 : $selectListSeqNoColName.hashCode());
        String $addrFormat = this.getAddrFormat();
        result = result * 59 + ($addrFormat == null ? 43 : $addrFormat.hashCode());
        result = result * 59 + Arrays.hashCode(this.getMaxSjisByteCounts());
        result = result * 59 + Arrays.hashCode(this.getShiftOverflowStrings());
        String $fullNameFormat = this.getFullNameFormat();
        result = result * 59 + ($fullNameFormat == null ? 43 : $fullNameFormat.hashCode());
        String $uniqueId = this.getUniqueId();
        result = result * 59 + ($uniqueId == null ? 43 : $uniqueId.hashCode());
        String $toClassName = this.getToClassName();
        result = result * 59 + ($toClassName == null ? 43 : $toClassName.hashCode());
        List<String> $toClassNames = this.getToClassNames();
        result = result * 59 + ($toClassNames == null ? 43 : ((Object)$toClassNames).hashCode());
        String $dateTimeFormat = this.getDateTimeFormat();
        result = result * 59 + ($dateTimeFormat == null ? 43 : $dateTimeFormat.hashCode());
        String $fixedValue = this.getFixedValue();
        result = result * 59 + ($fixedValue == null ? 43 : $fixedValue.hashCode());
        String $separator = this.getSeparator();
        result = result * 59 + ($separator == null ? 43 : $separator.hashCode());
        String $textReplaceRegex = this.getTextReplaceRegex();
        result = result * 59 + ($textReplaceRegex == null ? 43 : $textReplaceRegex.hashCode());
        String $textReplacement = this.getTextReplacement();
        result = result * 59 + ($textReplacement == null ? 43 : $textReplacement.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "MaskingRule(unmaksedLengthLeft=" + this.getUnmaksedLengthLeft() + ", unmaksedLengthRight=" + this.getUnmaksedLengthRight() + ", unmaksedCharPattern=" + this.getUnmaksedCharPattern() + ", ignoreValuePattern=" + this.getIgnoreValuePattern() + ", useOddCharMask=" + this.useOddCharMask() + ", useEvenCharMask=" + this.useEvenCharMask() + ", useAfterTextReplace=" + this.useAfterTextReplace() + ", useAfterRepOddCharMask=" + this.useAfterRepOddCharMask() + ", useAfterRepEvenCharMask=" + this.useAfterRepEvenCharMask() + ", useWhiteSpaceMask=" + this.useWhiteSpaceMask() + ", replacementHalfChar=" + this.getReplacementHalfChar() + ", replacementWideChar=" + this.getReplacementWideChar() + ", replacementHalfNum=" + this.getReplacementHalfNum() + ", replacementWideNum=" + this.getReplacementWideNum() + ", nullReplace=" + this.isNullReplace() + ", invalidDateReplace=" + this.isInvalidDateReplace() + ", randomGenCharType=" + this.getRandomGenCharType() + ", randomNoGenCharPattern=" + this.getRandomNoGenCharPattern() + ", minValue=" + this.getMinValue() + ", maxValue=" + this.getMaxValue() + ", minDecimalValue=" + this.getMinDecimalValue() + ", maxDecimalValue=" + this.getMaxDecimalValue() + ", prefix=" + this.getPrefix() + ", suffix=" + this.getSuffix() + ", minSjisByteCount=" + this.getMinSjisByteCount() + ", maxSjisByteCount=" + this.getMaxSjisByteCount() + ", domainReplacement=" + this.getDomainReplacement() + ", minDate=" + this.getMinDate() + ", maxDate=" + this.getMaxDate() + ", termFrom=" + this.getTermFrom() + ", termTo=" + this.getTermTo() + ", pickupList=" + Arrays.deepToString(this.getPickupList()) + ", pickupWeights=" + Arrays.toString(this.getPickupWeights()) + ", selectListTableName=" + this.getSelectListTableName() + ", selectListColName=" + this.getSelectListColName() + ", selectListSeqNoColName=" + this.getSelectListSeqNoColName() + ", usePostCodeFormat=" + this.usePostCodeFormat() + ", useHalfKana=" + this.useHalfKana() + ", useUpperCaseKana=" + this.useUpperCaseKana() + ", useWideKana=" + this.useWideKana() + ", useHiragana=" + this.useHiragana() + ", useUpperCase=" + this.useUpperCase() + ", useLowerCase=" + this.useLowerCase() + ", useBanchiGenerate=" + this.useBanchiGenerate() + ", addrFormat=" + this.getAddrFormat() + ", maxSjisByteCounts=" + Arrays.toString(this.getMaxSjisByteCounts()) + ", shiftOverflowStrings=" + Arrays.toString(this.getShiftOverflowStrings()) + ", fullNameFormat=" + this.getFullNameFormat() + ", isDeterministicReplace=" + this.isDeterministicReplace() + ", isUniqueValue=" + this.isUniqueValue() + ", uniqueId=" + this.getUniqueId() + ", toClassName=" + this.getToClassName() + ", toClassNames=" + this.getToClassNames() + ", dateTimeFormat=" + this.getDateTimeFormat() + ", fixedValue=" + this.getFixedValue() + ", keepWideSpaceTrim=" + this.isKeepWideSpaceTrim() + ", useLTrim=" + this.useLTrim() + ", useRTrim=" + this.useRTrim() + ", separator=" + this.getSeparator() + ", beginIndex=" + this.getBeginIndex() + ", endIndex=" + this.getEndIndex() + ", textReplaceRegex=" + this.getTextReplaceRegex() + ", textReplacement=" + this.getTextReplacement() + ", beforeTrim=" + this.isBeforeTrim() + ")";
    }
}

