/*
 * Decompiled with CFR 0.152.
 */
package net.utsuro.mask;

import java.util.regex.Pattern;
import net.utsuro.mask.DataMask;
import net.utsuro.mask.MaskingRule;
import net.utsuro.mask.MaskingUtil;

public class MaskedTextReplacer
implements DataMask {
    @Override
    public Object execute(Object src, MaskingRule rule) throws Exception {
        if (rule == null || src == null) {
            return src;
        }
        String tarStr = src instanceof String ? (String)src : src.toString();
        return MaskedTextReplacer.replace(tarStr, rule);
    }

    public static String replace(String src, MaskingRule rule) {
        StringBuilder sb = new StringBuilder();
        if (rule == null || src == null) {
            return src;
        }
        if (src.isEmpty()) {
            return src;
        }
        if (rule.getIgnoreValuePattern() != null && rule.getIgnoreValuePattern().matcher(src).find()) {
            return src;
        }
        String[] c = src.split("");
        int len = c.length;
        int start = rule.getUnmaksedLengthLeft();
        if (start < 0) {
            start = len + start;
        }
        int end = len - rule.getUnmaksedLengthRight() - 1;
        Pattern unMaskPtn = rule.getUnmaksedCharPattern();
        Pattern spaceMaskPtn = rule.useWhiteSpaceMask() ? null : Pattern.compile("[ \u3000\u3001\u3002\uff64\uff61\r\n\t]");
        for (int i = 0; i < len; ++i) {
            if (!(i < start || i > end || rule.useOddCharMask() && i % 2 != 0 || rule.useEvenCharMask() && i % 2 != 1)) {
                if (!(unMaskPtn != null && unMaskPtn.matcher(c[i]).find() || spaceMaskPtn != null && spaceMaskPtn.matcher(c[i]).find())) {
                    if (MaskingUtil.isWideChar(c[i])) {
                        if (rule.useReplacementWideNum() && c[i].matches("[\uff10-\uff19]")) {
                            sb.append(rule.getReplacementWideNum());
                            continue;
                        }
                        sb.append(rule.useReplacementWideChar() ? rule.getReplacementWideChar() : c[i]);
                        continue;
                    }
                    if (rule.useReplacementHalfNum() && c[i].matches("[0-9]")) {
                        sb.append(rule.getReplacementHalfNum());
                        continue;
                    }
                    sb.append(rule.useReplacementHalfChar() ? rule.getReplacementHalfChar() : c[i]);
                    continue;
                }
                sb.append(c[i]);
                continue;
            }
            sb.append(c[i]);
        }
        return sb.toString();
    }
}

