/*
 * Decompiled with CFR 0.152.
 */
package net.utsuro.mask;

import java.time.LocalDate;
import java.time.LocalDateTime;
import net.utsuro.mask.DataMask;
import net.utsuro.mask.MaskingRule;
import net.utsuro.mask.TypeConverter;

public class FixedValueConverter
implements DataMask {
    @Override
    public Object execute(Object src, MaskingRule rule) throws Exception {
        return FixedValueConverter.convert(src, rule);
    }

    public static Object convert(Object src, MaskingRule rule) throws Exception {
        if (rule == null || !rule.isNullReplace() && src == null) {
            return src;
        }
        if (rule.getToClassName() == null || rule.getToClassName().isEmpty()) {
            throw new IllegalArgumentException("\u7f6e\u63db\u5148\u578b\u540d\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
        }
        if (src != null && rule.getIgnoreValuePattern() != null && rule.getIgnoreValuePattern().matcher(src.toString()).find()) {
            return src;
        }
        String val = rule.getFixedValue();
        if ("%sysdate".equals(val)) {
            val = LocalDate.now().toString();
        } else if ("%systimestamp".equals(val)) {
            val = LocalDateTime.now().toString();
        }
        return TypeConverter.convert(val, rule);
    }
}

