/*
 * Decompiled with CFR 0.152.
 */
package net.utsuro.mask;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import net.utsuro.mask.MaskingRule;

public interface DataMask {
    default public boolean useDatabase(MaskingRule rule) {
        return false;
    }

    default public Connection getConnection() {
        return null;
    }

    default public void setConnection(Connection conn) {
    }

    public Object execute(Object var1, MaskingRule var2) throws Exception;

    default public Object getRegisteredUniqueVal(String id, String val) throws SQLException {
        String ret = null;
        Connection conn = this.getConnection();
        if (conn != null && !conn.isClosed() && val != null) {
            StringBuilder sql = new StringBuilder();
            sql.append("SELECT").append(" output_val").append(" FROM sys_unique_list").append(" WHERE id = ?").append(" AND input_val = ?");
            try (PreparedStatement stmt = conn.prepareStatement(sql.toString());){
                stmt.setString(1, id);
                stmt.setString(2, val);
                try (ResultSet rs = stmt.executeQuery();){
                    if (rs.next()) {
                        ret = rs.getString("output_val");
                    }
                }
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public boolean isExistsInUniqueList(String id, String val) throws SQLException {
        boolean ret = false;
        Connection conn = this.getConnection();
        if (conn != null && !conn.isClosed() && val != null) {
            DataMask dataMask = this;
            synchronized (dataMask) {
                StringBuilder sql = new StringBuilder();
                sql.append("SELECT").append(" COUNT(*) AS cnt").append(" FROM sys_unique_list").append(" WHERE id = ?").append(" AND output_val = ?");
                try (PreparedStatement stmt = conn.prepareStatement(sql.toString());){
                    stmt.setString(1, id);
                    stmt.setString(2, val);
                    try (ResultSet rs = stmt.executeQuery();){
                        if (rs.next() && rs.getLong("cnt") > 0L) {
                            ret = true;
                        }
                    }
                }
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public boolean addUniqueList(String id, String inputVal, String outputVal) throws SQLException {
        boolean ret = true;
        Connection conn = this.getConnection();
        if (conn != null && !conn.isClosed() && inputVal != null && outputVal != null) {
            DataMask dataMask = this;
            synchronized (dataMask) {
                StringBuilder sql = new StringBuilder();
                sql.append("INSERT INTO sys_unique_list").append(" (id, input_val, output_val)").append(" VALUES").append(" (?, ?, ?)");
                try (PreparedStatement stmt = conn.prepareStatement(sql.toString());){
                    stmt.setString(1, id);
                    stmt.setString(2, inputVal);
                    stmt.setString(3, outputVal);
                    stmt.execute();
                }
                catch (SQLException e) {
                    ret = false;
                }
            }
        }
        return ret;
    }
}

