/*
 * Decompiled with CFR 0.152.
 */
package net.utsuro.exp;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;

public class DynamicExpression {
    private ExpNode root = new ExpNode();

    public void parse(String exp) {
        this.root = new ExpNode();
        if (exp == null) {
            return;
        }
        String line = exp.trim();
        if (line.isEmpty()) {
            return;
        }
        Pattern p = Pattern.compile("[ ]+|(?![\\!<>])=[=]*|\\!=|[\\(\\)]|\\|\\||&&|[<>]=|<>|[<>]");
        ArrayList<String> tokens = new ArrayList<String>();
        Matcher m = p.matcher(line);
        int lastPos = 0;
        while (m.find()) {
            String grp = m.group();
            grp = grp.trim();
            String prev = line.substring(lastPos, m.start()).trim();
            if (!prev.isEmpty()) {
                tokens.add(prev);
            }
            if (!grp.isEmpty()) {
                if ("=".equals(grp)) {
                    grp = "==";
                } else if ("<>".equals(grp)) {
                    grp = "!=";
                }
                tokens.add(grp);
            }
            lastPos = m.end();
        }
        if (lastPos < line.length()) {
            tokens.add(line.substring(lastPos));
        }
        ExpNode currentNode = this.root;
        for (String s : tokens) {
            Object obj;
            if ("(".equals(s)) {
                currentNode = currentNode.appendNode();
                continue;
            }
            if (")".equals(s)) {
                currentNode = currentNode.getParent();
                continue;
            }
            if ("&&".equals(s) || "||".equals(s)) {
                currentNode = currentNode.shiftNode(Operator.valueOfText(s));
                continue;
            }
            if (p.matcher(s).find()) {
                currentNode.setOperator(Operator.valueOfText(s));
                continue;
            }
            if (s.startsWith("%")) {
                obj = new ExpParameter(s.substring(1));
            } else if ("'${blank}'".equals(s)) {
                obj = new BlankValue();
            } else if (s.startsWith("'") && s.endsWith("'")) {
                String buff = s.substring(1, s.length() - 1).replaceAll("''", "'");
                obj = buff.replaceAll("\\$\\{sp\\}", " ");
            } else {
                obj = s.matches("[-\\.0-9]+") ? new BigDecimal(s) : ("null".equals(s.toLowerCase()) ? null : s);
            }
            currentNode.appendVar(obj);
        }
    }

    public boolean execute() {
        return this.execute(null);
    }

    public boolean execute(Map<String, Object> params) {
        if (this.root.getOperator() == null) {
            return false;
        }
        return (Boolean)this.root.execute(params);
    }

    @Generated
    public ExpNode getRoot() {
        return this.root;
    }

    @Generated
    public void setRoot(ExpNode root) {
        this.root = root;
    }

    public static class ExpNode {
        private Object data;
        private ExpNode parent;
        private ExpNode dataA;
        private ExpNode dataB;
        private Operator operator;

        public void appendVar(Object val) {
            if (this.dataA != null && this.dataB != null) {
                throw new IllegalStateException("A [\u6f14\u7b97\u5b50] B \u306e\u5f62\u5f0f\u306b\u306a\u3063\u3066\u3044\u307e\u305b\u3093\u3002");
            }
            ExpNode node = new ExpNode();
            node.setParent(this);
            if (!(val instanceof BigDecimal) && val instanceof Number) {
                val = new BigDecimal(val.toString());
            }
            node.setData(val);
            if (this.dataA == null) {
                this.dataA = node;
            } else {
                this.dataB = node;
            }
        }

        public ExpNode appendNode() {
            if (this.dataA != null && this.dataB != null) {
                throw new IllegalStateException("A [\u6f14\u7b97\u5b50] B \u306e\u5f62\u5f0f\u306b\u306a\u3063\u3066\u3044\u307e\u305b\u3093\u3002");
            }
            ExpNode node = new ExpNode();
            node.setParent(this);
            if (this.dataA == null) {
                this.dataA = node;
            } else {
                this.dataB = node;
            }
            return node;
        }

        public ExpNode shiftNode(Operator operator) {
            ExpNode nodeA = new ExpNode();
            nodeA.setParent(this);
            nodeA.setDataA(this.dataA);
            nodeA.setDataB(this.dataB);
            nodeA.setOperator(this.operator);
            ExpNode nodeB = new ExpNode();
            nodeB.setParent(this);
            this.data = null;
            this.dataA = nodeA;
            this.dataB = nodeB;
            this.operator = operator;
            return nodeB;
        }

        public boolean hasChild() {
            return this.dataA != null;
        }

        public Object execute(Map<String, Object> params) {
            if (this.hasChild()) {
                boolean ret = false;
                Object retA = false;
                Object retB = false;
                if (this.dataA != null) {
                    retA = this.dataA.execute(params);
                }
                if (this.dataB != null) {
                    retB = this.dataB.execute(params);
                }
                if (this.operator == null) {
                    return retA;
                }
                switch (this.operator) {
                    case EQ: {
                        if (retA == null) {
                            if (retB instanceof BlankValue) {
                                ret = true;
                                break;
                            }
                            ret = retA == retB;
                            break;
                        }
                        if (retB instanceof BlankValue) {
                            ret = retB.equals(retA);
                            break;
                        }
                        if (retA instanceof BigDecimal && retB instanceof BigDecimal) {
                            ret = ((BigDecimal)retA).compareTo((BigDecimal)retB) == 0;
                            break;
                        }
                        ret = retA.equals(retB);
                        break;
                    }
                    case NE: {
                        if (retA == null) {
                            if (retB instanceof BlankValue) {
                                ret = false;
                                break;
                            }
                            ret = retA != retB;
                            break;
                        }
                        if (retB instanceof BlankValue) {
                            ret = !retB.equals(retA);
                            break;
                        }
                        if (retA instanceof BigDecimal && retB instanceof BigDecimal) {
                            ret = ((BigDecimal)retA).compareTo((BigDecimal)retB) != 0;
                            break;
                        }
                        ret = !retA.equals(retB);
                        break;
                    }
                    case AND: {
                        if (retA == null || retB == null) {
                            ret = false;
                            break;
                        }
                        ret = (Boolean)retA != false && (Boolean)retB != false;
                        break;
                    }
                    case OR: {
                        if (retA == null || retB == null) {
                            ret = false;
                            break;
                        }
                        ret = (Boolean)retA != false || (Boolean)retB != false;
                        break;
                    }
                    case GT: {
                        if (retA == null || retB == null) {
                            ret = false;
                            break;
                        }
                        if (retA instanceof String) {
                            ret = ((String)retA).compareTo(retB.toString()) > 0;
                            break;
                        }
                        ret = ((BigDecimal)retA).compareTo(new BigDecimal(retB.toString())) > 0;
                        break;
                    }
                    case GE: {
                        if (retA == null || retB == null) {
                            ret = false;
                            break;
                        }
                        if (retA instanceof String) {
                            ret = ((String)retA).compareTo(retB.toString()) >= 0;
                            break;
                        }
                        ret = ((BigDecimal)retA).compareTo(new BigDecimal(retB.toString())) >= 0;
                        break;
                    }
                    case LT: {
                        if (retA == null || retB == null) {
                            ret = false;
                            break;
                        }
                        if (retA instanceof String) {
                            ret = ((String)retA).compareTo(retB.toString()) < 0;
                            break;
                        }
                        ret = ((BigDecimal)retA).compareTo(new BigDecimal(retB.toString())) < 0;
                        break;
                    }
                    case LE: {
                        ret = retA == null || retB == null ? Boolean.valueOf(false) : (retA instanceof String ? Boolean.valueOf(((String)retA).compareTo(retB.toString()) <= 0).booleanValue() : Boolean.valueOf(((BigDecimal)retA).compareTo(new BigDecimal(retB.toString())) <= 0).booleanValue());
                    }
                }
                return ret;
            }
            if (params != null && this.data instanceof ExpParameter) {
                Object val = params.get(((ExpParameter)this.data).getName());
                if (val instanceof Number) {
                    val = new BigDecimal(val.toString());
                } else if (val != null && !(val instanceof String)) {
                    val = val.toString();
                }
                return val;
            }
            return this.data;
        }

        @Generated
        public Object getData() {
            return this.data;
        }

        @Generated
        public void setData(Object data) {
            this.data = data;
        }

        @Generated
        public ExpNode getParent() {
            return this.parent;
        }

        @Generated
        public void setParent(ExpNode parent) {
            this.parent = parent;
        }

        @Generated
        public ExpNode getDataA() {
            return this.dataA;
        }

        @Generated
        public void setDataA(ExpNode dataA) {
            this.dataA = dataA;
        }

        @Generated
        public ExpNode getDataB() {
            return this.dataB;
        }

        @Generated
        public void setDataB(ExpNode dataB) {
            this.dataB = dataB;
        }

        @Generated
        public Operator getOperator() {
            return this.operator;
        }

        @Generated
        public void setOperator(Operator operator) {
            this.operator = operator;
        }
    }

    public static class BlankValue {
        public boolean equals(Object tar) {
            if (tar == null || tar instanceof BlankValue) {
                return true;
            }
            if (!(tar instanceof String)) {
                return false;
            }
            return ((String)tar).isEmpty() || ((String)tar).isBlank();
        }
    }

    public static class ExpParameter {
        private String name;

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public void setName(String name) {
            this.name = name;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ExpParameter)) {
                return false;
            }
            ExpParameter other = (ExpParameter)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            return !(this$name == null ? other$name != null : !this$name.equals(other$name));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ExpParameter;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "DynamicExpression.ExpParameter(name=" + this.getName() + ")";
        }

        @Generated
        public ExpParameter(String name) {
            this.name = name;
        }
    }

    public static enum Operator {
        EQ("=="),
        NE("!="),
        GT(">"),
        GE(">="),
        LT("<"),
        LE("<="),
        AND("&&"),
        OR("||");

        private String text;

        private Operator(String text) {
            this.text = text;
        }

        public String getText() {
            return this.text;
        }

        public static Operator valueOfText(String text) {
            Operator[] arr;
            for (Operator ope : arr = Operator.values()) {
                if (!ope.getText().equals(text)) continue;
                return ope;
            }
            return null;
        }
    }
}

