/*
 * Decompiled with CFR 0.152.
 */
package net.utsuro.mask;

import net.utsuro.mask.DataMask;
import net.utsuro.mask.MaskingRule;

public class TextTrim
implements DataMask {
    @Override
    public Object execute(Object src, MaskingRule rule) throws Exception {
        return TextTrim.trim((String)src, rule);
    }

    public static String trim(String src, MaskingRule rule) {
        if (rule == null || src == null) {
            return src;
        }
        String s = src;
        if (rule.isKeepWideSpaceTrim()) {
            if (!rule.useLTrim() && !rule.useRTrim()) {
                s = s.trim();
            } else {
                if (rule.useLTrim()) {
                    s = TextTrim.ltrim(s);
                }
                if (rule.useRTrim()) {
                    s = TextTrim.rtrim(s);
                }
            }
        } else if (!rule.useLTrim() && !rule.useRTrim()) {
            s = s.strip();
        } else {
            if (rule.useLTrim()) {
                s = s.stripLeading();
            }
            if (rule.useRTrim()) {
                s = s.stripTrailing();
            }
        }
        return s;
    }

    private static String ltrim(String s) {
        int i;
        int len = s.length();
        for (i = 0; i < len && s.charAt(i) <= ' '; ++i) {
        }
        return s.substring(i);
    }

    private static String rtrim(String s) {
        int i;
        for (i = s.length() - 1; i >= 0 && s.charAt(i) <= ' '; --i) {
        }
        return s.substring(0, i + 1);
    }
}

