/*
 * Decompiled with CFR 0.152.
 */
package net.utsuro.mask;

import java.sql.Connection;
import java.sql.SQLIntegrityConstraintViolationException;
import java.util.regex.Pattern;
import net.utsuro.mask.DataMask;
import net.utsuro.mask.MaskedTextReplacer;
import net.utsuro.mask.MaskingRule;
import net.utsuro.mask.MaskingUtil;
import net.utsuro.mask.TypeConverter;

public class RandomTextReplacer
implements DataMask {
    private static final int RETRY_MAX = 5;
    private Connection conn;

    @Override
    public boolean useDatabase(MaskingRule rule) {
        return rule.isUniqueValue() || rule.isDeterministicReplace();
    }

    @Override
    public Connection getConnection() {
        return this.conn;
    }

    @Override
    public void setConnection(Connection conn) {
        this.conn = conn;
    }

    @Override
    public Object execute(Object src, MaskingRule rule) throws Exception {
        if (rule == null || src == null) {
            return src;
        }
        String tarStr = src instanceof String ? (String)src : src.toString();
        String ret = null;
        if (rule.isDeterministicReplace()) {
            ret = (String)this.getRegisteredUniqueVal(rule.getUniqueId(), tarStr);
        }
        if (ret == null) {
            boolean isValid = false;
            int retryCount = 0;
            while (!isValid) {
                ret = RandomTextReplacer.replace(tarStr, rule);
                if (rule.isUniqueValue() && this.isExistsInUniqueList(rule.getUniqueId(), ret)) continue;
                isValid = true;
                if (!rule.isUniqueValue() && !rule.isDeterministicReplace()) continue;
                isValid = this.addUniqueList(rule.getUniqueId(), tarStr, ret);
                if (!isValid) {
                    ++retryCount;
                }
                if (retryCount <= 5) continue;
                throw new SQLIntegrityConstraintViolationException(String.format("%d\u56de\u91cd\u8907\u3057\u3066\u30e6\u30cb\u30fc\u30af\u30ea\u30b9\u30c8\u306e\u767b\u9332\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", 5));
            }
        }
        return ret;
    }

    public static String replace(String src, MaskingRule rule) throws Exception {
        StringBuilder sb = new StringBuilder();
        if (rule == null || src == null) {
            return src;
        }
        if (src.isEmpty()) {
            return src;
        }
        if (rule.getIgnoreValuePattern() != null && rule.getIgnoreValuePattern().matcher(src).find()) {
            return src;
        }
        String[] c = src.split("");
        int len = c.length;
        int start = rule.getUnmaksedLengthLeft();
        if (start < 0) {
            start = len + start;
        }
        int end = len - rule.getUnmaksedLengthRight() - 1;
        Pattern unMaskPtn = rule.getUnmaksedCharPattern();
        Pattern spaceMaskPtn = rule.useWhiteSpaceMask() ? null : Pattern.compile("[ \u3000\u3001\u3002\uff64\uff61\r\n\t]");
        MaskingUtil.CharType[] charTypes = new MaskingUtil.CharType[c.length];
        for (int i = 0; i < len; ++i) {
            if (!(i < start || i > end || rule.useOddCharMask() && i % 2 != 0 || rule.useEvenCharMask() && i % 2 != 1)) {
                if (!(unMaskPtn != null && unMaskPtn.matcher(c[i]).find() || spaceMaskPtn != null && spaceMaskPtn.matcher(c[i]).find())) {
                    boolean isWide = MaskingUtil.isWideChar(c[i]);
                    charTypes[i] = rule.useRandomGenCharType() ? rule.getRandomGenCharType() : MaskingUtil.CharType.getTypeByString(c[i]);
                    if (charTypes[i] != MaskingUtil.CharType.UNKNOWN) continue;
                    charTypes[i] = isWide ? MaskingUtil.CharType.WIDE : MaskingUtil.CharType.HALF;
                    continue;
                }
                charTypes[i] = MaskingUtil.CharType.NONE;
                continue;
            }
            charTypes[i] = MaskingUtil.CharType.NONE;
        }
        int byteCount = 0;
        for (int i = 0; i < len; ++i) {
            if (charTypes[i] != MaskingUtil.CharType.NONE) {
                byteCount += charTypes[i].getReqByte();
                if (i != len - 1 && charTypes[i] == charTypes[i + 1]) continue;
                sb.append(MaskingUtil.getRandomString(byteCount, charTypes[i], rule.getRandomNoGenCharPattern()));
                byteCount = 0;
                continue;
            }
            sb.append(c[i]);
            byteCount = 0;
        }
        if (rule.useUpperCaseKana() || rule.useHalfKana() || rule.useWideKana() || rule.useHiragana() || rule.useUpperCase() || rule.useLowerCase()) {
            MaskingRule afterRepRule = new MaskingRule(rule);
            afterRepRule.setToClassName(String.class.getName());
            sb = new StringBuilder().append(TypeConverter.convert(sb.toString(), afterRepRule));
        }
        if (rule.useAfterTextReplace()) {
            MaskingRule afterRepRule = new MaskingRule(rule);
            afterRepRule.useOddCharMask(rule.useAfterRepOddCharMask());
            afterRepRule.useEvenCharMask(rule.useAfterRepEvenCharMask());
            sb = new StringBuilder(MaskedTextReplacer.replace(sb.toString(), afterRepRule));
        }
        return sb.toString();
    }
}

