/*
 * Decompiled with CFR 0.152.
 */
package net.utsuro.mask;

import java.math.BigDecimal;
import java.math.BigInteger;
import net.utsuro.mask.DataMask;
import net.utsuro.mask.MaskingRule;
import net.utsuro.mask.MaskingUtil;

public class RandomNumGenerator
implements DataMask {
    @Override
    public Object execute(Object src, MaskingRule rule) throws Exception {
        BigDecimal num;
        if (rule == null || !rule.isNullReplace() && src == null) {
            return src;
        }
        if (rule.isNullReplace() && src == null) {
            num = BigDecimal.ZERO;
        } else if (src instanceof Long) {
            num = BigDecimal.valueOf((Long)src);
        } else if (src instanceof Integer) {
            num = BigDecimal.valueOf(((Integer)src).intValue());
            num = new BigDecimal((Integer)src);
        } else if (src instanceof Float) {
            num = BigDecimal.valueOf(((Float)src).floatValue());
        } else if (src instanceof Double) {
            num = BigDecimal.valueOf((Double)src);
        } else if (src instanceof BigInteger) {
            num = new BigDecimal((BigInteger)src);
        } else if (src instanceof BigDecimal) {
            num = (BigDecimal)src;
        } else if (src instanceof String && ((String)src).matches("-?\\d+(\\.\\d+)?")) {
            num = new BigDecimal((String)src);
        } else {
            return src;
        }
        return RandomNumGenerator.generate(num, rule);
    }

    public static BigDecimal generate(BigDecimal src, MaskingRule rule) {
        if (rule == null || !rule.isNullReplace() && src == null) {
            return src;
        }
        if (src != null && rule.getIgnoreValuePattern() != null && rule.getIgnoreValuePattern().matcher(src.toString()).find()) {
            return src;
        }
        BigDecimal num = src;
        if (rule.isNullReplace() && src == null) {
            num = BigDecimal.ZERO;
        }
        BigDecimal min = rule.getMinDecimalValue();
        BigDecimal max = rule.getMaxDecimalValue();
        if (min == null) {
            min = BigDecimal.ZERO;
        }
        if (max == null) {
            max = BigDecimal.TEN.pow(num.precision()).subtract(BigDecimal.ONE);
        }
        return MaskingUtil.getRandomNumber(min, max);
    }
}

