/*
 * Decompiled with CFR 0.152.
 */
package net.utsuro.mask;

import java.sql.Connection;
import java.sql.SQLIntegrityConstraintViolationException;
import java.util.concurrent.ThreadLocalRandom;
import net.utsuro.mask.DataMask;
import net.utsuro.mask.MaskingRule;
import net.utsuro.mask.MaskingUtil;

public class RandomMailAddrReplacer
implements DataMask {
    private static final int RETRY_MAX = 5;
    private Connection conn;
    static final String[] TOPSEC_DOMAIN = new String[]{".co.jp", ".com", ".net"};

    @Override
    public boolean useDatabase(MaskingRule rule) {
        return rule.isUniqueValue() || rule.isDeterministicReplace();
    }

    @Override
    public Connection getConnection() {
        return this.conn;
    }

    @Override
    public void setConnection(Connection conn) {
        this.conn = conn;
    }

    @Override
    public Object execute(Object src, MaskingRule rule) throws Exception {
        if (rule == null || src == null) {
            return src;
        }
        if (!(src instanceof String)) {
            return src;
        }
        String tarStr = (String)src;
        String ret = null;
        if (rule.isDeterministicReplace()) {
            ret = (String)this.getRegisteredUniqueVal(rule.getUniqueId(), tarStr);
        }
        if (ret == null) {
            boolean isValid = false;
            int retryCount = 0;
            while (!isValid) {
                ret = RandomMailAddrReplacer.replace(tarStr, rule);
                if (rule.isUniqueValue() && this.isExistsInUniqueList(rule.getUniqueId(), ret)) continue;
                isValid = true;
                if (!rule.isUniqueValue() && !rule.isDeterministicReplace()) continue;
                isValid = this.addUniqueList(rule.getUniqueId(), tarStr, ret);
                if (!isValid) {
                    ++retryCount;
                }
                if (retryCount <= 5) continue;
                throw new SQLIntegrityConstraintViolationException(String.format("%d\u56de\u91cd\u8907\u3057\u3066\u30e6\u30cb\u30fc\u30af\u30ea\u30b9\u30c8\u306e\u767b\u9332\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", 5));
            }
        }
        return ret;
    }

    public static String replace(String src, MaskingRule rule) {
        String domain;
        StringBuilder sb = new StringBuilder();
        if (rule == null || src == null) {
            return src;
        }
        if (src.isEmpty()) {
            return src;
        }
        if (rule.getIgnoreValuePattern() != null && rule.getIgnoreValuePattern().matcher(src).find()) {
            return src;
        }
        String base = src.trim();
        String[] c = base.split("");
        int len = c.length;
        if (rule.getDomainReplacement().length() > 0) {
            domain = (rule.getDomainReplacement().indexOf("@") < 0 ? "@" : "") + rule.getDomainReplacement();
        } else {
            int idx = ThreadLocalRandom.current().nextInt(TOPSEC_DOMAIN.length);
            domain = TOPSEC_DOMAIN[idx];
            int domainLen = len - base.indexOf("@") - domain.length() - 1;
            if (domainLen <= 0) {
                domainLen = 1;
            }
            domain = "@" + MaskingUtil.getRandomString(domainLen, MaskingUtil.CharType.LOWER_ALPHA, rule.getRandomNoGenCharPattern()) + domain;
        }
        if ((len -= domain.length()) <= 0) {
            sb.append(MaskingUtil.getRandomString(1, MaskingUtil.CharType.LOWER_ALPHA, rule.getRandomNoGenCharPattern()));
        } else {
            for (int i = 0; i < len; ++i) {
                sb.append(MaskingUtil.getRandomString(1, MaskingUtil.CharType.LOWER_ALPHA, rule.getRandomNoGenCharPattern()));
            }
        }
        return sb.append(domain).toString();
    }
}

