/*
 * Decompiled with CFR 0.152.
 */
package net.utsuro.mask;

import net.utsuro.mask.DataMask;
import net.utsuro.mask.MaskingRule;
import net.utsuro.mask.MaskingUtil;

public class RandomListPickup
implements DataMask {
    private int[] weights = null;
    private int totalWeight = 0;

    @Override
    public Object execute(Object src, MaskingRule rule) throws Exception {
        int weightsCount;
        if (rule == null || !rule.isNullReplace() && src == null) {
            return src;
        }
        int pickupListCount = rule.getPickupList() == null ? 0 : rule.getPickupList().length;
        int n = weightsCount = rule.getPickupWeights() == null ? 0 : rule.getPickupWeights().length;
        if (pickupListCount == 0) {
            return src;
        }
        if (this.weights == null) {
            this.weights = new int[pickupListCount];
            for (int i = 0; i < pickupListCount; ++i) {
                this.weights[i] = weightsCount == 0 ? 1 : (i < weightsCount ? rule.getPickupWeights()[i] : 0);
                this.totalWeight += this.weights[i];
            }
        }
        int idx = MaskingUtil.getRandomIndex(this.weights, this.totalWeight);
        return rule.getPickupList()[idx];
    }
}

