/*
 * Decompiled with CFR 0.152.
 */
package net.utsuro.mask;

import java.time.DateTimeException;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.utsuro.mask.DataMask;
import net.utsuro.mask.MaskingRule;
import net.utsuro.mask.MaskingUtil;
import net.utsuro.mask.TypeConverter;

public class RandomDateGenerator
implements DataMask {
    @Override
    public Object execute(Object src, MaskingRule rule) throws Exception {
        if (rule == null || !rule.isNullReplace() && src == null) {
            return src;
        }
        LocalDateTime dt = null;
        if (src != null) {
            if (src.getClass() != LocalDateTime.class) {
                MaskingRule tempRule = new MaskingRule(rule);
                tempRule.setToClassName(LocalDateTime.class.getName());
                try {
                    dt = (LocalDateTime)TypeConverter.convert(src, tempRule);
                }
                catch (IllegalArgumentException | DateTimeException e) {
                    if (rule.isInvalidDateReplace()) {
                        dt = LocalDateTime.now().truncatedTo(ChronoUnit.HOURS);
                    }
                    return src;
                }
            } else {
                dt = (LocalDateTime)src;
            }
        }
        return RandomDateGenerator.generate(dt, rule);
    }

    public static LocalDateTime generate(LocalDateTime src, MaskingRule rule) {
        LocalDateTime buff;
        Matcher m;
        if (rule == null || !rule.isNullReplace() && src == null) {
            return src;
        }
        if (src != null && rule.getIgnoreValuePattern() != null && rule.getIgnoreValuePattern().matcher(src.toString()).find()) {
            return src;
        }
        LocalDateTime dt = src;
        if (rule.isNullReplace() && src == null) {
            dt = LocalDateTime.now().truncatedTo(ChronoUnit.HOURS);
        }
        LocalDateTime min = rule.getMinDate();
        LocalDateTime max = rule.getMaxDate();
        Pattern ptn = Pattern.compile("(([-0-9]+)Y)?(([-0-9]+)M)?(([-0-9]+)D)?");
        if (rule.getTermFrom() != null && !rule.getTermFrom().isEmpty() && (m = ptn.matcher(rule.getTermFrom())).find()) {
            buff = dt.plusDays(0L);
            if (m.group(2) != null) {
                buff = buff.plusYears(Integer.parseInt(m.group(2)));
            }
            if (m.group(4) != null) {
                buff = buff.plusMonths(Integer.parseInt(m.group(4)));
            }
            if (m.group(6) != null) {
                buff = buff.plusDays(Integer.parseInt(m.group(6)));
            }
            min = buff;
        }
        if (rule.getTermTo() != null && !rule.getTermTo().isEmpty() && (m = ptn.matcher(rule.getTermTo())).find()) {
            buff = dt.plusDays(0L);
            if (m.group(2) != null) {
                buff = buff.plusYears(Integer.parseInt(m.group(2)));
            }
            if (m.group(4) != null) {
                buff = buff.plusMonths(Integer.parseInt(m.group(4)));
            }
            if (m.group(6) != null) {
                buff = buff.plusDays(Integer.parseInt(m.group(6)));
            }
            max = buff;
        }
        if (min == null) {
            min = LocalDateTime.parse("0000-01-01T00:00:00");
        }
        if (max == null) {
            max = LocalDateTime.parse("9999-12-31T23:59:59");
        }
        return MaskingUtil.getRandomDate(min, max);
    }
}

