/*
 * Decompiled with CFR 0.152.
 */
package net.utsuro.mask;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import net.utsuro.mask.DataMask;
import net.utsuro.mask.MaskingRule;
import net.utsuro.mask.MaskingUtil;

public class RandomDataPickup
implements DataMask {
    private Connection conn;
    private long maxSeq = -1L;

    @Override
    public boolean useDatabase(MaskingRule rule) {
        return true;
    }

    @Override
    public Connection getConnection() {
        return this.conn;
    }

    @Override
    public void setConnection(Connection conn) {
        this.conn = conn;
    }

    @Override
    public Object execute(Object src, MaskingRule rule) throws Exception {
        StringBuilder sql;
        if (rule == null || !rule.isNullReplace() && src == null) {
            return src;
        }
        if (src != null && rule.getIgnoreValuePattern() != null && rule.getIgnoreValuePattern().matcher(src.toString()).find()) {
            return src;
        }
        if (rule.getSelectListTableName() == null || rule.getSelectListTableName().isBlank()) {
            throw new IllegalArgumentException("\u30c7\u30fc\u30bf\u9078\u629e\u30ea\u30b9\u30c8\u306e\u5bfe\u8c61\u30c6\u30fc\u30d6\u30eb\u540d selectListTableName \u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
        }
        if (rule.getSelectListColName() == null || rule.getSelectListColName().isBlank()) {
            throw new IllegalArgumentException("\u30c7\u30fc\u30bf\u9078\u629e\u30ea\u30b9\u30c8\u306e\u5bfe\u8c61\u30ab\u30e9\u30e0\u540d selectListColName \u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
        }
        if (this.maxSeq < 0L) {
            sql = new StringBuilder();
            sql.append("SELECT").append(" MAX(").append(rule.getSelectListSeqNoColName()).append(") AS maxseq").append(" FROM ").append(rule.getSelectListTableName());
            try (PreparedStatement stmt = this.conn.prepareStatement(sql.toString());
                 ResultSet rs = stmt.executeQuery();){
                if (rs.next()) {
                    this.maxSeq = rs.getLong("maxseq");
                }
            }
        }
        if (this.maxSeq < 0L) {
            return null;
        }
        sql = new StringBuilder();
        sql.append("SELECT ").append(rule.getSelectListColName()).append(" FROM ").append(rule.getSelectListTableName()).append(" WHERE ").append(rule.getSelectListSeqNoColName()).append(" = ?");
        Object ret = null;
        try (PreparedStatement stmt = this.conn.prepareStatement(sql.toString());){
            long tarNo = MaskingUtil.getRandomNumber(0L, this.maxSeq);
            stmt.setLong(1, tarNo);
            try (ResultSet rs = stmt.executeQuery();){
                if (rs.next()) {
                    ret = rs.getObject(rule.getSelectListColName());
                }
            }
        }
        return ret;
    }
}

