/*
 * Decompiled with CFR 0.152.
 */
package net.utsuro.mask;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLIntegrityConstraintViolationException;
import java.text.Normalizer;
import java.util.Arrays;
import java.util.regex.Pattern;
import net.utsuro.mask.DataMask;
import net.utsuro.mask.MaskingRule;
import net.utsuro.mask.MaskingUtil;
import net.utsuro.mask.RandomTextReplacer;
import net.utsuro.mask.TextTrim;

public class RandomAddressGenerator
implements DataMask {
    private static final int RETRY_MAX = 5;
    private Connection conn;
    private long maxSeq = -1L;

    @Override
    public boolean useDatabase(MaskingRule rule) {
        return true;
    }

    @Override
    public Connection getConnection() {
        return this.conn;
    }

    @Override
    public void setConnection(Connection conn) {
        this.conn = conn;
    }

    @Override
    public Object execute(Object src, MaskingRule rule) throws Exception {
        String buff;
        if (rule == null || !rule.isNullReplace() && src == null) {
            return src;
        }
        CharSequence[] addr = null;
        if (rule.isNullReplace() && src == null) {
            addr = new String[]{};
        } else if (src instanceof String[] || src instanceof Object[]) {
            addr = (String[])Arrays.copyOf((Object[])src, ((Object[])src).length, String[].class);
            if (rule.isBeforeTrim()) {
                for (int i = 0; i < addr.length; ++i) {
                    if (addr[i] == null) continue;
                    addr[i] = TextTrim.trim((String)addr[i], rule);
                }
            }
        } else {
            return src;
        }
        CharSequence[] ret = null;
        if (rule.isDeterministicReplace() && (buff = (String)this.getRegisteredUniqueVal(rule.getUniqueId(), String.join((CharSequence)"<>", addr))) != null) {
            ret = buff.split("<>", -1);
        }
        if (ret == null) {
            boolean isValid = false;
            int retryCount = 0;
            while (!isValid) {
                ret = this.generate((String[])addr, rule);
                if (rule.isUniqueValue() && this.isExistsInUniqueList(rule.getUniqueId(), String.join((CharSequence)"<>", ret))) continue;
                isValid = true;
                if (ret == null || !rule.isUniqueValue() && !rule.isDeterministicReplace()) continue;
                isValid = this.addUniqueList(rule.getUniqueId(), String.join((CharSequence)"<>", addr), String.join((CharSequence)"<>", ret));
                if (!isValid) {
                    ++retryCount;
                }
                if (retryCount <= 5) continue;
                throw new SQLIntegrityConstraintViolationException(String.format("%d\u56de\u91cd\u8907\u3057\u3066\u30e6\u30cb\u30fc\u30af\u30ea\u30b9\u30c8\u306e\u767b\u9332\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", 5));
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] generate(String[] src, MaskingRule rule) throws Exception {
        int i;
        String addrBuff;
        String[] addr;
        block61: {
            StringBuilder sql;
            if (rule == null || !rule.isNullReplace() && src == null) {
                return src;
            }
            addr = src;
            if (rule.isNullReplace() && src == null) {
                addr = new String[]{};
            }
            if ((addrBuff = rule.getAddrFormat()) == null || addrBuff.isEmpty()) {
                return src;
            }
            RandomAddressGenerator randomAddressGenerator = this;
            synchronized (randomAddressGenerator) {
                if (this.maxSeq < 0L) {
                    sql = new StringBuilder();
                    sql.append("SELECT").append(" MAX(").append(rule.getSelectListSeqNoColName()).append(") AS maxseq").append(" FROM m_postal_code");
                    try (PreparedStatement stmt = this.conn.prepareStatement(sql.toString());
                         ResultSet rs = stmt.executeQuery();){
                        if (rs.next()) {
                            this.maxSeq = rs.getLong("maxseq");
                        }
                    }
                }
            }
            if (this.maxSeq < 0L) {
                return null;
            }
            sql = new StringBuilder();
            sql.append("SELECT * FROM m_postal_code WHERE ").append(rule.getSelectListSeqNoColName()).append(" = ?");
            try (PreparedStatement stmt = this.conn.prepareStatement(sql.toString());){
                long tarNo = MaskingUtil.getRandomNumber(0L, this.maxSeq);
                stmt.setLong(1, tarNo);
                try (ResultSet rs = stmt.executeQuery();){
                    if (rs.next()) {
                        addrBuff = rule.usePostCodeFormat() ? addrBuff.replaceAll("%zip", rs.getString("zip")) : addrBuff.replaceAll("%zip", rs.getString("zip").replaceAll("-", ""));
                        String kana = rs.getString("ken_furi");
                        if (rule.useUpperCaseKana()) {
                            kana = MaskingUtil.toUpperWideKana(kana);
                        }
                        if (rule.useHalfKana()) {
                            kana = MaskingUtil.wideKanaToHalfKana(kana);
                        } else if (!rule.useWideKana()) {
                            kana = MaskingUtil.wideKanaToHiragana(kana);
                        }
                        addrBuff = addrBuff.replaceAll("%prefKana", kana);
                        kana = rs.getString("city_furi");
                        if (rule.useUpperCaseKana()) {
                            kana = MaskingUtil.toUpperWideKana(kana);
                        }
                        if (rule.useHalfKana()) {
                            kana = MaskingUtil.wideKanaToHalfKana(Normalizer.normalize(kana, Normalizer.Form.NFKC));
                        } else if (!rule.useWideKana()) {
                            kana = MaskingUtil.wideKanaToHiragana(kana);
                        }
                        addrBuff = addrBuff.replaceAll("%cityKana", kana);
                        kana = rs.getString("town_furi");
                        if (kana != null && rs.getString("block_furi") != null) {
                            kana = kana.concat(rs.getString("block_furi"));
                        }
                        if (rule.useUpperCaseKana()) {
                            kana = MaskingUtil.toUpperWideKana(kana);
                        }
                        if (rule.useHalfKana()) {
                            kana = MaskingUtil.wideKanaToHalfKana(Normalizer.normalize(kana, Normalizer.Form.NFKC));
                        } else if (!rule.useWideKana()) {
                            kana = MaskingUtil.wideKanaToHiragana(kana);
                        }
                        addrBuff = addrBuff.replaceAll("%townKana", kana);
                        addrBuff = addrBuff.replaceAll("%pref", rs.getString("ken_name"));
                        addrBuff = addrBuff.replaceAll("%city", rs.getString("city_name"));
                        addrBuff = addrBuff.replaceAll("%town", rs.getString("town_name").concat(rs.getString("block_name") == null ? "" : rs.getString("block_name")));
                        addrBuff = addrBuff.replaceAll("%jisKenCode", String.format("%02d", rs.getInt("ken_id")));
                        addrBuff = addrBuff.replaceAll("%jisCityCode", String.format("%05d", rs.getInt("city_id")));
                        addrBuff = addrBuff.replaceAll("%jisCityShortCode", String.format("%05d", rs.getInt("city_id")).substring(2));
                        addrBuff = addrBuff.replaceAll("%addrCode", String.format("%09d", rs.getInt("id")));
                        break block61;
                    }
                    String[] kana = null;
                    return kana;
                }
            }
        }
        String[] ret = addrBuff.split(",", -1);
        String street = "";
        String streetKana = "";
        if (rule.useBanchiGenerate()) {
            int count = MaskingUtil.getRandomIndex(new int[]{2, 7, 10, 5}) + 1;
            CharSequence[] buff = new String[count];
            int[][] maxTable = new int[][]{{5000}, {10, 1000}, {10, 12, 12}, {10, 12, 12, 999}};
            for (int i2 = 0; i2 < buff.length; ++i2) {
                buff[i2] = Integer.toString(MaskingUtil.getRandomNumber(1, maxTable[buff.length - 1][i2]));
                if (i2 != 3 || ((String)buff[i2]).length() != 3) continue;
                buff[i2] = ((String)buff[i2]).replaceAll("([0-9])[3-9]([0-9])", "$10$2");
            }
            streetKana = String.join((CharSequence)"-", buff);
            street = MaskingUtil.halfNumberToWideNumber(streetKana).replaceAll("-", "\uff0d");
        }
        for (i = 0; i < ret.length; ++i) {
            MaskingRule streetRule;
            if (ret[i].indexOf("%streetKana") >= 0) {
                if (!rule.useBanchiGenerate()) {
                    if (i < addr.length) {
                        streetRule = new MaskingRule(rule);
                        streetRule.setUnmaksedChar("[-\uff0d ]");
                        streetRule.setRandomNoGenCharPattern(Pattern.compile("[0\uff10\u300c\u300d]"));
                        ret[i] = RandomTextReplacer.replace(addr[i], streetRule);
                        continue;
                    }
                    ret[i] = "";
                    continue;
                }
                ret[i] = ret[i].replaceAll("%streetKana", streetKana);
                continue;
            }
            if (ret[i].indexOf("%street") < 0) continue;
            if (!rule.useBanchiGenerate()) {
                if (i < addr.length) {
                    streetRule = new MaskingRule(rule);
                    streetRule.setUnmaksedChar("[-\uff0d ]");
                    streetRule.setRandomNoGenCharPattern(Pattern.compile("[0\uff10\u300c\u300d]"));
                    ret[i] = RandomTextReplacer.replace(addr[i], streetRule);
                    continue;
                }
                ret[i] = "";
                continue;
            }
            ret[i] = ret[i].replaceAll("%street", street);
        }
        if (rule.getMaxSjisByteCounts() != null && rule.getMaxSjisByteCounts().length > 0) {
            for (i = 0; i < ret.length; ++i) {
                int byteCount = 0;
                boolean isShiftOverflow = false;
                if (rule.getMaxSjisByteCounts().length > i) {
                    byteCount = rule.getMaxSjisByteCounts()[i];
                }
                if (rule.getShiftOverflowStrings() != null && rule.getShiftOverflowStrings().length > i) {
                    isShiftOverflow = rule.getShiftOverflowStrings()[i];
                }
                if (byteCount <= 0) continue;
                String[] buff = MaskingUtil.splitBySjisBytes(ret[i], byteCount);
                ret[i] = buff[0];
                if (!isShiftOverflow || buff[1] == null || i >= ret.length - 1) continue;
                ret[i + 1] = buff[1].concat(ret[i + 1] != null ? ret[i + 1] : "");
            }
        }
        return ret;
    }
}

