/*
 * Decompiled with CFR 0.152.
 */
package net.uptheinter.interceptify.util;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import net.uptheinter.interceptify.util.JarFileEx;
import net.uptheinter.interceptify.util.Util;

public class JarFiles
implements Iterable<JarFileEx> {
    private final Set<JarFileEx> jarFiles = new HashSet<JarFileEx>();

    @Override
    public Iterator<JarFileEx> iterator() {
        return this.jarFiles.iterator();
    }

    public Stream<JarFileEx> stream() {
        return this.jarFiles.stream();
    }

    public void addFromDirectory(Path path) {
        if (path == null || !Files.isDirectory(path, new LinkOption[0])) {
            return;
        }
        Objects.requireNonNull(Util.walk(path, 1)).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).map(Path::toFile).filter(f -> f.getName().endsWith(".jar")).map(this::newJarFile).filter(Objects::nonNull).forEach(this.jarFiles::add);
    }

    private JarFileEx newJarFile(File file) {
        try {
            return new JarFileEx(file);
        }
        catch (IOException e) {
            Util.DebugError(e);
            return null;
        }
    }
}

