/*
 * Decompiled with CFR 0.152.
 */
package net.uptheinter.interceptify.internal;

import java.lang.reflect.Method;
import java.util.List;
import net.uptheinter.interceptify.internal.ClassMetadata;
import net.uptheinter.interceptify.internal.MethodMetadata;
import net.uptheinter.interceptify.internal.ParameterMetadata;

class ParamsValidator {
    private static final String METHODTYPENAME = Method.class.getTypeName();
    private final MethodMetadata method;
    private final List<ParameterMetadata> params;
    private final ClassMetadata targetedCls;

    public ParamsValidator(MethodMetadata method, ClassMetadata targetedCls) {
        this.method = method;
        this.params = method.getParameterList();
        this.targetedCls = targetedCls;
    }

    private int validateConstructorMethod(ClassMetadata targetedCls, List<?> otherParams) {
        return this.params.size() - 1 != otherParams.size() || !this.params.get(0).getTypeName().equals(targetedCls.getTypeName()) ? -1 : 1;
    }

    private int validateInstanceMethod(ClassMetadata targetedCls, List<?> otherParams) {
        return this.params.size() - 2 != otherParams.size() || !this.params.get(0).getTypeName().equals(targetedCls.getTypeName()) || !this.params.get(1).getTypeName().equals(METHODTYPENAME) ? -1 : 2;
    }

    private int validateWithSuper(List<?> otherParams) {
        return this.params.size() - 1 != otherParams.size() || !this.params.get(0).getTypeName().equals(METHODTYPENAME) ? -1 : 1;
    }

    public boolean isCompatible(MethodMetadata targetedMethod) {
        if (!this.method.isStatic()) {
            return false;
        }
        int argsStart = 0;
        List<ParameterMetadata> otherParams = targetedMethod.getParameterList();
        if (targetedMethod.isConstructor()) {
            argsStart = this.validateConstructorMethod(this.targetedCls, otherParams);
        } else if (targetedMethod.isInstanceMethod()) {
            argsStart = this.validateInstanceMethod(this.targetedCls, otherParams);
        } else if (this.params.size() - 1 == otherParams.size()) {
            argsStart = this.validateWithSuper(otherParams);
        } else if (this.params.size() != otherParams.size()) {
            argsStart = -1;
        }
        if (argsStart == -1) {
            return false;
        }
        for (ParameterMetadata otherParam : otherParams) {
            if (otherParam.equals(this.params.get(argsStart++))) continue;
            return false;
        }
        return true;
    }
}

