/*
 * Decompiled with CFR 0.152.
 */
package net.uptheinter.interceptify.internal;

import java.lang.reflect.Method;
import java.util.stream.Stream;
import net.bytebuddy.asm.MemberAttributeExtension;
import net.bytebuddy.description.annotation.AnnotationDescription;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.implementation.bind.annotation.Argument;
import net.bytebuddy.implementation.bind.annotation.RuntimeType;
import net.bytebuddy.implementation.bind.annotation.SuperMethod;
import net.bytebuddy.implementation.bind.annotation.This;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import net.uptheinter.interceptify.internal.MethodMetadata;
import net.uptheinter.interceptify.internal.ParameterMetadata;
import net.uptheinter.interceptify.util.Boxed;

class ParamsAnnotator {
    private static final String METHODTYPENAME = Method.class.getTypeName();
    private final Boxed<DynamicType.Builder<?>> builderBox;
    private final MethodMetadata method;
    private final MethodMetadata targetMethod;
    private int paramIdx;
    private int argIdx;

    public ParamsAnnotator(Boxed<DynamicType.Builder<?>> builderBox, MethodMetadata method, MethodMetadata targetMethod) {
        this.builderBox = builderBox;
        this.method = method;
        this.targetMethod = targetMethod;
    }

    public void annotate() {
        ((Stream)this.method.getParameters().sequential()).dropWhile(this::isForThisInstance).dropWhile(this::isForOriginalMethodRef).forEach(param -> this.annotateArguments());
    }

    private boolean isForThisInstance(ParameterMetadata param) {
        if (this.paramIdx != 0 || !param.getTypeName().equals(this.targetMethod.getDeclaringType().getTypeName())) {
            return false;
        }
        this.builderBox.run(builder -> builder.visit(new MemberAttributeExtension.ForMethod().annotateParameter(this.paramIdx++, new AnnotationDescription[]{AnnotationDescription.Builder.ofType(RuntimeType.class).build(), AnnotationDescription.Builder.ofType(This.class).build()}).on((ElementMatcher)ElementMatchers.is((MethodDescription.InDefinedShape)this.method.getShape()))));
        return true;
    }

    private boolean isForOriginalMethodRef(ParameterMetadata param) {
        if (this.paramIdx > 1 || !param.getTypeName().equals(METHODTYPENAME)) {
            return false;
        }
        this.builderBox.run(builder -> builder.visit(new MemberAttributeExtension.ForMethod().annotateParameter(this.paramIdx++, new AnnotationDescription[]{AnnotationDescription.Builder.ofType(SuperMethod.class).build()}).on((ElementMatcher)ElementMatchers.is((MethodDescription.InDefinedShape)this.method.getShape()))));
        return true;
    }

    private void annotateArguments() {
        this.builderBox.run(builder -> builder.visit(new MemberAttributeExtension.ForMethod().annotateParameter(this.paramIdx++, new AnnotationDescription[]{AnnotationDescription.Builder.ofType(Argument.class).define("value", this.argIdx++).build()}).on((ElementMatcher)ElementMatchers.is((MethodDescription.InDefinedShape)this.method.getShape()))));
    }
}

