/*
 * Decompiled with CFR 0.152.
 */
package net.uptheinter.interceptify.internal;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.bytebuddy.description.annotation.AnnotationList;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.uptheinter.interceptify.internal.MetadataBase;
import net.uptheinter.interceptify.internal.ParameterMetadata;

class MethodMetadata
extends MetadataBase {
    private final MethodDescription.InDefinedShape method;

    public MethodMetadata(MethodDescription.InDefinedShape method) {
        this.method = method;
    }

    public boolean isConstructor() {
        return this.method.isConstructor();
    }

    public boolean isStatic() {
        return this.method.isStatic();
    }

    public boolean isInstanceMethod() {
        return !this.isStatic();
    }

    public MethodDescription.InDefinedShape getShape() {
        return this.method;
    }

    public Stream<ParameterMetadata> getParameters() {
        return this.method.getParameters().stream().map(ParameterMetadata::new);
    }

    public List<ParameterMetadata> getParameterList() {
        return this.getParameters().collect(Collectors.toList());
    }

    public String getName() {
        return this.method.getName();
    }

    public TypeDescription getDeclaringType() {
        return this.method.getDeclaringType();
    }

    @Override
    protected AnnotationList getInternal() {
        return this.method.getDeclaredAnnotations();
    }
}

