/*
 * Decompiled with CFR 0.152.
 */
package net.uptheinter.interceptify.internal;

import java.util.Arrays;
import java.util.stream.Stream;
import net.bytebuddy.description.ModifierReviewable;
import net.bytebuddy.description.annotation.AnnotationList;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.pool.TypePool;
import net.uptheinter.interceptify.internal.MetadataBase;
import net.uptheinter.interceptify.internal.MethodMetadata;

class ClassMetadata
extends MetadataBase {
    private final TypeDescription cls;

    public ClassMetadata(String classFile, TypePool typePool) {
        this.cls = typePool.describe(classFile).resolve();
    }

    public ClassMetadata(TypeDescription cls) {
        this.cls = cls;
    }

    public Stream<MethodMetadata> getMethodsWithAnnotation(Class<?> ... annotationType) {
        return this.cls.getDeclaredMethods().stream().filter(ModifierReviewable.OfByteCodeElement::isPublic).map(MethodMetadata::new).filter(m -> Arrays.stream(annotationType).anyMatch(m::hasAnnotation));
    }

    public Stream<MethodMetadata> getMethods() {
        return this.cls.getDeclaredMethods().stream().map(MethodMetadata::new);
    }

    public TypeDescription getTypeDesc() {
        return this.cls;
    }

    public String getTypeName() {
        return this.cls.getTypeName();
    }

    @Override
    protected AnnotationList getInternal() {
        return this.cls.getDeclaredAnnotations();
    }
}

