/*
 * Decompiled with CFR 0.152.
 */
package net.uptheinter.interceptify.internal;

import java.lang.instrument.Instrumentation;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.ClassFileLocator;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.dynamic.TypeResolutionStrategy;
import net.bytebuddy.dynamic.loading.ClassLoadingStrategy;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.MethodDelegation;
import net.bytebuddy.implementation.SuperMethodCall;
import net.bytebuddy.implementation.bind.annotation.Argument;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import net.bytebuddy.pool.TypePool;
import net.uptheinter.interceptify.annotations.InterceptClass;
import net.uptheinter.interceptify.annotations.OverwriteConstructor;
import net.uptheinter.interceptify.annotations.OverwriteMethod;
import net.uptheinter.interceptify.internal.ClassByteCodeLocator;
import net.uptheinter.interceptify.internal.ClassExposer;
import net.uptheinter.interceptify.internal.ClassMetadata;
import net.uptheinter.interceptify.internal.GranularTypePool;
import net.uptheinter.interceptify.internal.InterceptPair;
import net.uptheinter.interceptify.internal.MethodMetadata;
import net.uptheinter.interceptify.internal.ParameterMetadata;
import net.uptheinter.interceptify.internal.ParamsAnnotator;
import net.uptheinter.interceptify.internal.ParamsValidator;
import net.uptheinter.interceptify.util.Boxed;
import net.uptheinter.interceptify.util.JarEntryEx;
import net.uptheinter.interceptify.util.JarFileEx;
import net.uptheinter.interceptify.util.JarFiles;

class ClassInjector {
    private final ByteBuddy byteBuddy;
    private final ClassExposer classExposer;
    private final ClassByteCodeLocator byteCodeLocator = new ClassByteCodeLocator();
    private final List<ClassMetadata> classes = new ArrayList<ClassMetadata>();
    private final List<ClassMetadata> extraClasses = new ArrayList<ClassMetadata>();
    private ClassFileLocator classFileLocator;
    private GranularTypePool typePool;
    private final List<DynamicType.Unloaded<?>> defs = new ArrayList();

    public ClassInjector(ByteBuddy byteBuddy, Instrumentation instr) {
        this.byteBuddy = byteBuddy;
        this.classExposer = new ClassExposer(byteBuddy, () -> this.typePool, () -> this.byteCodeLocator, () -> this.classFileLocator);
        instr.addTransformer(this.classExposer);
    }

    public ClassInjector setClassPath(URL[] classPath) {
        this.classFileLocator = new ClassFileLocator.Compound(new ClassFileLocator[]{this.byteCodeLocator, new ClassFileLocator.ForUrl(classPath), ClassFileLocator.ForClassLoader.ofSystemLoader()});
        this.typePool = GranularTypePool.of(this.classFileLocator);
        return this;
    }

    public ClassInjector defineMakePublicList(Set<String> list) {
        this.classExposer.defineMakePublicList(list);
        return this;
    }

    public ClassInjector defineMakePublicPredicate(Predicate<String> pred) {
        this.classExposer.defineMakePublicPredicate(pred);
        return this;
    }

    public ClassInjector collectMetadataFrom(JarFiles jarFiles) {
        assert (this.classFileLocator != null);
        jarFiles.stream().map(JarFileEx::getClasses).flatMap(Collection::stream).map(JarEntryEx::getClassName).map(this::getClassMetadata).filter(this::filterUnannotated).forEach(this.classes::add);
        return this;
    }

    private boolean filterUnannotated(ClassMetadata cls) {
        if (cls.hasAnnotation(InterceptClass.class)) {
            return true;
        }
        this.extraClasses.add(cls);
        return false;
    }

    private ClassMetadata getClassMetadata(String classFile) {
        return new ClassMetadata(classFile, (TypePool)this.typePool);
    }

    public void applyAnnotationsAndIntercept() {
        HashMap interceptMap = this.classes.stream().collect(HashMap::new, (map, cls) -> map.computeIfAbsent(cls.getAnnotation(InterceptClass.class).value(), k -> new ArrayList()).add(cls), (a, b) -> {});
        this.extraClasses.forEach(this::addExtra);
        interceptMap.entrySet().stream().map(this::applyInterceptTo).flatMap(this::addInterceptee).forEach(this::addInterceptor);
        if (!this.defs.isEmpty()) {
            Boxed first = new Boxed(this.defs.remove(this.defs.size() - 1));
            this.defs.forEach(def -> first.run(it -> it.include(new DynamicType[]{def})));
            first.get().load(this.getClass().getClassLoader(), (ClassLoadingStrategy)ClassLoadingStrategy.Default.INJECTION);
        }
    }

    private void addExtra(ClassMetadata classMetadata) {
        DynamicType.Unloaded unloaded = this.byteBuddy.redefine(classMetadata.getTypeDesc(), this.classFileLocator).make((TypeResolutionStrategy)new TypeResolutionStrategy.Active(), (TypePool)this.typePool);
        this.defs.add(unloaded);
    }

    private InterceptPair applyInterceptTo(Map.Entry<String, List<ClassMetadata>> entry) {
        String target = entry.getKey();
        List<ClassMetadata> interceptors = entry.getValue();
        ClassMetadata targetedCls = new ClassMetadata(target, (TypePool)this.typePool);
        Boxed<DynamicType.Builder> intercepteeBuildBox = new Boxed<DynamicType.Builder>(this.byteBuddy.rebase(targetedCls.getTypeDesc(), this.classFileLocator));
        List<DynamicType.Unloaded<?>> unloadedInterceptors = interceptors.stream().map(cls -> this.annotateMethodsFor((ClassMetadata)cls, targetedCls)).map(this::refreshDefinitions).map(interceptor -> this.prepareMethodInterception((DynamicType.Unloaded<?>)interceptor, (Boxed<DynamicType.Builder<?>>)intercepteeBuildBox)).map(interceptor -> this.prepareConstructorInterception((DynamicType.Unloaded<?>)interceptor, (Boxed<DynamicType.Builder<?>>)intercepteeBuildBox)).collect(Collectors.toList());
        DynamicType.Unloaded unloadedInterceptee = intercepteeBuildBox.get().make((TypeResolutionStrategy)new TypeResolutionStrategy.Active(), (TypePool)this.typePool);
        return new InterceptPair(unloadedInterceptee, unloadedInterceptors);
    }

    private DynamicType.Unloaded<?> annotateMethodsFor(ClassMetadata cls, ClassMetadata targetedCls) {
        Boxed<DynamicType.Builder> buildBox = new Boxed<DynamicType.Builder>(this.byteBuddy.redefine(cls.getTypeDesc(), this.classFileLocator));
        cls.getMethodsWithAnnotation(OverwriteMethod.class, OverwriteConstructor.class).forEach(method -> this.tryAnnotateParamsFor(cls, (MethodMetadata)method, (Boxed<DynamicType.Builder<?>>)buildBox, targetedCls));
        return buildBox.get().make((TypeResolutionStrategy)new TypeResolutionStrategy.Active(), (TypePool)this.typePool);
    }

    private void tryAnnotateParamsFor(ClassMetadata cls, MethodMetadata method, Boxed<DynamicType.Builder<?>> builder, ClassMetadata targetedCls) {
        ParamsValidator paramsValidator = new ParamsValidator(method, targetedCls);
        MethodMetadata targetMethod = targetedCls.getMethods().filter(candidate -> (ClassInjector.isConstructorMatch(candidate, method) || ClassInjector.isMethodMatch(candidate, method)) && paramsValidator.isCompatible((MethodMetadata)candidate)).findAny().orElse(null);
        if (targetMethod == null) {
            System.err.println("ERROR: " + cls.getTypeName() + "::" + method.getName() + " does not match the signature of any targeted functions - Skipped");
        } else {
            new ParamsAnnotator(builder, method, targetMethod).annotate();
        }
    }

    private static boolean isMethodMatch(MethodMetadata candidate, MethodMetadata interceptor) {
        OverwriteMethod val = interceptor.getAnnotation(OverwriteMethod.class);
        return val != null && val.value().equals(candidate.getName());
    }

    private static boolean isConstructorMatch(MethodMetadata candidate, MethodMetadata interceptor) {
        return interceptor.hasAnnotation(OverwriteConstructor.class) && candidate.isConstructor();
    }

    private DynamicType.Unloaded<?> refreshDefinitions(DynamicType.Unloaded<?> staleClass) {
        String typeName = staleClass.getTypeDescription().getTypeName();
        this.byteCodeLocator.put(typeName, staleClass.getBytes());
        this.typePool.removeFromCache(typeName);
        TypeDescription type = this.typePool.describe(typeName).resolve();
        return this.byteBuddy.redefine(type, this.classFileLocator).make((TypeResolutionStrategy)new TypeResolutionStrategy.Active(), (TypePool)this.typePool);
    }

    private DynamicType.Unloaded<?> prepareMethodInterception(DynamicType.Unloaded<?> interceptor, Boxed<DynamicType.Builder<?>> buildBox) {
        ClassMetadata metadata = new ClassMetadata(interceptor.getTypeDescription());
        String[] methodIntercepts = (String[])metadata.getMethodsWithAnnotation(OverwriteMethod.class).map(method -> method.getAnnotation(OverwriteMethod.class)).map(OverwriteMethod::value).distinct().toArray(String[]::new);
        buildBox.run(builder -> builder.method((ElementMatcher)ElementMatchers.namedOneOf((String[])methodIntercepts)).intercept((Implementation)MethodDelegation.to((TypeDescription)interceptor.getTypeDescription())));
        return interceptor;
    }

    private DynamicType.Unloaded<?> prepareConstructorInterception(DynamicType.Unloaded<?> interceptor, Boxed<DynamicType.Builder<?>> buildBox) {
        new ClassMetadata(interceptor.getTypeDescription()).getMethodsWithAnnotation(OverwriteConstructor.class).forEach(constructor -> this.doConstructorInterception((MethodMetadata)constructor, interceptor, buildBox));
        return interceptor;
    }

    private void doConstructorInterception(MethodMetadata constructor, DynamicType.Unloaded<?> interceptor, Boxed<DynamicType.Builder<?>> buildBox) {
        List params = constructor.getParameters().filter(p -> p.hasAnnotation(Argument.class)).map(ParameterMetadata::getType).collect(Collectors.toList());
        buildBox.run(builder -> builder.constructor((ElementMatcher)ElementMatchers.takesGenericArguments((List)params)).intercept(this.computeCallSemantics(constructor, interceptor)));
    }

    private Implementation computeCallSemantics(MethodMetadata constructor, DynamicType.Unloaded<?> interceptor) {
        OverwriteConstructor semantics = constructor.getAnnotation(OverwriteConstructor.class);
        TypeDescription desc = interceptor.getTypeDescription();
        if (semantics.after() && !semantics.before()) {
            return SuperMethodCall.INSTANCE.andThen((Implementation.Composable)MethodDelegation.to((TypeDescription)desc));
        }
        if (semantics.before() && !semantics.after()) {
            return MethodDelegation.to((TypeDescription)desc).andThen((Implementation.Composable)SuperMethodCall.INSTANCE);
        }
        if (semantics.before()) {
            return MethodDelegation.to((TypeDescription)desc).andThen((Implementation.Composable)SuperMethodCall.INSTANCE).andThen((Implementation.Composable)MethodDelegation.to((TypeDescription)desc));
        }
        throw new RuntimeException("ERROR: " + desc.getName() + " has OverwriteConstructor with neither before or after == true");
    }

    private Stream<DynamicType.Unloaded<?>> addInterceptee(InterceptPair pair) {
        this.defs.add(pair.getInterceptee());
        return pair.getInterceptors().stream();
    }

    private void addInterceptor(DynamicType.Unloaded<?> interceptor) {
        this.defs.add(interceptor);
    }
}

