/*
 * Decompiled with CFR 0.152.
 */
package net.uptheinter.interceptify.internal;

import java.lang.instrument.ClassFileTransformer;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.asm.AsmVisitorWrapper;
import net.bytebuddy.asm.ModifierAdjustment;
import net.bytebuddy.asm.TypeReferenceAdjustment;
import net.bytebuddy.description.field.FieldDescription;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.modifier.EnumerationState;
import net.bytebuddy.description.modifier.FieldManifestation;
import net.bytebuddy.description.modifier.FieldPersistence;
import net.bytebuddy.description.modifier.MethodArguments;
import net.bytebuddy.description.modifier.MethodManifestation;
import net.bytebuddy.description.modifier.MethodStrictness;
import net.bytebuddy.description.modifier.ModifierContributor;
import net.bytebuddy.description.modifier.Ownership;
import net.bytebuddy.description.modifier.SynchronizationState;
import net.bytebuddy.description.modifier.SyntheticState;
import net.bytebuddy.description.modifier.TypeManifestation;
import net.bytebuddy.description.modifier.Visibility;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.ClassFileLocator;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import net.bytebuddy.pool.TypePool;
import net.uptheinter.interceptify.internal.ClassByteCodeLocator;
import net.uptheinter.interceptify.internal.GranularTypePool;
import net.uptheinter.interceptify.util.Boxed;

class ClassExposer
implements ClassFileTransformer {
    private final ByteBuddy byteBuddy;
    private final Supplier<GranularTypePool> typePoolSupplier;
    private final Supplier<ClassByteCodeLocator> locatorSupplier;
    private final Supplier<ClassFileLocator> compoundSupplier;
    private Predicate<String> shouldMakePublic = s -> false;
    private Set<String> toMakePublic = new HashSet<String>();

    public ClassExposer(ByteBuddy byteBuddy, Supplier<GranularTypePool> typePoolSupplier, Supplier<ClassByteCodeLocator> locatorSupplier, Supplier<ClassFileLocator> compoundLocator) {
        this.byteBuddy = byteBuddy;
        this.typePoolSupplier = typePoolSupplier;
        this.locatorSupplier = locatorSupplier;
        this.compoundSupplier = compoundLocator;
    }

    public ClassExposer defineMakePublicList(Set<String> toMakePublic) {
        this.toMakePublic = toMakePublic;
        return this;
    }

    public ClassExposer defineMakePublicPredicate(Predicate<String> shouldMakePublic) {
        this.shouldMakePublic = shouldMakePublic;
        return this;
    }

    private void updateClass(String name, byte[] bytes) {
        this.typePoolSupplier.get().removeFromCache(name);
        this.locatorSupplier.get().put(name, bytes);
    }

    @Override
    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) {
        if (!this.toMakePublic.contains(className = className.replace('/', '.')) && !this.shouldMakePublic.test(className)) {
            return classfileBuffer;
        }
        this.updateClass(className, classfileBuffer);
        TypeDescription cls = this.typePoolSupplier.get().describe(className).resolve();
        if (cls.isEnum()) {
            this.updateClass("L" + className + ";", classfileBuffer);
        }
        byte[] transformed = this.makeAllPublic(cls);
        this.updateClass(className, transformed);
        return transformed;
    }

    @Override
    public byte[] transform(Module module, ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) {
        return this.transform(loader, className, classBeingRedefined, protectionDomain, classfileBuffer);
    }

    private void applyModifiersFor(TypeDescription type, List<ModifierContributor> list) {
        list.add((ModifierContributor)TypeManifestation.PLAIN);
        if (type.isAnnotation()) {
            list.add((ModifierContributor)TypeManifestation.ANNOTATION);
        } else if (type.isInterface()) {
            list.add((ModifierContributor)TypeManifestation.INTERFACE);
        } else if (type.isAbstract()) {
            list.add((ModifierContributor)TypeManifestation.ABSTRACT);
        }
        if (type.isEnum()) {
            list.add((ModifierContributor)EnumerationState.ENUMERATION);
        }
        if (type.isStatic()) {
            list.add((ModifierContributor)Ownership.STATIC);
        }
    }

    private void applyModifiersFor(MethodDescription method, List<ModifierContributor> list) {
        list.add((ModifierContributor)MethodManifestation.PLAIN);
        if (method.isVarArgs()) {
            list.add((ModifierContributor)MethodArguments.VARARGS);
        }
        if (method.isStrict()) {
            list.add((ModifierContributor)MethodStrictness.STRICT);
        }
        if (method.isAbstract()) {
            list.add((ModifierContributor)MethodManifestation.ABSTRACT);
        }
        if (method.isNative()) {
            list.add((ModifierContributor)MethodManifestation.NATIVE);
        }
        if (method.isBridge()) {
            list.add((ModifierContributor)MethodManifestation.BRIDGE);
        }
        if (method.isSynchronized()) {
            list.add((ModifierContributor)SynchronizationState.SYNCHRONIZED);
        }
        if (method.isStatic()) {
            list.add((ModifierContributor)Ownership.STATIC);
        }
    }

    private void applyModifiersFor(FieldDescription field, TypeDescription cls, List<ModifierContributor> list) {
        list.add((ModifierContributor)FieldManifestation.PLAIN);
        if (field.isVolatile()) {
            list.add((ModifierContributor)FieldManifestation.VOLATILE);
        }
        if (field.isSynthetic()) {
            list.add((ModifierContributor)SyntheticState.SYNTHETIC);
        }
        if (field.isTransient()) {
            list.add((ModifierContributor)FieldPersistence.TRANSIENT);
        }
        if (field.isStatic()) {
            list.add((ModifierContributor)Ownership.STATIC);
        }
        if (cls.isInterface()) {
            list.add((ModifierContributor)FieldManifestation.FINAL);
        }
    }

    private <R extends ModifierContributor> List<R> getManifestation(FieldDescription obj, TypeDescription cls) {
        ArrayList<ModifierContributor> ret = new ArrayList<ModifierContributor>(6);
        ret.add((ModifierContributor)Visibility.PUBLIC);
        this.applyModifiersFor(obj, cls, ret);
        return ret;
    }

    private <R extends ModifierContributor, T> List<R> getManifestation(T obj) {
        ArrayList<ModifierContributor> ret = new ArrayList<ModifierContributor>(6);
        ret.add((ModifierContributor)Visibility.PUBLIC);
        if (obj instanceof TypeDescription) {
            this.applyModifiersFor((TypeDescription)obj, ret);
        } else if (obj instanceof MethodDescription) {
            this.applyModifiersFor((MethodDescription)obj, ret);
        }
        return ret;
    }

    private byte[] makeAllPublic(TypeDescription cls) {
        return (byte[])this.makeTypeDescPublic(cls, new Boxed(this.byteBuddy.redefine(cls, this.compoundSupplier.get()))).get().make((TypePool)this.typePoolSupplier.get()).getBytes().clone();
    }

    public Boxed<DynamicType.Builder<?>> makeTypeDescPublic(TypeDescription cls, Boxed<DynamicType.Builder<?>> typeBuilder) {
        Boxed<ModifierAdjustment> adjust = new Boxed<ModifierAdjustment>(new ModifierAdjustment());
        adjust.run(builder -> builder.withTypeModifiers(this.getManifestation(cls)));
        cls.getDeclaredMethods().stream().filter(method -> !method.isPublic() || method.isFinal()).forEach(method -> adjust.run(builder -> builder.withMethodModifiers((ElementMatcher)ElementMatchers.is((MethodDescription.InDefinedShape)method), this.getManifestation(method))));
        cls.getDeclaredFields().stream().filter(field -> !field.isPublic() || field.isFinal()).forEach(field -> adjust.run(builder -> builder.withFieldModifiers((ElementMatcher)ElementMatchers.is((FieldDescription.InDefinedShape)field), this.getManifestation((FieldDescription)field, cls))));
        return typeBuilder.run(builder -> builder.visit((AsmVisitorWrapper)adjust.get()).visit((AsmVisitorWrapper)TypeReferenceAdjustment.strict()));
    }
}

